"""
    SatNOGS DB

    SatNOGS DB is a crowdsourced database of details about orbital                     satellites and data collected from them.  # noqa: E501

    The version of the OpenAPI document: 1.1
    Contact: dev@satnogs.org
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from satnogsdbapiclient.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)
from ..model_utils import OpenApiModel
from satnogsdbapiclient.exceptions import ApiAttributeError


def lazy_import():
    from satnogsdbapiclient.model.type_enum import TypeEnum
    globals()['TypeEnum'] = TypeEnum


class Transmitter(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
    }

    validations = {
        ('uplink_low',): {
            'inclusive_maximum': 40000000000,
            'inclusive_minimum': 0,
        },
        ('uplink_high',): {
            'inclusive_maximum': 40000000000,
            'inclusive_minimum': 0,
        },
        ('uplink_drift',): {
            'inclusive_maximum': 99999,
            'inclusive_minimum': -99999,
        },
        ('downlink_low',): {
            'inclusive_maximum': 40000000000,
            'inclusive_minimum': 0,
        },
        ('downlink_high',): {
            'inclusive_maximum': 40000000000,
            'inclusive_minimum': 0,
        },
        ('downlink_drift',): {
            'inclusive_maximum': 99999,
            'inclusive_minimum': -99999,
        },
        ('baud',): {
            'inclusive_minimum': 0,
        },
        ('citation',): {
            'max_length': 512,
        },
        ('iaru_coordination_url',): {
            'max_length': 200,
        },
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'uuid': (str,),  # noqa: E501
            'description': (str,),  # noqa: E501
            'alive': (bool,),  # noqa: E501
            'mode': (int,),  # noqa: E501
            'mode_id': (int,),  # noqa: E501
            'uplink_mode': (int,),  # noqa: E501
            'sat_id': (str,),  # noqa: E501
            'norad_cat_id': (int,),  # noqa: E501
            'updated': (datetime,),  # noqa: E501
            'type': (TypeEnum,),  # noqa: E501
            'uplink_low': (int, none_type,),  # noqa: E501
            'uplink_high': (int, none_type,),  # noqa: E501
            'uplink_drift': (int, none_type,),  # noqa: E501
            'downlink_low': (int, none_type,),  # noqa: E501
            'downlink_high': (int, none_type,),  # noqa: E501
            'downlink_drift': (int, none_type,),  # noqa: E501
            'invert': (bool,),  # noqa: E501
            'baud': (float, none_type,),  # noqa: E501
            'status': (bool, date, datetime, dict, float, int, list, str, none_type,),  # noqa: E501
            'citation': (str,),  # noqa: E501
            'service': (bool, date, datetime, dict, float, int, list, str, none_type,),  # noqa: E501
            'iaru_coordination': (bool, date, datetime, dict, float, int, list, str, none_type,),  # noqa: E501
            'iaru_coordination_url': (str,),  # noqa: E501
            'itu_coordination': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'uuid': 'uuid',  # noqa: E501
        'description': 'description',  # noqa: E501
        'alive': 'alive',  # noqa: E501
        'mode': 'mode',  # noqa: E501
        'mode_id': 'mode_id',  # noqa: E501
        'uplink_mode': 'uplink_mode',  # noqa: E501
        'sat_id': 'sat_id',  # noqa: E501
        'norad_cat_id': 'norad_cat_id',  # noqa: E501
        'updated': 'updated',  # noqa: E501
        'type': 'type',  # noqa: E501
        'uplink_low': 'uplink_low',  # noqa: E501
        'uplink_high': 'uplink_high',  # noqa: E501
        'uplink_drift': 'uplink_drift',  # noqa: E501
        'downlink_low': 'downlink_low',  # noqa: E501
        'downlink_high': 'downlink_high',  # noqa: E501
        'downlink_drift': 'downlink_drift',  # noqa: E501
        'invert': 'invert',  # noqa: E501
        'baud': 'baud',  # noqa: E501
        'status': 'status',  # noqa: E501
        'citation': 'citation',  # noqa: E501
        'service': 'service',  # noqa: E501
        'iaru_coordination': 'iaru_coordination',  # noqa: E501
        'iaru_coordination_url': 'iaru_coordination_url',  # noqa: E501
        'itu_coordination': 'itu_coordination',  # noqa: E501
    }

    read_only_vars = {
        'uuid',  # noqa: E501
        'alive',  # noqa: E501
        'mode',  # noqa: E501
        'mode_id',  # noqa: E501
        'uplink_mode',  # noqa: E501
        'sat_id',  # noqa: E501
        'norad_cat_id',  # noqa: E501
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, uuid, description, alive, mode, mode_id, uplink_mode, sat_id, norad_cat_id, updated, *args, **kwargs):  # noqa: E501
        """Transmitter - a model defined in OpenAPI

        Args:
            uuid (str):
            description (str): Short description for this entry, like: UHF 9k6 AFSK Telemetry
            alive (bool):
            mode (int):
            mode_id (int):
            uplink_mode (int):
            sat_id (str):
            norad_cat_id (int):
            updated (datetime):

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            type (TypeEnum): [optional]  # noqa: E501
            uplink_low (int, none_type): Frequency (in Hz) for the uplink, or bottom of the uplink range for a             transponder. [optional]  # noqa: E501
            uplink_high (int, none_type): Frequency (in Hz) for the top of the uplink range for a transponder. [optional]  # noqa: E501
            uplink_drift (int, none_type): Receiver drift from the published uplink frequency, stored in parts             per billion (PPB). [optional]  # noqa: E501
            downlink_low (int, none_type): Frequency (in Hz) for the downlink, or bottom of the downlink range             for a transponder. [optional]  # noqa: E501
            downlink_high (int, none_type): Frequency (in Hz) for the top of the downlink range for a transponder. [optional]  # noqa: E501
            downlink_drift (int, none_type): Transmitter drift from the published downlink frequency, stored in             parts per billion (PPB). [optional]  # noqa: E501
            invert (bool): True if this is an inverted transponder. [optional]  # noqa: E501
            baud (float, none_type): The number of modulated symbols that the transmitter sends every second. [optional]  # noqa: E501
            status (bool, date, datetime, dict, float, int, list, str, none_type): Functional state of this transmitter. [optional]  # noqa: E501
            citation (str): A reference (preferrably URL) for this entry or edit. [optional]  # noqa: E501
            service (bool, date, datetime, dict, float, int, list, str, none_type): The published usage category for this transmitter. [optional]  # noqa: E501
            iaru_coordination (bool, date, datetime, dict, float, int, list, str, none_type): IARU frequency coordination status for this transmitter. [optional]  # noqa: E501
            iaru_coordination_url (str): URL for more details on this frequency coordination. [optional]  # noqa: E501
            itu_coordination ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.uuid = uuid
        self.description = description
        self.alive = alive
        self.mode = mode
        self.mode_id = mode_id
        self.uplink_mode = uplink_mode
        self.sat_id = sat_id
        self.norad_cat_id = norad_cat_id
        self.updated = updated
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, description, updated, *args, **kwargs):  # noqa: E501
        """Transmitter - a model defined in OpenAPI

            description (str): Short description for this entry, like: UHF 9k6 AFSK Telemetry
            updated (datetime):

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            type (TypeEnum): [optional]  # noqa: E501
            uplink_low (int, none_type): Frequency (in Hz) for the uplink, or bottom of the uplink range for a             transponder. [optional]  # noqa: E501
            uplink_high (int, none_type): Frequency (in Hz) for the top of the uplink range for a transponder. [optional]  # noqa: E501
            uplink_drift (int, none_type): Receiver drift from the published uplink frequency, stored in parts             per billion (PPB). [optional]  # noqa: E501
            downlink_low (int, none_type): Frequency (in Hz) for the downlink, or bottom of the downlink range             for a transponder. [optional]  # noqa: E501
            downlink_high (int, none_type): Frequency (in Hz) for the top of the downlink range for a transponder. [optional]  # noqa: E501
            downlink_drift (int, none_type): Transmitter drift from the published downlink frequency, stored in             parts per billion (PPB). [optional]  # noqa: E501
            invert (bool): True if this is an inverted transponder. [optional]  # noqa: E501
            baud (float, none_type): The number of modulated symbols that the transmitter sends every second. [optional]  # noqa: E501
            status (bool, date, datetime, dict, float, int, list, str, none_type): Functional state of this transmitter. [optional]  # noqa: E501
            citation (str): A reference (preferrably URL) for this entry or edit. [optional]  # noqa: E501
            service (bool, date, datetime, dict, float, int, list, str, none_type): The published usage category for this transmitter. [optional]  # noqa: E501
            iaru_coordination (bool, date, datetime, dict, float, int, list, str, none_type): IARU frequency coordination status for this transmitter. [optional]  # noqa: E501
            iaru_coordination_url (str): URL for more details on this frequency coordination. [optional]  # noqa: E501
            itu_coordination ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.description = description
        self.updated = updated
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
