"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
const assert = require("assert");
const client_lambda_shared_1 = require("../../../../backend/deny-list/client.lambda-shared");
const RULE1 = {
    package: 'mypackage',
    reason: '"mypackage" is deprecated',
};
const RULE2 = {
    package: 'your',
    version: '1.2.3',
    reason: 'v1.2.3 of "your" has a security issue',
};
async function handler() {
    const client = await client_lambda_shared_1.DenyListClient.newClient();
    assert.deepStrictEqual(client.map, {
        'mypackage': RULE1,
        'your/v1.2.3': RULE2,
    });
    assert.deepStrictEqual(client.lookup('mypackage', '1.2.3'), RULE1);
    assert.deepStrictEqual(client.lookup('mypackage', '1.0.1'), RULE1);
    assert.deepStrictEqual(client.lookup('your', '1.0.0'), undefined);
    assert.deepStrictEqual(client.lookup('your', '1.2.3'), RULE2);
    assert.deepStrictEqual(client.lookup('boom', '1.2.3'), undefined);
}
exports.handler = handler;
//# sourceMappingURL=data:application/json;base64,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