"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
const AWS = require("aws-sdk");
const env_lambda_shared_1 = require("../../../../backend/shared/env.lambda-shared");
const s3 = new AWS.S3();
async function handler() {
    const bucketName = env_lambda_shared_1.requireEnv('BUCKET_NAME');
    const timeoutSec = parseInt(env_lambda_shared_1.requireEnv('TIMEOUT_SEC'));
    const expectedKeys = JSON.parse(env_lambda_shared_1.requireEnv('EXPECTED_KEYS'));
    const expected = canonicalRepresentation(expectedKeys);
    console.log(JSON.stringify({ expected: expectedKeys }));
    const startTime = Date.now();
    let actual;
    while ((Date.now() - startTime) / 1000 < timeoutSec) {
        actual = canonicalRepresentation(await getAllObjectKeys(bucketName));
        console.log(JSON.stringify({ keys: actual }));
        if (actual === expected) {
            console.log('assertion succeeded');
            return;
        }
    }
    throw new Error(`assertion failed. the following objects were not deleted after ${timeoutSec}s. Actual: ${actual}. Expected: ${expected}`);
}
exports.handler = handler;
async function getAllObjectKeys(bucket) {
    var _a;
    let continuationToken;
    const objectKeys = new Array();
    do {
        const listRequest = {
            Bucket: bucket,
            ContinuationToken: continuationToken,
        };
        console.log(JSON.stringify({ listRequest }));
        const listResponse = await s3.listObjectsV2(listRequest).promise();
        console.log(JSON.stringify({ listResponse }));
        continuationToken = listResponse.NextContinuationToken;
        for (const { Key: key } of (_a = listResponse.Contents) !== null && _a !== void 0 ? _a : []) {
            if (!key) {
                continue;
            }
            objectKeys.push(key);
        }
    } while (continuationToken);
    return objectKeys;
}
function canonicalRepresentation(list) {
    return JSON.stringify(list.sort());
}
//# sourceMappingURL=data:application/json;base64,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