import type { Context } from 'aws-lambda';
import * as _AWS from 'aws-sdk';
export declare function s3(): AWS.S3;
/**
 * Puts an object in an S3 bucket while adding metadata corresponding to the
 * current Lambda context.
 *
 * @param context the Lambda context that is being used.
 * @param bucket  the S3 bucket where to put the object.
 * @param key     the S3 key to be used.
 * @param body    the body of the object to be put.
 * @param opts    additional options for the S3 request.
 */
export declare function s3PutObject(context: Context, bucket: string, key: string, body: AWS.S3.Body, opts?: Omit<AWS.S3.PutObjectRequest, 'Bucket' | 'Key' | 'Body'>): Promise<import("aws-sdk/lib/request").PromiseResult<_AWS.S3.PutObjectOutput, _AWS.AWSError>>;
/**
 * Checks whether an object exists in S3 at the provided bucket and key.
 */
export declare function s3ObjectExists(bucket: string, key: string): Promise<boolean>;
export declare function sqs(): AWS.SQS;
export declare function stepFunctions(): AWS.StepFunctions;
export declare function lambda(): AWS.Lambda;
/**
 * Sends the supplied messages to the designated SQS queue url using the
 * `SendMessageBatch` API, for maximum throughput. This encodes the provided
 * messages using `JSON.stringify` and creates batches as large as possible.
 *
 * @param queueUrl the URL of the queue where to send the messages
 * @param messages the messages to be sent
 */
export declare function sqsSendMessageBatch(queueUrl: string, messages: readonly any[]): Promise<void>;
/**
 * Resets all clients vended by this module. This is useful in unit tests when
 * `aws-sdk-mocks` is used, so that new mocks are injected as intended.
 */
export declare function reset(): void;
