# Generated by Django 3.2 on 2021-06-08 13:55

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('wcd_geo_db', '0001_initial'),
    ]

    operations = [
        migrations.AlterField(
            model_name='division',
            name='codes',
            field=models.JSONField(blank=True, default=dict, verbose_name='Codes'),
        ),
        migrations.AlterField(
            model_name='division',
            name='parent',
            field=models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.SET_NULL, to='wcd_geo_db.division', verbose_name='Parent entity'),
        ),
        migrations.AlterField(
            model_name='place',
            name='codes',
            field=models.JSONField(blank=True, default=dict, verbose_name='Codes'),
        ),
        migrations.AlterField(
            model_name='place',
            name='grouping',
            field=models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.SET_NULL, to='wcd_geo_db.place', verbose_name='Grouping entity'),
        ),
        migrations.AlterField(
            model_name='route',
            name='codes',
            field=models.JSONField(blank=True, default=dict, verbose_name='Codes'),
        ),
        migrations.AlterField(
            model_name='route',
            name='grouping',
            field=models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.SET_NULL, to='wcd_geo_db.route', verbose_name='Grouping entity'),
        ),
        migrations.CreateModel(
            name='DivisionName',
            fields=[
                ('name', models.TextField(verbose_name='Name')),
                ('id', models.BigAutoField(primary_key=True, serialize=False, verbose_name='ID')),
                ('level', models.SmallIntegerField(choices=[(1200, 'Country'), (1410, 'Administrative division: Level 1'), (1420, 'Administrative division: Level 2'), (1430, 'Administrative division: Level 3'), (1440, 'Administrative division: Level 4'), (1450, 'Administrative division: Level 5'), (1600, 'Locality'), (1810, 'Locality division: Level 1'), (1820, 'Locality division: Level 2'), (1830, 'Locality division: Level 3'), (1840, 'Locality division: Level 4'), (1850, 'Locality division: Level 5')], verbose_name='Division level')),
                ('country', models.ForeignKey(limit_choices_to={'level': 1200}, on_delete=django.db.models.deletion.CASCADE, to='wcd_geo_db.division', verbose_name='Division')),
            ],
            options={
                'verbose_name': 'Division name',
                'verbose_name_plural': 'Division names',
                'unique_together': {('country_id', 'level')},
            },
        ),
    ]
