# Generated by Django 2.2.4 on 2019-08-10 23:16

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Country',
            fields=[
                ('created_at', models.DateTimeField(auto_now_add=True, null=True)),
                ('updated_at', models.DateTimeField(auto_now=True, null=True)),
                ('deleted_at', models.DateTimeField(blank=True, null=True)),
                ('id', models.AutoField(primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=200, verbose_name='Name')),
                ('states', models.TextField(blank=True, help_text='List of states',
                                            null=True, verbose_name='States')),
                ('code', models.CharField(blank=True, max_length=10, null=True,
                                          verbose_name='Code')),
                ('phone_code', models.CharField(blank=True, max_length=10, null=True,
                                                verbose_name='Phone Code')),
                ('currency_code', models.CharField(blank=True, max_length=10, null=True,
                                                   verbose_name='Currency Code')),
            ],
            options={
                'ordering': ('-id',),
                'verbose_name_plural': 'Countries',
                'verbose_name': 'Country',
            },
        ),
        migrations.CreateModel(
            name='District',
            fields=[
                ('created_at', models.DateTimeField(auto_now_add=True, null=True)),
                ('updated_at', models.DateTimeField(auto_now=True, null=True)),
                ('deleted_at', models.DateTimeField(blank=True, null=True)),
                ('id', models.AutoField(primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=200, verbose_name='Name')),
            ],
            options={
                'ordering': ('-id',),
                'verbose_name_plural': 'Districts',
                'verbose_name': 'District',
            },
        ),
        migrations.CreateModel(
            name='SubDistrict',
            fields=[
                ('created_at', models.DateTimeField(auto_now_add=True, null=True)),
                ('updated_at', models.DateTimeField(auto_now=True, null=True)),
                ('deleted_at', models.DateTimeField(blank=True, null=True)),
                ('id', models.AutoField(primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=200, verbose_name='Name')),
                ('postal_code', models.CharField(blank=True, max_length=10, null=True,
                                                 verbose_name='Postal Code')),
                ('district', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE,
                                               related_name='sub_districts',
                                               to='django_address.District',
                                               verbose_name='District')),
            ],
            options={
                'ordering': ('-id',),
                'verbose_name_plural': 'Sub Districts',
                'verbose_name': 'Sub District',
            },
        ),
        migrations.CreateModel(
            name='Province',
            fields=[
                ('created_at', models.DateTimeField(auto_now_add=True, null=True)),
                ('updated_at', models.DateTimeField(auto_now=True, null=True)),
                ('deleted_at', models.DateTimeField(blank=True, null=True)),
                ('id', models.AutoField(primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=200, verbose_name='Name')),
                ('country', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE,
                                              related_name='provinces',
                                              to='django_address.Country',
                                              verbose_name='Country')),
            ],
            options={
                'ordering': ('-id',),
                'verbose_name_plural': 'Provinces',
                'verbose_name': 'Province',
            },
        ),
        migrations.AddField(
            model_name='district',
            name='province',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE,
                                    related_name='districts',
                                    to='django_address.Province',
                                    verbose_name='Province'),
        ),
    ]
