/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.iterator;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.query.BindingQueryPlan;
import com.hp.hpl.jena.graph.query.Domain;
import com.hp.hpl.jena.graph.query.Query;
import com.hp.hpl.jena.graph.query.QueryHandler;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.ExecUtils;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingMap;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIter;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterRepeatApply;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.util.ALog;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import com.hp.hpl.jena.sparql.util.IndentedWriter;
import com.hp.hpl.jena.sparql.util.Utils;
import com.hp.hpl.jena.util.iterator.ClosableIterator;
import java.util.HashSet;

public class QueryIterBlockTriplesQH
extends QueryIterRepeatApply {
    private BasicPattern pattern;

    public static QueryIterator create(QueryIterator input, BasicPattern pattern, ExecutionContext cxt) {
        return new QueryIterBlockTriplesQH(input, pattern, cxt);
    }

    private QueryIterBlockTriplesQH(QueryIterator input, BasicPattern pattern, ExecutionContext cxt) {
        super(input, cxt);
        this.pattern = pattern;
    }

    public QueryIterator nextStage(Binding binding) {
        return new StagePattern(binding, this.pattern, this.getExecContext());
    }

    private static Binding graphResultsToBinding(Binding parent, Domain d, Var[] projectionVars) {
        BindingMap binding = new BindingMap(parent);
        for (int i = 0; i < projectionVars.length; ++i) {
            Var var = projectionVars[i];
            Node n = (Node)d.get(i);
            if (n == null) continue;
            binding.add(var, n);
        }
        return binding;
    }

    protected void details(IndentedWriter out, SerializationContext sCxt) {
        out.print(Utils.className(this));
        out.println();
        out.incIndent();
        FmtUtils.formatPattern(out, this.pattern, sCxt);
        out.decIndent();
    }

    static class StagePattern
    extends QueryIter {
        ClosableIterator graphIter;
        Binding binding;
        Var[] projectionVars;

        public StagePattern(Binding binding, BasicPattern pattern, ExecutionContext qCxt) {
            super(qCxt);
            this.binding = binding;
            QueryHandler qh = qCxt.getActiveGraph().queryHandler();
            Query graphQuery = new Query();
            HashSet vars = new HashSet();
            ExecUtils.compilePattern(graphQuery, pattern.getList(), binding, vars);
            this.projectionVars = ExecUtils.projectionVars(vars);
            BindingQueryPlan plan = qh.prepareBindings(graphQuery, (Node[])this.projectionVars);
            this.graphIter = plan.executeBindings();
            if (this.graphIter == null) {
                ALog.warn(this, "Graph Iterator is null");
            }
        }

        protected boolean hasNextBinding() {
            boolean isMore = this.graphIter.hasNext();
            return isMore;
        }

        protected Binding moveToNextBinding() {
            Domain d = (Domain)this.graphIter.next();
            Binding b = QueryIterBlockTriplesQH.graphResultsToBinding(this.binding, d, this.projectionVars);
            return b;
        }

        protected void closeIterator() {
            if (!this.isFinished()) {
                if (this.graphIter != null) {
                    this.graphIter.close();
                }
                this.graphIter = null;
            }
        }
    }
}

