/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.main;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpVars;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterFilterExpr;
import com.hp.hpl.jena.sparql.engine.main.OpCompiler;
import com.hp.hpl.jena.sparql.engine.main.StageBuilder;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.util.VarUtils;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public class FilterPlacement {
    private OpCompiler compiler;
    private ExecutionContext execCxt;
    boolean doFilterPlacement = false;

    public FilterPlacement(OpCompiler compiler, ExecutionContext execCxt) {
        this.compiler = compiler;
        this.execCxt = execCxt;
        this.doFilterPlacement = execCxt.getContext().isTrueOrUndef(ARQ.filterPlacement);
    }

    public QueryIterator placeFiltersBGP(ExprList exprs, BasicPattern pattern, QueryIterator input) {
        if (!this.doFilterPlacement) {
            QueryIterator qIter = StageBuilder.compile(pattern, input, this.execCxt);
            return this.buildFilter(exprs, qIter);
        }
        exprs = new ExprList(exprs);
        QueryIterator qIter = this.placeFiltersWorker(exprs, pattern, input);
        qIter = this.buildFilter(exprs, qIter);
        return qIter;
    }

    private QueryIterator placeFiltersWorker(ExprList exprs, BasicPattern pattern, QueryIterator input) {
        BasicPattern accPattern = new BasicPattern();
        HashSet patternVarsScope = new HashSet();
        QueryIterator qIter = input;
        if ((qIter = this.insertAnyFilter(exprs, patternVarsScope, accPattern, qIter)) == null) {
            qIter = input;
        }
        ListIterator iter = pattern.iterator();
        while (iter.hasNext()) {
            Triple triple = (Triple)iter.next();
            accPattern.add(triple);
            VarUtils.addVarsFromTriple(patternVarsScope, triple);
            QueryIterator qIter2 = this.insertAnyFilter(exprs, patternVarsScope, accPattern, qIter);
            if (qIter2 == null) continue;
            accPattern = new BasicPattern();
            qIter = qIter2;
        }
        qIter = StageBuilder.compile(accPattern, qIter, this.execCxt);
        return qIter;
    }

    private QueryIterator insertAnyFilter(ExprList exprs, Set patternVarsScope, BasicPattern accPattern, QueryIterator qIter) {
        boolean doneSomething = false;
        Iterator iter = exprs.iterator();
        while (iter.hasNext()) {
            Expr expr = (Expr)iter.next();
            Set exprVars = expr.getVarsMentioned();
            if (!patternVarsScope.containsAll(exprVars)) continue;
            QueryIterator qIter2 = this.buildPatternFilter(expr, accPattern, qIter);
            iter.remove();
            qIter = qIter2;
            doneSomething = true;
        }
        return doneSomething ? qIter : null;
    }

    public QueryIterator placeFiltersJoin(ExprList exprs, List ops, QueryIterator input) {
        HashSet varScope = new HashSet();
        QueryIterator qIter = input;
        if ((qIter = this.insertAnyFilter(exprs, varScope, qIter)) == null) {
            qIter = input;
        }
        Iterator iter = ops.iterator();
        while (iter.hasNext()) {
            Op op = (Op)iter.next();
            if (op instanceof OpBGP) {
                OpBGP bgp = (OpBGP)op;
                BasicPattern pattern = bgp.getPattern();
                qIter = this.placeFiltersWorker(exprs, pattern, qIter);
            } else {
                qIter = this.compiler.compileOp(op, qIter);
            }
            OpVars.patternVars(op, varScope);
            qIter = this.insertAnyFilter(exprs, varScope, qIter);
        }
        qIter = this.buildFilter(exprs, qIter);
        return qIter;
    }

    private QueryIterator insertAnyFilter(ExprList exprs, Set varScope, QueryIterator qIter) {
        Iterator iter = exprs.iterator();
        while (iter.hasNext()) {
            Expr expr = (Expr)iter.next();
            Set exprVars = expr.getVarsMentioned();
            if (!varScope.containsAll(exprVars)) continue;
            qIter = new QueryIterFilterExpr(qIter, expr, this.execCxt);
            iter.remove();
        }
        return qIter;
    }

    public QueryIterator buildOpFilter(ExprList exprs, Op sub, QueryIterator input) {
        QueryIterator qIter = this.compiler.compileOp(sub, input);
        Iterator iter = exprs.iterator();
        while (iter.hasNext()) {
            Expr expr = (Expr)iter.next();
            qIter = new QueryIterFilterExpr(qIter, expr, this.execCxt);
        }
        return qIter;
    }

    private QueryIterator buildOpFilter(Expr expr, Op op, QueryIterator input) {
        QueryIterator qIter = this.compiler.compileOp(op, input);
        qIter = new QueryIterFilterExpr(qIter, expr, this.execCxt);
        return qIter;
    }

    private QueryIterator buildPatternFilter(Expr expr, BasicPattern pattern, QueryIterator input) {
        QueryIterator qIter = StageBuilder.compile(pattern, input, this.execCxt);
        qIter = new QueryIterFilterExpr(qIter, expr, this.execCxt);
        return qIter;
    }

    private QueryIterator buildFilter(ExprList exprs, QueryIterator qIter) {
        if (exprs.isEmpty()) {
            return qIter;
        }
        Iterator iter = exprs.iterator();
        while (iter.hasNext()) {
            Expr expr = (Expr)iter.next();
            qIter = new QueryIterFilterExpr(qIter, expr, this.execCxt);
        }
        return qIter;
    }
}

