/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.ref;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.QueryExecException;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpVisitor;
import com.hp.hpl.jena.sparql.algebra.Table;
import com.hp.hpl.jena.sparql.algebra.TableFactory;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.algebra.op.OpDatasetNames;
import com.hp.hpl.jena.sparql.algebra.op.OpDiff;
import com.hp.hpl.jena.sparql.algebra.op.OpDistinct;
import com.hp.hpl.jena.sparql.algebra.op.OpExt;
import com.hp.hpl.jena.sparql.algebra.op.OpFilter;
import com.hp.hpl.jena.sparql.algebra.op.OpGraph;
import com.hp.hpl.jena.sparql.algebra.op.OpGroupAgg;
import com.hp.hpl.jena.sparql.algebra.op.OpJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpLeftJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpList;
import com.hp.hpl.jena.sparql.algebra.op.OpNull;
import com.hp.hpl.jena.sparql.algebra.op.OpOrder;
import com.hp.hpl.jena.sparql.algebra.op.OpProject;
import com.hp.hpl.jena.sparql.algebra.op.OpQuadPattern;
import com.hp.hpl.jena.sparql.algebra.op.OpReduced;
import com.hp.hpl.jena.sparql.algebra.op.OpService;
import com.hp.hpl.jena.sparql.algebra.op.OpSlice;
import com.hp.hpl.jena.sparql.algebra.op.OpTable;
import com.hp.hpl.jena.sparql.algebra.op.OpUnion;
import com.hp.hpl.jena.sparql.algebra.table.TableEmpty;
import com.hp.hpl.jena.sparql.algebra.table.TableUnit;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding1;
import com.hp.hpl.jena.sparql.engine.binding.BindingRoot;
import com.hp.hpl.jena.sparql.engine.http.Service;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterConcat;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterRoot;
import com.hp.hpl.jena.sparql.engine.main.StageBuilder;
import com.hp.hpl.jena.sparql.engine.ref.Evaluator;
import com.hp.hpl.jena.sparql.engine.ref.EvaluatorFactory;
import com.hp.hpl.jena.sparql.util.ALog;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;

public class Eval {
    public static Table eval(Evaluator evaluator, Op op) {
        EvaluatorDispatch ev = new EvaluatorDispatch(evaluator);
        op.visit(ev);
        Table table = ev.getResult();
        return table;
    }

    static Table evalDS(OpDatasetNames opDSN, Evaluator evaluator) {
        Node graphNode = opDSN.getGraphNode();
        if (graphNode.isURI()) {
            if (evaluator.getExecContext().getDataset().containsGraph(graphNode)) {
                return new TableUnit();
            }
            return new TableEmpty();
        }
        if (!Var.isVar(graphNode)) {
            throw new ARQInternalErrorException("OpDatasetNames: Not a URI or variable: " + graphNode);
        }
        DatasetGraph dsg = evaluator.getExecContext().getDataset();
        Iterator iter = dsg.listGraphNodes();
        ArrayList<Binding1> list = new ArrayList<Binding1>(dsg.size());
        while (iter.hasNext()) {
            Node gn = (Node)iter.next();
            Binding1 b = new Binding1(null, Var.alloc(graphNode), gn);
            list.add(b);
        }
        QueryIterPlainWrapper qIter = new QueryIterPlainWrapper(list.iterator(), evaluator.getExecContext());
        return TableFactory.create(qIter);
    }

    static Table evalGraph(OpGraph opGraph, Evaluator evaluator) {
        ExecutionContext execCxt = evaluator.getExecContext();
        if (!Var.isVar(opGraph.getNode())) {
            Graph graph = execCxt.getDataset().getGraph(opGraph.getNode());
            if (graph == null) {
                return new TableEmpty();
            }
            ExecutionContext execCxt2 = new ExecutionContext(execCxt, graph);
            Evaluator e2 = EvaluatorFactory.create(execCxt2);
            return Eval.eval(e2, opGraph.getSubOp());
        }
        Var gVar = Var.alloc(opGraph.getNode());
        Table current = null;
        Iterator iter = execCxt.getDataset().listGraphNodes();
        while (iter.hasNext()) {
            Node gn = (Node)iter.next();
            Graph graph = execCxt.getDataset().getGraph(gn);
            ExecutionContext execCxt2 = new ExecutionContext(execCxt, graph);
            Evaluator e2 = EvaluatorFactory.create(execCxt2);
            Table tableVarURI = TableFactory.create(gVar, gn);
            Table patternTable = Eval.eval(e2, opGraph.getSubOp());
            Table stepResult = evaluator.join(patternTable, tableVarURI);
            if (current == null) {
                current = stepResult;
                continue;
            }
            current = evaluator.union(current, stepResult);
        }
        if (current == null) {
            return new TableEmpty();
        }
        return current;
    }

    static Table evalQuadPattern(OpQuadPattern opQuad, Evaluator evaluator) {
        if (opQuad.getQuads().size() == 0) {
            return TableFactory.createUnit();
        }
        ExecutionContext cxt = evaluator.getExecContext();
        DatasetGraph ds = cxt.getDataset();
        BasicPattern pattern = opQuad.getBasicPattern();
        if (!opQuad.getGraphNode().isVariable()) {
            if (!opQuad.getGraphNode().isURI()) {
                throw new ARQInternalErrorException("Not a URI or variable: " + opQuad.getGraphNode());
            }
            Graph g = null;
            g = opQuad.isDefaultGraph() ? ds.getDefaultGraph() : ds.getGraph(opQuad.getGraphNode());
            if (g == null) {
                return new TableEmpty();
            }
            ExecutionContext cxt2 = new ExecutionContext(cxt, g);
            QueryIterator qIter = StageBuilder.compile(pattern, QueryIterRoot.create(cxt2), cxt2);
            return TableFactory.create(qIter);
        }
        Var gVar = Var.alloc(opQuad.getGraphNode());
        QueryIterConcat concat = new QueryIterConcat(cxt);
        Iterator graphNodes = cxt.getDataset().listGraphNodes();
        while (graphNodes.hasNext()) {
            Node gn = (Node)graphNodes.next();
            Graph g = cxt.getDataset().getGraph(gn);
            Binding1 b = new Binding1(BindingRoot.create(), gVar, gn);
            ExecutionContext cxt2 = new ExecutionContext(cxt, g);
            Table t1 = TableFactory.create(gVar, gn);
            QueryIterator qIter = StageBuilder.compile(pattern, QueryIterRoot.create(cxt2), cxt2);
            Table t2 = TableFactory.create(qIter);
            Table t3 = evaluator.join(t1, t2);
            concat.add(t3.iterator(cxt2));
        }
        return TableFactory.create(concat);
    }

    static class EvaluatorDispatch
    implements OpVisitor {
        private Stack stack = new Stack();
        private Evaluator evaluator;

        EvaluatorDispatch(Evaluator evaluator) {
            this.evaluator = evaluator;
        }

        private Table eval(Op op) {
            op.visit(this);
            return this.pop();
        }

        Table getResult() {
            if (this.stack.size() != 1) {
                ALog.warn(this, "Warning: getResult: stack size = " + this.stack.size());
            }
            Table table = this.pop();
            return table;
        }

        public void visit(OpBGP opBGP) {
            Table table = this.evaluator.basicPattern(opBGP.getPattern());
            this.push(table);
        }

        public void visit(OpQuadPattern quadPattern) {
            this.push(Eval.evalQuadPattern(quadPattern, this.evaluator));
        }

        public void visit(OpJoin opJoin) {
            Table left = this.eval(opJoin.getLeft());
            Table right = this.eval(opJoin.getRight());
            Table table = this.evaluator.join(left, right);
            this.push(table);
        }

        public void visit(OpLeftJoin opLeftJoin) {
            Table left = this.eval(opLeftJoin.getLeft());
            Table right = this.eval(opLeftJoin.getRight());
            Table table = this.evaluator.leftJoin(left, right, opLeftJoin.getExprs());
            this.push(table);
        }

        public void visit(OpDiff opDiff) {
            Table left = this.eval(opDiff.getLeft());
            Table right = this.eval(opDiff.getRight());
            Table table = this.evaluator.diff(left, right);
            this.push(table);
        }

        public void visit(OpUnion opUnion) {
            Table left = this.eval(opUnion.getLeft());
            Table right = this.eval(opUnion.getRight());
            Table table = this.evaluator.union(left, right);
            this.push(table);
        }

        public void visit(OpFilter opFilter) {
            Table table = this.eval(opFilter.getSubOp());
            table = this.evaluator.filter(opFilter.getExprs(), table);
            this.push(table);
        }

        public void visit(OpGraph opGraph) {
            this.push(Eval.evalGraph(opGraph, this.evaluator));
        }

        public void visit(OpService opService) {
            QueryIterator qIter = Service.exec(opService);
            Table table = TableFactory.create(qIter);
            this.push(table);
        }

        public void visit(OpDatasetNames dsNames) {
            this.push(Eval.evalDS(dsNames, this.evaluator));
        }

        public void visit(OpTable opTable) {
            this.push(opTable.getTable());
        }

        public void visit(OpExt opExt) {
            throw new QueryExecException("Encountered OpExt during execution of reference engine");
        }

        public void visit(OpNull opNull) {
            this.push(TableFactory.createEmpty());
        }

        public void visit(OpList opList) {
            Table table = this.eval(opList.getSubOp());
            table = this.evaluator.list(table);
            this.push(table);
        }

        public void visit(OpOrder opOrder) {
            Table table = this.eval(opOrder.getSubOp());
            table = this.evaluator.order(table, opOrder.getConditions());
            this.push(table);
        }

        public void visit(OpProject opProject) {
            Table table = this.eval(opProject.getSubOp());
            table = this.evaluator.project(table, opProject.getProject());
            this.push(table);
        }

        public void visit(OpDistinct opDistinct) {
            Table table = this.eval(opDistinct.getSubOp());
            table = this.evaluator.distinct(table);
            this.push(table);
        }

        public void visit(OpReduced opReduced) {
            Table table = this.eval(opReduced.getSubOp());
            table = this.evaluator.reduced(table);
            this.push(table);
        }

        public void visit(OpSlice opSlice) {
            Table table = this.eval(opSlice.getSubOp());
            table = this.evaluator.slice(table, opSlice.getStart(), opSlice.getLength());
            this.push(table);
        }

        public void visit(OpGroupAgg opGroupAgg) {
            Table table = this.eval(opGroupAgg.getSubOp());
            table = this.evaluator.groupBy(table, opGroupAgg.getGroupVars(), opGroupAgg.getAggregators());
            this.push(table);
        }

        private void push(Table table) {
            this.stack.push(table);
        }

        private Table pop() {
            if (this.stack.size() == 0) {
                ALog.warn(this, "Warning: pop: empty stack");
            }
            return (Table)this.stack.pop();
        }
    }
}

