/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.cortex;

import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import fr.gael.cortex.CortexModelResolver;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import org.apache.log4j.Logger;

public class CortexModel {
    private static CortexModel defaultModel = null;
    private static Logger logger = Logger.getLogger(CortexModel.class);
    static String ONT_INDEX_FILENAME = "META-INF/cortex-index.owl";
    private OntModel ontModel = null;
    private CortexModelResolver resolver = null;

    public static CortexModel getDefaultModel() throws IOException {
        if (defaultModel == null) {
            defaultModel = new CortexModel();
        }
        return defaultModel;
    }

    private static OntModel loadDefaultOntModel() throws IOException {
        OntModel model = ModelFactory.createOntologyModel();
        Enumeration<URL> ont_urls = ClassLoader.getSystemResources(ONT_INDEX_FILENAME);
        while (ont_urls.hasMoreElements()) {
            URL ont_url = ont_urls.nextElement();
            File ont_file = new File(ont_url.toString().replaceAll("!.*", ""));
            logger.info((Object)("Loading Ontology Model from: " + ont_file.getName().replaceAll("\\.jar", "")));
            logger.debug((Object)("Loading Ontology Model from: " + ont_url));
            model.read(ont_url.toString());
        }
        return model;
    }

    public static void main(String[] args) {
        for (String arg : args) {
            if (arg.equals("--help")) {
                System.out.println("Usage: java fr.gael.cortex.CortexModel [OPTIONS]\n\nLoad Cortex default model from currently installed Cortex Topics and prints out the classes they define.\n\nOPTIONS:\n\n[--help]: prints out the present help message.\n\n[--version]: prints out the version of the package.\n\n");
                return;
            }
            if (!arg.equals("--version")) continue;
            Package pack = CortexModel.class.getPackage();
            System.out.println("Version: " + pack.getImplementationTitle() + " - " + pack.getImplementationVersion() + "(" + pack.getImplementationVendor() + ")");
            return;
        }
        OntModel model = null;
        try {
            model = CortexModel.getDefaultModel().getOntModel();
        }
        catch (Exception exception) {
            logger.fatal((Object)("Error while reading default Cortex model (" + exception.getMessage() + ")."));
            return;
        }
        ExtendedIterator ont_classes = model.listClasses();
        while (ont_classes.hasNext()) {
            OntClass current_class = (OntClass)ont_classes.next();
            System.out.println("Class: \"" + current_class.getLabel("") + "\" (" + current_class.getURI() + ")");
        }
    }

    public static void setDefaultModel(CortexModel model) {
        defaultModel = model;
    }

    public CortexModel() throws IOException {
        this(CortexModel.loadDefaultOntModel());
    }

    public CortexModel(OntModel ont_model) throws NullPointerException {
        if (ont_model == null) {
            throw new NullPointerException("Cannot create a Crotex model from a null Onotlogy model.");
        }
        this.setOntModel(ont_model);
    }

    public OntModel getOntModel() {
        if (this.resolver != null && this.resolver.getModel() != null) {
            return this.resolver.getModel();
        }
        return this.ontModel;
    }

    public CortexModelResolver getResolver() {
        return this.resolver;
    }

    public String resolveResourceUrl(String url_string) {
        ClassLoader cl;
        if (this.resolver != null) {
            logger.debug((Object)"Using resolver.");
            return this.resolver.resolveResourceUri(url_string);
        }
        URL url = null;
        url = ClassLoader.getSystemResource(url_string);
        if (url == null && (cl = ClassLoader.getSystemClassLoader()) != null) {
            url = cl.getResource(url_string);
        }
        if (url == null) {
            logger.warn((Object)("Cannot resolve URL \"" + url_string + "\" from any loaded topic."));
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Resource \"" + url_string + "\" resolved as URL \"" + url.toExternalForm() + "\"."));
        }
        return url.toExternalForm();
    }

    public void setOntModel(OntModel ont_model) throws NullPointerException {
        if (ont_model == null) {
            throw new NullPointerException("Cannot assign a null reference as Ontology model.");
        }
        this.ontModel = ont_model;
    }

    public void setResolver(CortexModelResolver resolver) {
        this.resolver = resolver;
    }
}

