/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb;

import fr.gael.drb.DrbAttribute;
import fr.gael.drb.DrbAttributeList;
import fr.gael.drb.DrbDefaultAttributeList;
import fr.gael.drb.DrbDefaultNodesChangeProducer;
import fr.gael.drb.DrbDefaultSequence;
import fr.gael.drb.DrbMutableNode;
import fr.gael.drb.DrbNode;
import fr.gael.drb.DrbNodeList;
import fr.gael.drb.DrbSequence;
import fr.gael.drb.value.Value;
import fr.gael.drb.xsd.Namespace;
import org.apache.log4j.Logger;

public abstract class DrbAbstractNode
extends DrbDefaultNodesChangeProducer
implements DrbNode,
DrbMutableNode {
    private static Logger logger = Logger.getLogger(DrbAbstractNode.class);

    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public int getItemType() {
        return 1;
    }

    @Override
    public String getName() {
        return "";
    }

    protected String getXPathName() {
        if (this.allowsMultiOccurrence()) {
            long occurrence = this.getOccurrence();
            boolean has_occurence = occurrence > 1L;
            DrbNode parent = this.getParent();
            if (parent != null && parent.getNamedChild(this.getName(), 2) != null) {
                has_occurence = true;
            }
            if (has_occurence) {
                return this.getName() + "[" + occurrence + "]";
            }
            return this.getName();
        }
        return this.getName();
    }

    protected final String getXPathName(DrbAbstractNode node) {
        return node.getXPathName();
    }

    @Override
    public int getIndex() {
        DrbNode parent = this.getParent();
        if (parent == null) {
            return -1;
        }
        DrbNodeList parentChildren = parent.getChildren();
        if (parentChildren == null) {
            return -1;
        }
        String name = this.getName();
        if (name == null) {
            return -1;
        }
        for (int inode = 0; inode < parentChildren.getLength(); ++inode) {
            DrbNode child = parentChildren.item(inode);
            if (!this.equals(child)) continue;
            return inode;
        }
        return -1;
    }

    public int getOccurrence() {
        if (!this.allowsMultiOccurrence()) {
            return 1;
        }
        DrbNode parent = this.getParent();
        if (parent == null) {
            return 1;
        }
        DrbNodeList parentChildren = parent.getChildren();
        if (parentChildren == null) {
            return 1;
        }
        String name = this.getName();
        if (name == null) {
            return 1;
        }
        int occurs = 1;
        for (int inode = 0; inode < parentChildren.getLength(); ++inode) {
            DrbNode sibling = parentChildren.item(inode);
            if (this.equals(sibling)) {
                return occurs;
            }
            if (!name.equals(sibling.getName())) continue;
            ++occurs;
        }
        return -1;
    }

    public boolean allowsMultiOccurrence() {
        return true;
    }

    @Override
    public DrbNode getRoot() {
        DrbNode parent = this.getParent();
        if (parent != null) {
            return parent.getRoot();
        }
        return null;
    }

    @Override
    public String getPath() {
        String parentPath;
        DrbNode parent = this.getParent();
        String nodePath = this.getXPathName();
        if (parent != null && (parentPath = parent.getPath()) != null) {
            String path = parentPath + "/" + nodePath;
            if (parentPath.endsWith("/")) {
                path = parentPath + nodePath;
            }
            return path;
        }
        return nodePath;
    }

    @Override
    public String getNamespaceURI() {
        return null;
    }

    public Namespace getNamespaceBindings() {
        return null;
    }

    @Override
    public int getValueType() {
        return -1;
    }

    @Override
    public Value getValue() {
        return null;
    }

    @Override
    public DrbAttributeList getAttributes() {
        return new DrbDefaultAttributeList();
    }

    @Override
    public DrbAttribute getAttribute(String name) {
        DrbAttributeList attribList = this.getAttributes();
        if (attribList == null) {
            return null;
        }
        return attribList.getNamedItem(name);
    }

    @Override
    public abstract DrbNode getParent();

    @Override
    public abstract DrbNodeList getChildren();

    public DrbSequence getContent() {
        DrbNodeList children = this.getChildren();
        Value value = this.getValue();
        if (value == null) {
            return children;
        }
        if (children == null) {
            return new DrbDefaultSequence(value);
        }
        DrbDefaultSequence content = new DrbDefaultSequence(children);
        content.addItem(value);
        return content;
    }

    @Override
    public boolean hasChild() {
        return this.getChildrenCount() > 0;
    }

    @Override
    public DrbNode getNamedChild(String name, int occurence) {
        if (name == null || occurence <= 0) {
            logger.error("DrbAbstractNode.getNamedChild(): Invalid parameter (name=\"" + name + "\", occurence=" + occurence);
            return null;
        }
        DrbNodeList children = this.getChildren();
        if (children == null) {
            return null;
        }
        return children.getNamedItem(name, occurence);
    }

    @Override
    public DrbNode getFirstChild() {
        return this.getChildAt(0);
    }

    @Override
    public DrbNode getLastChild() {
        int childrenCount = this.getChildrenCount();
        if (childrenCount <= 0) {
            return null;
        }
        return this.getChildAt(childrenCount - 1);
    }

    @Override
    public DrbNode getChildAt(int index) {
        DrbNodeList children = this.getChildren();
        if (children != null) {
            return children.item(index);
        }
        return null;
    }

    @Override
    public int getChildrenCount() {
        DrbNodeList children = this.getChildren();
        if (children != null) {
            return children.getLength();
        }
        return 0;
    }

    @Override
    public DrbNode getPreviousSibling() {
        DrbNode parent = this.getParent();
        if (parent == null) {
            return null;
        }
        int index = this.getIndex();
        if (index == 0) {
            return null;
        }
        if (index > 0) {
            return parent.getChildAt(index - 1);
        }
        DrbNodeList parentChildren = parent.getChildren();
        if (parentChildren == null) {
            return null;
        }
        DrbNode previousNode = parentChildren.item(0);
        for (int inode = 1; inode < parentChildren.getLength(); ++inode) {
            DrbNode currentNode = parentChildren.item(inode);
            if (this.equals(currentNode)) {
                return previousNode;
            }
            previousNode = currentNode;
        }
        return null;
    }

    @Override
    public DrbNode getNextSibling() {
        DrbNode parent = this.getParent();
        if (parent == null) {
            return null;
        }
        int index = this.getIndex();
        if (index >= 0) {
            return parent.getChildAt(index + 1);
        }
        DrbNodeList parentChildren = parent.getChildren();
        if (parentChildren == null) {
            return null;
        }
        for (int inode = 0; inode < parentChildren.getLength() - 1; ++inode) {
            if (!this.equals(parentChildren.item(inode))) continue;
            return parentChildren.item(inode + 1);
        }
        return null;
    }

    @Override
    public void rename(String name) throws NullPointerException, UnsupportedOperationException {
        throw new UnsupportedOperationException("DrbAbstractNode.rename() : This operation is not supported by this implementation.");
    }

    @Override
    public Value setValue(Value value) throws NullPointerException, ClassCastException, UnsupportedOperationException {
        throw new UnsupportedOperationException("DrbAbstractNode.setValue(): This operation is not supported.");
    }

    @Override
    public void setAttributes(DrbAttributeList attributes) throws NullPointerException, UnsupportedOperationException {
        throw new UnsupportedOperationException("DrbAbstractNode.setAttributes(): This operation is not supported.");
    }

    @Override
    public void setNamespaceURI(String namespace_uri) throws NullPointerException, UnsupportedOperationException {
        throw new UnsupportedOperationException("DrbAbstractNode.setNamespaceURI(): This operation is not supported.");
    }

    public void setNamespaceBindings(Namespace bindings) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("DrbAbstractNode.setNamespaceBindings(): This operation is not supported.");
    }

    @Override
    public DrbNode insertChild(DrbNode node, int index) throws NullPointerException, UnsupportedOperationException, IndexOutOfBoundsException {
        throw new UnsupportedOperationException("DrbAbstractNode.insertChild(): This operation is not supported.");
    }

    @Override
    public DrbNode appendChild(DrbNode node) throws NullPointerException, UnsupportedOperationException {
        throw new UnsupportedOperationException("DrbAbstractNode.appendChild(): This operation is not supported.");
    }

    @Override
    public DrbNode replaceChild(int index, DrbNode new_node) throws NullPointerException, IndexOutOfBoundsException, UnsupportedOperationException {
        throw new UnsupportedOperationException("DrbAbstractNode.replaceChild(): This operation is not supported.");
    }

    @Override
    public void removeChild(int index) throws IndexOutOfBoundsException, UnsupportedOperationException {
        throw new UnsupportedOperationException("DrbAbstractNode.removeChild(): This operation is not supported.");
    }

    public DrbNode appendReference(DrbNode node) throws NullPointerException, UnsupportedOperationException {
        throw new UnsupportedOperationException("DrbAbstractNode.appendReference(): This operation is not supported.");
    }

    public String toString() {
        String outputString;
        if (this.getValue() != null) {
            outputString = "<" + this.getName() + ">";
            outputString = outputString + "   " + this.getValue();
            outputString = outputString + "</" + this.getName() + ">\n";
        } else {
            outputString = "<" + this.getName() + "/>";
        }
        return outputString;
    }
}

