/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb;

import fr.gael.drb.DrbDefaultSequence;
import fr.gael.drb.DrbItem;
import fr.gael.drb.DrbNode;
import fr.gael.drb.DrbNodeList;
import fr.gael.drb.DrbSequence;
import org.apache.log4j.Logger;

public class DrbDefaultNodeList
extends DrbDefaultSequence
implements DrbNodeList {
    private static Logger logger = Logger.getLogger(DrbDefaultNodeList.class);

    @Override
    public DrbNode item(int index) {
        return (DrbNode)this.getItem(index);
    }

    @Override
    public DrbNode getNamedItem(String name, int occurence) {
        if (name == null || occurence <= 0) {
            logger.error("DrbDefaultNodeList.item(): Invalid parameter (name=\"" + name + "\", occurence=" + occurence);
            return null;
        }
        int current_occurence = 0;
        String current_name = null;
        for (int inode = 0; inode < this.getLength(); ++inode) {
            DrbNode current_node = this.item(inode);
            if (current_node == null) continue;
            current_name = current_node.getName();
            if (current_name != null && current_name.equals(name)) {
                ++current_occurence;
            }
            if (current_occurence != occurence) continue;
            return current_node;
        }
        return null;
    }

    @Override
    public DrbSequence addItem(int index, DrbItem item) throws NullPointerException, UnsupportedOperationException, IndexOutOfBoundsException {
        try {
            super.addItem(index, item);
            return this;
        }
        catch (ClassCastException e) {
            DrbDefaultSequence new_sequence = new DrbDefaultSequence(this);
            new_sequence.addItem(index, item);
            return new_sequence;
        }
    }

    @Override
    public String toString() {
        String string = "";
        for (int index = 0; index < this.getLength(); ++index) {
            if (index != 0) {
                string = string + ", ";
            }
            string = string + this.item(index);
        }
        return string;
    }
}

