/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.impl.file;

import fr.gael.drb.DrbAttribute;
import fr.gael.drb.DrbAttributeList;
import fr.gael.drb.DrbDefaultAttributeList;
import fr.gael.drb.DrbDefaultNodeList;
import fr.gael.drb.DrbFactoryImpl;
import fr.gael.drb.DrbNode;
import fr.gael.drb.DrbNodeList;
import fr.gael.drb.DrbNodesChangeEvent;
import fr.gael.drb.DrbUpdateImpl;
import fr.gael.drb.impl.DrbFactoryResolver;
import fr.gael.drb.impl.DrbNodeImpl;
import fr.gael.drb.impl.DrbProvider;
import fr.gael.drb.impl.file.FileAttribute;
import fr.gael.drb.impl.file.FileProvider;
import fr.gael.drb.impl.file.FileValue;
import fr.gael.drb.value.Binary;
import fr.gael.drb.value.Logic;
import fr.gael.drb.value.Value;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Vector;
import org.apache.log4j.Logger;

public final class FileNode
extends DrbNodeImpl {
    private static Logger logger = Logger.getLogger(FileNode.class);
    File file;
    private File[] children;
    private DrbNodeList drbChildren;
    private FileNode parent;
    private int index = -1;
    private FileProvider provider;
    private Vector<Closeable> closeables = new Vector();

    FileNode(File file, FileNode parent) {
        if (file == null) {
            return;
        }
        try {
            String path = file.getPath();
            if (!file.isAbsolute() || parent == null) {
                file = file.getCanonicalFile();
            }
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
        }
        this.file = file;
        this.parent = parent;
        this.children = null;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof FileNode) {
            FileNode file_node = (FileNode)obj;
            return file_node.file.equals(this.file);
        }
        return false;
    }

    @Override
    public boolean allowsMultiOccurrence() {
        return false;
    }

    @Override
    public void close(boolean deep) {
        for (Closeable closeable : this.closeables) {
            try {
                closeable.close();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public DrbProvider getProvider() {
        if (this.provider == null) {
            this.provider = new FileProvider(this);
        }
        return this.provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final File[] getSortedChildren(File file) {
        Object[] children;
        File file2 = file;
        synchronized (file2) {
            if (file == null) {
                logger.error("File.getSortedChildren() : Null file pointer.");
                return null;
            }
            children = file.listFiles();
        }
        if (children == null) {
            return new File[0];
        }
        try {
            if (((FileProvider)this.getProvider()).mustSort) {
                Arrays.sort(children);
            }
        }
        catch (ClassCastException e) {
            logger.error("File.getSortedChildren() : Cannot sort children list.");
            logger.error("File.getSortedChildren() : " + e.getMessage());
        }
        Object aux_file = null;
        int last_dir = -1;
        for (int ifile = 0; ifile < children.length; ++ifile) {
            if (!((File)children[ifile]).isDirectory()) continue;
            aux_file = children[ifile];
            for (int ishift = ifile; ishift > last_dir + 1; --ishift) {
                children[ishift] = children[ishift - 1];
            }
            children[last_dir + 1] = aux_file;
            ++last_dir;
        }
        return children;
    }

    @Override
    public final String getName() {
        return this.file.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int getIndex() {
        if (this.index >= 0) {
            return this.index;
        }
        if (this.getParent() == null) {
            return 0;
        }
        FileNode fileNode = this.parent;
        synchronized (fileNode) {
            String name = this.getName();
            int count = this.parent.getChildrenCount();
            for (int ifile = 0; ifile < count; ++ifile) {
                if (!name.equals(this.parent.children[ifile].getName())) continue;
                this.index = ifile;
                return ifile;
            }
        }
        return -1;
    }

    @Override
    public final DrbNode getRoot() {
        File parent;
        FileNode current_root = this;
        File current_file = this.file;
        while ((parent = current_file.getParentFile()) != null) {
            current_file = parent;
            if (current_root == null) continue;
            current_root = current_root.parent;
        }
        if (current_root != null) {
            return current_root;
        }
        return new FileNode(current_file, null);
    }

    @Override
    public final synchronized String getPath() {
        if (this.file != null) {
            String path = this.file.toURI().getPath();
            return path;
        }
        return null;
    }

    @Override
    public final String getNamespaceURI() {
        return null;
    }

    @Override
    public final int getValueType() {
        if (this.file.isDirectory()) {
            return -1;
        }
        return 28;
    }

    @Override
    public final Value getValue() {
        if (this.file.isFile()) {
            return new FileValue(this);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final DrbAttributeList getAttributes() {
        FileAttribute attr = null;
        DrbDefaultAttributeList attr_list = new DrbDefaultAttributeList();
        File file = this.file;
        synchronized (file) {
            attr = new FileAttribute("directory", this);
            attr_list.add(attr);
            attr = new FileAttribute("size", this);
            attr_list.add(attr);
            attr = new FileAttribute("modified", this);
            attr_list.add(attr);
            attr = new FileAttribute("readable", this);
            attr_list.add(attr);
            attr = new FileAttribute("writable", this);
            attr_list.add(attr);
            attr = new FileAttribute("hidden", this);
            attr_list.add(attr);
        }
        return attr_list;
    }

    @Override
    public final DrbNode getParent() {
        if (this.parent == null) {
            File parent_file = this.file.getParentFile();
            if (parent_file == null) {
                File absolute_file = new File(this.getPath());
                parent_file = absolute_file.getParentFile();
            }
            if (parent_file != null) {
                this.parent = new FileNode(parent_file, null);
                this.parent.setListenerList(this.getListenerList());
            }
        }
        return this.parent;
    }

    @Override
    public final DrbNodeList getChildren() {
        if (this.drbChildren == null) {
            this.drbChildren = this._getChildren();
        }
        return this.drbChildren;
    }

    public final DrbNodeList _getChildren() {
        if (this.children == null) {
            this.children = this.getSortedChildren(this.file);
        }
        if (this.children == null || this.children.length == 0) {
            return null;
        }
        DrbDefaultNodeList list = new DrbDefaultNodeList();
        for (int ifile = 0; ifile < this.children.length; ++ifile) {
            list.add(new FileNode(this.children[ifile], this));
        }
        return list;
    }

    @Override
    public final boolean hasChild() {
        if (this.children != null) {
            return this.children.length > 0;
        }
        return this.file.isDirectory();
    }

    @Override
    public DrbNode getChildAt(int index) {
        if (index < 0 || index >= this.getChildrenCount()) {
            return null;
        }
        return new FileNode(this.children[index], this);
    }

    @Override
    public DrbNode getNamedChild(String name, int occurence) {
        if (name == null || occurence <= 0) {
            logger.error("File.getNamedChild(): Invalid parameters.");
            return null;
        }
        if (occurence == 1) {
            File child_file = new File(this.file, name);
            if (!child_file.exists()) {
                return null;
            }
            return new FileNode(child_file, this);
        }
        return null;
    }

    @Override
    public final int getChildrenCount() {
        if (this.children == null) {
            this.children = this.getSortedChildren(this.file);
        }
        return this.children.length;
    }

    @Override
    public final boolean hasImpl(Class api) {
        if (api == null) {
            return false;
        }
        if (api.isAssignableFrom(FileInputStream.class) || api.isAssignableFrom(FileOutputStream.class) || api.isAssignableFrom(RandomAccessFile.class) || api.isAssignableFrom(File.class) || api == URL.class) {
            return true;
        }
        return super.hasImpl(api);
    }

    @Override
    public final Object getImpl(Class api) {
        if (this.file == null || api == null) {
            return null;
        }
        Object impl = null;
        if (api.isAssignableFrom(FileInputStream.class)) {
            if (this.file.isDirectory()) {
                return null;
            }
            try {
                impl = new FileInputStream(this.file);
                this.closeables.addElement((Closeable)impl);
            }
            catch (FileNotFoundException e) {
                logger.error("fr.gael.drb.impl.file.File : Cannot create an instance of FileInputStream", e);
            }
            catch (SecurityException e) {
                logger.error("fr.gael.drb.impl.file.File : Cannot create an instance of FileInputStream", e);
            }
        } else if (api.isAssignableFrom(FileOutputStream.class)) {
            if (this.file.isDirectory()) {
                return null;
            }
            try {
                impl = new FileOutputStream(this.file);
                this.closeables.addElement((Closeable)impl);
            }
            catch (FileNotFoundException e) {
                logger.error("fr.gael.drb.impl.file.File : Cannot create an instance of FileOutputStream");
                logger.error("fr.gael.drb.impl.file.File : " + e.getMessage());
            }
            catch (SecurityException e) {
                logger.error("fr.gael.drb.impl.file.File : Cannot create an instance of FileOutputStream");
                logger.error("fr.gael.drb.impl.file.File : " + e.getMessage());
            }
        } else if (api.isAssignableFrom(RandomAccessFile.class)) {
            if (this.file.isDirectory()) {
                return null;
            }
            try {
                if (this.file.canWrite()) {
                    try {
                        impl = new AutoFinalizeRandomAccessFile(this.file, "rw");
                        this.closeables.addElement((Closeable)impl);
                    }
                    catch (IllegalArgumentException e) {
                        logger.info("Cannot open file in read/write mode. Trying read only ...", e);
                    }
                }
                if (impl == null) {
                    impl = new AutoFinalizeRandomAccessFile(this.file, "r");
                    this.closeables.addElement((Closeable)impl);
                }
            }
            catch (IllegalArgumentException e) {
                logger.error("fr.gael.drb.impl.file.File : Cannot create an instance of RandomAccessFile");
                logger.error("fr.gael.drb.impl.file.File : " + e.getMessage());
            }
            catch (FileNotFoundException e) {
                logger.error("fr.gael.drb.impl.file.File : Cannot create an instance of RandomAccessFile");
                logger.error("fr.gael.drb.impl.file.File : " + e.getMessage());
            }
            catch (SecurityException e) {
                logger.error("fr.gael.drb.impl.file.File : Cannot create an instance of RandomAccessFile");
                logger.error("fr.gael.drb.impl.file.File : " + e.getMessage());
            }
        } else if (api.isAssignableFrom(File.class)) {
            impl = this.file;
        } else if (api == URL.class) {
            try {
                impl = new URL(this.file.getName());
            }
            catch (MalformedURLException e) {
                return null;
            }
        } else {
            return super.getImpl(api);
        }
        return impl;
    }

    @Override
    public final String toString() {
        return this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean copyStream(InputStream input_stream, File output) {
        FileOutputStream output_stream;
        if (input_stream == null || output == null) {
            logger.error("File.copyStream() : invalid parameter.");
            return false;
        }
        try {
            output_stream = new FileOutputStream(output);
        }
        catch (Exception e) {
            logger.error("File.copyStream() : " + e);
            return false;
        }
        byte[] buffer = new byte[0x100000];
        try {
            int read_count;
            while ((read_count = input_stream.read(buffer)) > 0) {
                output_stream.write(buffer, 0, read_count);
            }
        }
        catch (IOException e) {
            logger.error("File.copyStream() : " + e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                output_stream.close();
            }
            catch (Exception exception) {}
        }
        return true;
    }

    private FileNode addChild(DrbNode node) throws NullPointerException, UnsupportedOperationException {
        FileNode output_node;
        if (node == null) {
            throw new NullPointerException("File.addChild() : Null input node.");
        }
        if (!this.file.isDirectory()) {
            DrbFactoryImpl impl = DrbFactoryResolver.resolveImpl(this);
            if (impl == null || !(impl instanceof DrbUpdateImpl)) {
                throw new UnsupportedOperationException("File.addChild() : Current node is not a directory.");
            }
            ((DrbUpdateImpl)impl).put(node, this);
            return null;
        }
        File output_file = new File(this.file, node.getName());
        boolean create_directory = false;
        DrbAttribute directory_attribute = node.getAttribute("directory");
        if (directory_attribute != null) {
            Value directory_value = directory_attribute.getValue();
            if (directory_value == null) {
                throw new UnsupportedOperationException("File.addChild() : Cannot assess whether the node \"" + output_file.getName() + "\" is a file or a directory. Attributes must not be null.");
            }
            try {
                create_directory = ((Logic)((Object)directory_value.convertTo(0))).booleanValue();
            }
            catch (ClassCastException e) {
                throw new UnsupportedOperationException("File.addChild() : Cannot assess whether the node \"" + output_file.getName() + "\" is a file or a directory. Attributes must be valid.");
            }
        } else if (node.hasChild() || node.getValue() == null) {
            logger.warn("File.addChild() : The node \"" + output_file.getName() + "\" should have no 'directory' attribute.");
        }
        this.children = null;
        if (create_directory) {
            if (!output_file.exists() && !output_file.mkdir()) {
                throw new UnsupportedOperationException("File.addChild() : Cannot create new directory.");
            }
            int count = node.getChildrenCount();
            output_node = new FileNode(output_file, this);
            for (int ichild = 0; ichild < count; ++ichild) {
                output_node.addChild(node.getChildAt(ichild));
            }
        } else {
            try {
                output_file.createNewFile();
            }
            catch (IOException e) {
                throw new UnsupportedOperationException("File.addChild() : Cannot create new file.");
            }
            output_node = new FileNode(output_file, this);
            DrbFactoryImpl impl = DrbFactoryResolver.resolveImpl(node);
            Value output_value = node.getValue();
            if (impl instanceof DrbUpdateImpl) {
                DrbNode input_node = node.getFirstChild();
                if (input_node != null) {
                    ((DrbUpdateImpl)impl).put(input_node, output_node);
                }
            } else if (output_value == null && node instanceof DrbNodeImpl) {
                DrbNodeImpl nodeImpl = (DrbNodeImpl)node;
                if (nodeImpl.hasImpl(InputStream.class)) {
                    output_value = new FileValue(nodeImpl);
                } else {
                    int count = node.getChildrenCount();
                    output_node = new FileNode(output_file, this);
                    for (int ichild = 0; ichild < count; ++ichild) {
                        output_node.addChild(node.getChildAt(ichild));
                    }
                }
            } else if (output_value != null) {
                output_node.setValue(output_value);
            }
        }
        DrbDefaultNodeList node_list = new DrbDefaultNodeList();
        node_list.add(output_node);
        this.nodesInserted(new DrbNodesChangeEvent(this, node_list));
        return output_node;
    }

    @Override
    public DrbNode appendChild(DrbNode node) throws UnsupportedOperationException {
        return this.addChild(node);
    }

    @Override
    public DrbNode insertChild(DrbNode node, int index) throws UnsupportedOperationException {
        return this.addChild(node);
    }

    @Override
    public void removeChild(int index) throws IndexOutOfBoundsException, UnsupportedOperationException {
        if (index < 0 || index >= this.getChildrenCount()) {
            throw new IndexOutOfBoundsException("File.removeChild() : Index #" + index + " out of bound (children count =" + (this.children == null ? 0 : this.children.length) + ")");
        }
        FileNode removed_child = (FileNode)this.getChildAt(index);
        removed_child.index = index;
        try {
            if (!this.deleteFile(this.children[index])) {
                logger.error("File.removeChild() : Warning : Unable to remove file \"" + this.children[index].getName() + "\"");
                throw new UnsupportedOperationException("File.removeChild() : Warning : Unable to remove file \"" + this.children[index].getName() + "\"");
            }
        }
        catch (SecurityException e) {
            throw new UnsupportedOperationException("File.removeChild() : " + e);
        }
        this.children = null;
        DrbDefaultNodeList node_list = new DrbDefaultNodeList();
        node_list.add(removed_child);
        this.nodesRemoved(new DrbNodesChangeEvent(this, node_list));
    }

    private boolean deleteFile(File file) {
        try {
            File[] list_child = file.listFiles();
            if (list_child != null) {
                for (int i = 0; i < list_child.length; ++i) {
                    if (this.deleteFile(list_child[i])) continue;
                    return false;
                }
            }
            if (!file.delete()) {
                logger.error("File.deleteFile() : Warning : Unable to remove file \"" + file.getName() + "\"");
                return false;
            }
        }
        catch (SecurityException e) {
            logger.error("File.deleteFile() : Unable to remove file \"" + file.getName() + "\" : " + e);
            return false;
        }
        return true;
    }

    @Override
    public void rename(String name) throws NullPointerException, UnsupportedOperationException {
        if (name == null) {
            throw new NullPointerException("File.rename() : The reference to the new name is null.");
        }
        try {
            File new_file = new File(this.file.getParentFile(), name);
            this.file.renameTo(new_file);
            this.file = new_file;
            if (this.parent != null) {
                this.parent.children = null;
            }
        }
        catch (SecurityException e) {
            throw new UnsupportedOperationException("File.rename() : " + e);
        }
        this.nodesChanged(new DrbNodesChangeEvent(this));
    }

    @Override
    public DrbNode replaceChild(int index, DrbNode node) throws NullPointerException, IndexOutOfBoundsException, UnsupportedOperationException {
        if (node == null) {
            throw new NullPointerException("File.replaceChild() : Reference to the node is null.");
        }
        if (index < 0 || index >= this.getChildrenCount()) {
            throw new IndexOutOfBoundsException("File.replaceChild() : Index #" + index + " out of bound (children count =" + (this.children == null ? 0 : this.children.length) + ")");
        }
        this.removeChild(index);
        FileNode replacing_node = this.addChild(node);
        DrbDefaultNodeList node_list = new DrbDefaultNodeList();
        node_list.add(replacing_node);
        this.structureChanged(new DrbNodesChangeEvent(this, node_list));
        return replacing_node;
    }

    @Override
    public void setNamespaceURI(String namespace_uri) throws NullPointerException, UnsupportedOperationException {
        throw new UnsupportedOperationException("File.setNamespaceURI() : Unsupported operation.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value setValue(Value value) throws NullPointerException, ClassCastException, UnsupportedOperationException {
        if (value == null) {
            throw new NullPointerException("File.setValue() : Null value parameter.");
        }
        File file = this.file;
        synchronized (file) {
            if (!this.file.isFile()) {
                throw new UnsupportedOperationException("File.setValue() : Cannot set value of a directory.");
            }
        }
        InputStream input_stream = value.getType() != 28 ? new ByteArrayInputStream(value.toString().getBytes()) : ((Binary)value).getInput();
        try {
            if (input_stream != null && !this.copyStream(input_stream, this.file)) {
                input_stream.close();
                throw new UnsupportedOperationException("File.setValue() : cannot copy value to file.");
            }
            if (input_stream != null) {
                input_stream.close();
            }
        }
        catch (IOException e) {
            logger.warn("File.setValue() : cannot close input stream.");
        }
        return value;
    }

    @Override
    public DrbNode createNode(String name) throws NullPointerException, UnsupportedOperationException {
        try {
            return this.createNewFile(name);
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileNode createNewFile(String file_name) throws NullPointerException, UnsupportedOperationException, IOException, SecurityException {
        File new_file;
        if (file_name == null) {
            throw new NullPointerException("File.createNewFile() : Null file name.");
        }
        File file = this.file;
        synchronized (file) {
            if (!this.file.isDirectory()) {
                throw new UnsupportedOperationException("File.createNewFile() : Current node is not a directory.");
            }
            new_file = new File(this.file, file_name);
            new_file.createNewFile();
        }
        this.children = this.getSortedChildren(this.file);
        FileNode output_node = new FileNode(new_file, this);
        DrbDefaultNodeList node_list = new DrbDefaultNodeList();
        node_list.add(output_node);
        this.nodesInserted(new DrbNodesChangeEvent(this, node_list));
        return output_node;
    }

    class AutoFinalizeRandomAccessFile
    extends RandomAccessFile {
        AutoFinalizeRandomAccessFile(File file, String mode) throws FileNotFoundException {
            super(file, mode);
        }

        protected void finalize() throws Throwable {
            super.close();
            super.finalize();
        }
    }
}

