/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.impl.sdf;

import fr.gael.drb.DrbAttributeList;
import fr.gael.drb.DrbDefaultAttribute;
import fr.gael.drb.DrbDefaultAttributeList;
import fr.gael.drb.DrbDefaultNodeList;
import fr.gael.drb.DrbNode;
import fr.gael.drb.DrbNodeList;
import fr.gael.drb.impl.DrbNodeImpl;
import fr.gael.drb.impl.sdf.DefaultBlock;
import fr.gael.drb.impl.sdf.Descriptor;
import fr.gael.drb.impl.sdf.IntMap;
import fr.gael.drb.impl.sdf.MultipleOccurrenceBlock;
import fr.gael.drb.value.Long;
import fr.gael.drb.value.String;
import fr.gael.drb.value.Value;
import fr.gael.drb.xsd.XsdInvalid;
import fr.gael.drb.xsd.XsdNode;
import org.apache.log4j.Logger;

public abstract class AbstractBlock
extends DrbNodeImpl
implements XsdNode {
    private static Logger logger = Logger.getLogger(AbstractBlock.class);
    protected Descriptor descriptor;
    protected int[] key;

    protected AbstractBlock(Descriptor descriptor, int[] key) {
        if (descriptor == null || key == null) {
            logger.error("AbstractBlock.AbstractBlock() ERROR: Invalid parameter(s).");
            if (descriptor == null) {
                logger.error("   descriptor       = null");
            } else {
                logger.error("   descriptor.name  = " + descriptor.getName());
            }
            logger.error("   key              = " + IntMap.keyToString(key));
        }
        this.descriptor = descriptor;
        this.key = key;
    }

    @Override
    public final java.lang.String getName() {
        return this.descriptor.getName();
    }

    @Override
    public final java.lang.String getNamespaceURI() {
        if (this.descriptor.getSchema() == null) {
            return "http://www.gael.fr/drb/impl/sdf-20020222";
        }
        return this.descriptor.getSchema().getTargetNamespace();
    }

    protected long getOffset() {
        return this.descriptor.getOffset(this.key);
    }

    protected long getLength() {
        return this.descriptor.getLength(this.key);
    }

    @Override
    public java.lang.String getXPathName() {
        if (this.key.length == 0) {
            return "(" + this.descriptor.getSchemaNodePath() + ")" + this.descriptor.getRoot().getName();
        }
        int occurrence = this.key[this.key.length - 1];
        java.lang.String desc_name = this.descriptor.getName();
        if (occurrence == 0 && this.descriptor.getOccurrenceCount(this.key) <= 1) {
            return desc_name;
        }
        return desc_name + "[" + (occurrence + 1) + "]";
    }

    @Override
    public DrbAttributeList getAttributes() {
        Long long_value;
        int occurrence;
        java.lang.String strTmp;
        DrbDefaultAttributeList attr_list = new DrbDefaultAttributeList();
        switch (this.descriptor.getEncoding()) {
            case 1: {
                strTmp = "Binary";
                break;
            }
            case 2: {
                strTmp = "Ascii";
                break;
            }
            case 3: {
                strTmp = "Ebcdic";
                break;
            }
            default: {
                strTmp = "Unknown (" + this.descriptor.getEncoding() + ")";
            }
        }
        String str_value = new String(strTmp);
        DrbDefaultAttribute attr = new DrbDefaultAttribute("encoding", str_value, false, this);
        attr_list.add(attr);
        int n = occurrence = this.key.length > 0 ? this.key[this.key.length - 1] : -1;
        if (occurrence > 0) {
            long_value = new Long(occurrence + 1);
            attr = new DrbDefaultAttribute("occurrence", long_value, false, this);
            attr_list.add(attr);
        }
        if (!this.hasChild()) {
            long_value = new Long(this.descriptor.getOffset(this.key));
            attr = new DrbDefaultAttribute("offset", long_value, false, this);
            attr_list.add(attr);
            int bitLength = this.descriptor.getBitLength();
            if (bitLength == 0) {
                long_value = new Long(this.descriptor.getLength(this.key));
                attr = new DrbDefaultAttribute("length", long_value, false, this);
            } else {
                long_value = new Long(8L * this.descriptor.getLength(this.key) + (long)bitLength);
                attr = new DrbDefaultAttribute("bitLength", long_value, false, this);
            }
            attr_list.add(attr);
        }
        if ((strTmp = this.descriptor.getDocumentation()) != null) {
            str_value = new String(strTmp);
            attr = new DrbDefaultAttribute("documentation", str_value, false, this);
            attr_list.add(attr);
        }
        if (this.descriptor.getType() != null && this.descriptor.getType().getName() != null) {
            str_value = new String(this.descriptor.getType().getName());
            attr = new DrbDefaultAttribute("type", str_value, false, this);
            attr_list.add(attr);
        }
        if (attr_list.getLength() > 0) {
            return attr_list;
        }
        return null;
    }

    @Override
    public abstract Value getValue();

    @Override
    public abstract int getValueType();

    @Override
    public int getIndex() {
        if (this.key.length == 0) {
            return 0;
        }
        int curIndex = 0;
        for (Descriptor childDesc = this.descriptor.getParent().getFirstChild(); childDesc != null; childDesc = childDesc.getNextSibling()) {
            if (this.descriptor == childDesc) {
                return curIndex + this.key[this.key.length - 1];
            }
            curIndex += childDesc.getOccurrenceCount(this.key);
        }
        logger.error("AbstractBlock.getIndex() ERROR: This message should never appear !");
        logger.error("   No descriptor in the parent matches the current one = " + this.descriptor);
        return -1;
    }

    @Override
    public DrbNode getRoot() {
        if (this.key.length == 0) {
            return this;
        }
        return new DefaultBlock(this.descriptor.getRoot(), new int[0]);
    }

    @Override
    public DrbNode getParent() {
        if (this.key.length == 0) {
            return this.descriptor.getBaseNode();
        }
        Descriptor parentDesc = this.descriptor.getParent();
        int[] parentKey = IntMap.getParentKey(this.key);
        return AbstractBlock.createOptimalBlock(parentDesc, parentKey, parentDesc.getOccurrenceCount(parentKey));
    }

    @Override
    public DrbNodeList getChildren() {
        DrbDefaultNodeList children = new DrbDefaultNodeList();
        for (Descriptor childDesc = this.descriptor.getFirstChild(); childDesc != null; childDesc = childDesc.getNextSibling()) {
            int childDescOccurrenceCount = childDesc.getOccurrenceCount(IntMap.getChildKey(this.key, 0));
            for (int i = 0; i < childDescOccurrenceCount; ++i) {
                children.add(AbstractBlock.createOptimalBlock(childDesc, IntMap.getChildKey(this.key, i), childDescOccurrenceCount));
            }
        }
        if (children.size() == 0) {
            return null;
        }
        return children;
    }

    @Override
    public boolean hasChild() {
        for (Descriptor childDesc = this.descriptor.getFirstChild(); childDesc != null; childDesc = childDesc.getNextSibling()) {
            if (childDesc.getOccurrenceCount(IntMap.getChildKey(this.key, 0)) <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public DrbNode getFirstChild() {
        for (Descriptor childDesc = this.descriptor.getFirstChild(); childDesc != null; childDesc = childDesc.getNextSibling()) {
            int[] childKey = IntMap.getChildKey(this.key, 0);
            int childDescOccurrenceCount = childDesc.getOccurrenceCount(childKey);
            if (childDescOccurrenceCount <= 0) continue;
            return AbstractBlock.createOptimalBlock(childDesc, childKey, childDescOccurrenceCount);
        }
        return null;
    }

    @Override
    public DrbNode getLastChild() {
        return this.getChildAt(this.getChildrenCount() - 1);
    }

    @Override
    public DrbNode getChildAt(int index) {
        if (index < 0) {
            return null;
        }
        int childrenCount = 0;
        for (Descriptor childDesc = this.descriptor.getFirstChild(); childDesc != null; childDesc = childDesc.getNextSibling()) {
            int[] childKey = IntMap.getChildKey(this.key, index - childrenCount);
            int descOccurrenceCount = childDesc.getOccurrenceCount(childKey);
            if (descOccurrenceCount > index - childrenCount) {
                return AbstractBlock.createOptimalBlock(childDesc, childKey, descOccurrenceCount);
            }
            childrenCount += descOccurrenceCount;
        }
        return null;
    }

    @Override
    public DrbNode getNamedChild(java.lang.String name, int occurrence) {
        if (occurrence < 1) {
            logger.error("getNamedChild() Error : Invalid occurrence (" + occurrence + ").");
            return null;
        }
        for (Descriptor childDesc = this.descriptor.getFirstChild(); childDesc != null; childDesc = childDesc.getNextSibling()) {
            if (!childDesc.getName().equals(name)) continue;
            int[] childKey = IntMap.getChildKey(this.key, 0);
            int descOccurrenceCount = childDesc.getOccurrenceCount(childKey);
            if (descOccurrenceCount >= occurrence) {
                childKey[childKey.length - 1] = occurrence - 1;
                return AbstractBlock.createOptimalBlock(childDesc, childKey, descOccurrenceCount);
            }
            occurrence -= descOccurrenceCount;
        }
        return null;
    }

    @Override
    public int getChildrenCount() {
        int childrenCount = 0;
        for (Descriptor childDesc = this.descriptor.getFirstChild(); childDesc != null; childDesc = childDesc.getNextSibling()) {
            childrenCount += childDesc.getOccurrenceCount(IntMap.getChildKey(this.key, 0));
        }
        return childrenCount;
    }

    @Override
    public DrbNode getPreviousSibling() {
        return ((AbstractBlock)this.getParent()).getChildAt(this.getIndex() - 1);
    }

    @Override
    public DrbNode getNextSibling() {
        if (this.key.length == 0) {
            return null;
        }
        int curOccurrence = this.key[this.key.length - 1];
        int descOccurrenceCount = this.descriptor.getOccurrenceCount(this.key);
        if (curOccurrence < descOccurrenceCount - 1) {
            return AbstractBlock.createOptimalBlock(this.descriptor, IntMap.getSiblingKey(this.key, curOccurrence + 1), descOccurrenceCount);
        }
        Descriptor nextDesc = this.descriptor;
        while ((nextDesc = nextDesc.getNextSibling()) != null) {
            int[] nextKey = IntMap.getSiblingKey(this.key, 0);
            descOccurrenceCount = nextDesc.getOccurrenceCount(nextKey);
            if (descOccurrenceCount <= 0) continue;
            return AbstractBlock.createOptimalBlock(nextDesc, nextKey, descOccurrenceCount);
        }
        return null;
    }

    protected static final AbstractBlock createOptimalBlock(Descriptor descriptor, int[] key, int occurrence_count) {
        int lengthType = descriptor.getLengthType();
        if (occurrence_count > 1 && (lengthType == 1 || lengthType == 2)) {
            return new MultipleOccurrenceBlock(descriptor, key, occurrence_count, descriptor.getOffset(key), descriptor.getLength(key));
        }
        return new DefaultBlock(descriptor, key);
    }

    @Override
    public void close(boolean deep) {
        if (deep && this.descriptor != null && this.key.length == 0) {
            this.descriptor.dispose();
        }
    }

    @Override
    public XsdInvalid isValid() {
        if (this.descriptor.getType() == null) {
            return null;
        }
        return this.descriptor.getType().isValid(this);
    }

    @Override
    public void rename(java.lang.String name) throws NullPointerException, UnsupportedOperationException {
        throw new UnsupportedOperationException("AbstractBlock.rename(): This operation is not supported. SDF node name is defined by the underlying schema.");
    }

    @Override
    public Value setValue(Value value) throws NullPointerException, ClassCastException, UnsupportedOperationException {
        if (value == null) {
            throw new NullPointerException("AbstractBlock.setValue(): The reference to the new value is null.");
        }
        return this.descriptor.setValue(value, this.key);
    }

    @Override
    public void setAttributes(DrbAttributeList attributes) throws NullPointerException, UnsupportedOperationException {
        throw new UnsupportedOperationException("AbstractBlock.setAttributes(): This operation is not supported. SDF node attributes are computed according to the file instance and the underlying schema.");
    }

    @Override
    public void setNamespaceURI(java.lang.String namespace_uri) throws NullPointerException, UnsupportedOperationException {
        throw new UnsupportedOperationException("AbstractBlock.setNamespaceURI(): This operation is not supported. SDF namespace is defined and constant.");
    }

    @Override
    public DrbNode insertChild(DrbNode node, int index) throws NullPointerException, UnsupportedOperationException, IndexOutOfBoundsException {
        if (node == null) {
            throw new NullPointerException("AbstractBlock.insertChild(): The reference to the node to insert is null.");
        }
        return this.appendChild(node);
    }

    @Override
    public DrbNode appendChild(DrbNode node) throws NullPointerException, UnsupportedOperationException {
        if (node == null) {
            throw new NullPointerException("AbstractBlock.appendChild(): The reference to the node to append is null.");
        }
        return this.descriptor.appendChild(node, this.key, false, true, 1);
    }

    @Override
    public DrbNode replaceChild(int index, DrbNode new_node) throws NullPointerException, IndexOutOfBoundsException, UnsupportedOperationException {
        throw new UnsupportedOperationException("AbstractBlock.replaceChild(): This operation is not supported yet.");
    }

    @Override
    public void removeChild(int index) throws IndexOutOfBoundsException, UnsupportedOperationException {
        throw new UnsupportedOperationException("AbstractBlock.removeChild(): This operation is not supported yet.");
    }

    @Override
    public java.lang.String toString() {
        java.lang.String info = this.descriptor.getName();
        Descriptor tmp = this.descriptor;
        while ((tmp = tmp.getParent()) != null) {
            info = tmp.getName() + "/" + info;
        }
        info = "{ \"" + info + "\" ";
        info = info + IntMap.keyToString(this.key) + " }";
        return info;
    }
}

