/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.impl.sdf;

import fr.gael.drb.impl.sdf.AbstractBlock;
import fr.gael.drb.impl.sdf.Descriptor;
import fr.gael.drb.value.Value;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.log4j.Logger;

public class DefaultBlock
extends AbstractBlock {
    private static Logger logger = Logger.getLogger(DefaultBlock.class);
    private boolean hasChildDone = false;
    private boolean hasChildValue = false;
    private int childrenCountValue = -1;
    private int indexValue = -1;
    protected Value value = null;

    protected DefaultBlock(Descriptor descriptor, int[] key) {
        super(descriptor, key);
    }

    @Override
    public int getIndex() {
        if (this.indexValue < 0) {
            this.indexValue = super.getIndex();
        }
        return this.indexValue;
    }

    @Override
    public boolean hasChild() {
        if (!this.hasChildDone) {
            this.hasChildValue = super.hasChild();
            this.hasChildDone = true;
        }
        return this.hasChildValue;
    }

    @Override
    public int getChildrenCount() {
        if (this.childrenCountValue < 0) {
            this.childrenCountValue = super.getChildrenCount();
        }
        return this.childrenCountValue;
    }

    @Override
    public boolean hasImpl(Class api) {
        if (api == InputStream.class) {
            return true;
        }
        return super.hasImpl(api);
    }

    @Override
    public Object getImpl(Class api) {
        if (api == InputStream.class) {
            Value value = this.getValue();
            if (value == null) {
                return null;
            }
            switch (value.getType()) {
                case 7: {
                    return new ByteArrayInputStream(value.toString().getBytes());
                }
            }
            return null;
        }
        return super.getImpl(api);
    }

    @Override
    public Value getValue() {
        if (this.hasChild()) {
            return null;
        }
        if (this.value == null) {
            this.value = this.descriptor.getValue(this.key);
        }
        return this.value;
    }

    @Override
    public int getValueType() {
        return this.descriptor.getValueType();
    }

    @Override
    public Value setValue(Value value) throws NullPointerException, ClassCastException, UnsupportedOperationException {
        this.value = super.setValue(value);
        return this.value;
    }
}

