/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.impl.sdf;

import fr.gael.drb.impl.sdf.IntMap;
import fr.gael.drb.impl.sdf.LongMapEntry;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.log4j.Logger;

final class LongMap {
    private static Logger logger = Logger.getLogger(LongMap.class);
    private ArrayList item = new ArrayList();

    protected LongMap() {
    }

    private final LongMapEntry getEntry(int[] key) {
        if (key == null) {
            logger.error("LongMap.getEntry() ERROR: Invalid parameter.");
            logger.error("   key is null.");
            return null;
        }
        int size = this.item.size();
        for (int i = size - 1; i >= 0; --i) {
            LongMapEntry entry = (LongMapEntry)this.item.get(i);
            if (!Arrays.equals(entry.getKey(), key)) continue;
            return entry;
        }
        return null;
    }

    protected final long get(int[] key) {
        LongMapEntry entry = this.getEntry(key);
        if (entry == null) {
            return -1L;
        }
        return entry.getValue();
    }

    protected final void add(int[] key, long value) {
        if (key == null) {
            logger.warn("LongMap.add() WARNING: Invalid parameter.");
            logger.warn("   key is null, nothing added to the map.");
            return;
        }
        LongMapEntry entry = this.getEntry(key);
        if (entry != null) {
            entry.setValue(value);
        } else {
            entry = new LongMapEntry(key, value);
            this.item.add(entry);
        }
    }

    protected final int getSize() {
        return this.item.size();
    }

    public final String toString() {
        String info = "{" + this.item.size() + " ";
        for (int i = 0; i < this.item.size(); ++i) {
            info = info + this.item.get(i);
            if (i >= this.item.size() - 1) continue;
            info = info + ", ";
        }
        info = info + "}";
        return info;
    }

    public static void main(String[] args) {
        System.out.println("\nTest part 1");
        LongMap map = new LongMap();
        map.get(null);
        map.get(new int[0]);
        System.out.println("map = " + map);
        map.add(new int[0], 10L);
        map.add(new int[]{1}, 0x100000000L);
        map.add(new int[]{2}, 20L);
        map.add(new int[]{1, 0}, -4294967296L);
        map.add(new int[]{1, 0, 1}, 90L);
        map.add(new int[]{1, 0, 5}, 340L);
        System.out.println("map avant = " + map);
        System.out.println("Add sur cle existante ({1,0,5}).");
        map.add(new int[]{1, 0, 5}, 12L);
        System.out.println("map apres = " + map);
        System.out.println("getKey() = " + IntMap.keyToString(((LongMapEntry)map.item.get(5)).getKey()));
        System.out.println("\nparentKey({5,4,3,2}) = " + IntMap.keyToString(IntMap.getParentKey(new int[]{5, 4, 3, 2})));
        System.out.println("\nchildKey({5,4,3,2},7) = " + IntMap.keyToString(IntMap.getChildKey(new int[]{5, 4, 3, 2}, 7)));
        System.out.println("\nsiblingKey({5,4,3,2},7) = " + IntMap.keyToString(IntMap.getSiblingKey(new int[]{5, 4, 3, 2}, 7)));
    }
}

