/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.impl.sds;

import fr.gael.drb.impl.sds.Descriptor;
import fr.gael.drb.impl.sds.Length;
import fr.gael.drb.impl.sds.RandomAccessData;
import fr.gael.drb.value.AbstractValueArray;
import fr.gael.drb.value.Boolean;
import fr.gael.drb.value.BooleanArray;
import fr.gael.drb.value.Byte;
import fr.gael.drb.value.ByteArray;
import fr.gael.drb.value.DateTime;
import fr.gael.drb.value.Decimal;
import fr.gael.drb.value.DefaultValueArray;
import fr.gael.drb.value.Double;
import fr.gael.drb.value.DoubleArray;
import fr.gael.drb.value.FloatArray;
import fr.gael.drb.value.Int;
import fr.gael.drb.value.IntArray;
import fr.gael.drb.value.Integer;
import fr.gael.drb.value.LongArray;
import fr.gael.drb.value.Numeric;
import fr.gael.drb.value.Short;
import fr.gael.drb.value.ShortArray;
import fr.gael.drb.value.UnsignedByte;
import fr.gael.drb.value.UnsignedByteArray;
import fr.gael.drb.value.UnsignedInt;
import fr.gael.drb.value.UnsignedIntArray;
import fr.gael.drb.value.UnsignedLong;
import fr.gael.drb.value.UnsignedLongArray;
import fr.gael.drb.value.UnsignedShort;
import fr.gael.drb.value.UnsignedShortArray;
import fr.gael.drb.value.Value;
import fr.gael.drb.value.ValueArray;
import fr.gael.drb.value.ValueFormat;
import java.io.EOFException;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

class BlockTools {
    private static Logger logger = Logger.getLogger(BlockTools.class);
    private static Pattern doublePattern = null;
    private static Pattern integerPattern = null;
    private static Pattern booleanPattern = null;

    BlockTools() {
    }

    protected static final long extractAsciiLong(byte[] buffer, Length stop_index) {
        return BlockTools.extractAsciiLong(new String(buffer), stop_index);
    }

    protected static final long extractAsciiLong(byte[] buffer, int offset, int length) {
        return BlockTools.extractAsciiLong(new String(buffer, offset, length), new Length(length, 0L));
    }

    protected static final long extractAsciiLong(byte[] buffer, int offset, Length stop_index) {
        return BlockTools.extractAsciiLong(new String(buffer, offset, buffer.length - offset), stop_index);
    }

    protected static final long extractAsciiLong(String buffer, Length stop_index) {
        int start_index = 0;
        for (start_index = 0; start_index < buffer.length() && Character.isWhitespace(buffer.charAt(start_index)); ++start_index) {
        }
        if (integerPattern == null) {
            integerPattern = Pattern.compile("(\\+|\\-)?[0-9]+");
        }
        Matcher matcher = integerPattern.matcher(buffer);
        matcher.find(start_index);
        int end_index = matcher.end();
        if (buffer.charAt(start_index) == '+') {
            ++start_index;
        }
        String tmpStr = buffer.substring(start_index, end_index);
        stop_index.setLength(end_index, 0L);
        return Long.parseLong(tmpStr);
    }

    protected static final String extractAsciiBoolean(String buffer, Length stop_index) {
        int start_index = 0;
        for (start_index = 0; start_index < buffer.length() && Character.isWhitespace(buffer.charAt(start_index)); ++start_index) {
        }
        if (booleanPattern == null) {
            booleanPattern = Pattern.compile("true|false|0|1");
        }
        Matcher matcher = booleanPattern.matcher(buffer);
        matcher.find(start_index);
        stop_index.setLength(matcher.end(), 0L);
        return matcher.group();
    }

    protected static final double extractAsciiDouble(byte[] buffer, Length stop_index) {
        return BlockTools.extractAsciiDouble(new String(buffer), stop_index);
    }

    protected static final double extractAsciiDouble(byte[] buffer, int start_index, Length stop_index) {
        return BlockTools.extractAsciiDouble(new String(buffer, start_index, buffer.length - start_index), stop_index);
    }

    protected static final double extractAsciiDouble(String buffer, Length stop_index) {
        int start_index = 0;
        for (start_index = 0; start_index < buffer.length() && Character.isWhitespace(buffer.charAt(start_index)); ++start_index) {
        }
        int end_index = start_index;
        if (doublePattern == null) {
            doublePattern = Pattern.compile("(\\+|\\-)?[0-9]*\\.?[0-9]*((d|D|e|E)(\\+|\\-)?[0-9]+)?");
        }
        Matcher matcher = doublePattern.matcher(buffer);
        matcher.find(start_index);
        String tmpStr = matcher.group().replace('D', 'E');
        stop_index.setLength(matcher.end(), 0L);
        return java.lang.Double.parseDouble(tmpStr);
    }

    protected static final String extractAsciiDecimal(String buffer, Length stop_index) {
        int start_index = 0;
        for (start_index = 0; start_index < buffer.length() && Character.isWhitespace(buffer.charAt(start_index)); ++start_index) {
        }
        int end_index = start_index;
        if (doublePattern == null) {
            doublePattern = Pattern.compile("(\\+|\\-)?[0-9]*\\.?[0-9]*((d|D|e|E)(\\+|\\-)?[0-9]+)?");
        }
        Matcher matcher = doublePattern.matcher(buffer);
        matcher.find(start_index);
        String tmpStr = matcher.group().replace('D', 'E');
        stop_index.setLength(matcher.end(), 0L);
        return matcher.group().replace('D', 'E');
    }

    protected static final int skipDelimiter(byte[] buffer, int stop_index, String end_delimiter) {
        if (end_delimiter.length() == 0) {
            return stop_index;
        }
        byte delimiter_char = (byte)end_delimiter.charAt(0);
        for (int i = stop_index; i < buffer.length; ++i) {
            if (buffer[i] != delimiter_char) continue;
            return i + 1;
        }
        return buffer.length;
    }

    protected static final BigInteger extractBinaryInteger(byte[] buffer, Length len, boolean is_signed) {
        int byte_len = (int)len.getLength();
        byte bit_len = len.getBitLength();
        if (bit_len > 0) {
            int comp_bit_len = 8 - bit_len;
            for (int i = byte_len; i > 0; --i) {
                buffer[i] = (byte)((buffer[i] & 0xFF) >>> comp_bit_len | (buffer[i - 1] & 0xFF) << bit_len);
            }
            buffer[0] = (byte)((buffer[0] & 0xFF) >>> comp_bit_len);
            if (is_signed) {
                buffer[0] = (byte)(buffer[0] & 0xFF | 255 << bit_len);
            }
        }
        if (!is_signed && buffer[0] < 0) {
            return new BigInteger(1, buffer);
        }
        return new BigInteger(buffer);
    }

    protected static final void swapBuffer(byte[] buffer, int off, int len) {
        int i1 = off;
        int i2 = len - 1;
        while (i1 < i2) {
            byte tmp = buffer[i1];
            buffer[i1++] = buffer[i2];
            buffer[i2--] = tmp;
        }
    }

    protected static final Value extractValue(Descriptor descriptor, Length start_offset, Length stop_offset, long item_count, Length item_length) throws EOFException, IOException {
        RandomAccessData file = descriptor.getFile();
        int encoding = descriptor.getEncoding();
        int byte_order = descriptor.getByteOrdering();
        int value_type = descriptor.getValueType();
        int array_value_type = descriptor.getArrayValueType();
        String array_delimiter = descriptor.getArrayDelimiter();
        if (file == null) {
            return null;
        }
        byte[] buffer = new byte[]{};
        byte bit_offset = start_offset.getBitLength();
        long offset = start_offset.getLength();
        Length value_length = null;
        int bit_length = -1;
        int length = -1;
        int array_size = (int)item_count;
        int element_bit_length = -1;
        int element_length = -1;
        try {
            if (stop_offset.getLength() >= 0L) {
                length = (int)(stop_offset.getLength() - start_offset.getLength());
                bit_length = stop_offset.getBitLength() - start_offset.getBitLength();
                value_length = new Length(length, bit_length);
                if (bit_length != 0) {
                    length = (int)value_length.getLength();
                    bit_length = value_length.getBitLength();
                }
            }
            if (item_length != null) {
                element_length = (int)item_length.getLength();
                element_bit_length = item_length.getBitLength();
            }
            file.seek(start_offset);
            if (length >= 0) {
                buffer = new byte[(8 * length + bit_length + 7) / 8];
                if (bit_length > 0) {
                    file.readFully(buffer, 0, new Length(length, bit_length));
                } else {
                    file.readFully(buffer, 0, length);
                }
            } else {
                int bufsize;
                Length buf_length = null;
                String delimiter = descriptor.getDelimiter();
                if (delimiter.length() > 0) {
                    char cur_char;
                    bufsize = 0;
                    char delimiter_char = delimiter.charAt(0);
                    while (file.available() > 0L && (cur_char = (char)file.readByte()) != delimiter_char) {
                        ++bufsize;
                    }
                    file.seek(start_offset);
                    stop_offset.setLength(start_offset.getLength() + (long)bufsize);
                    buffer = new byte[bufsize];
                    stop_offset = new Length(stop_offset.getLength(), 0L);
                    buf_length = new Length(bufsize);
                    logger.debug("Extracted " + bufsize + " bytes delimited by '" + delimiter + "'");
                } else if (value_type != 10 || item_count >= 0L) {
                    buf_length = element_length >= 0 && element_bit_length >= 0 ? new Length(item_count * (long)element_length, item_count * (long)element_bit_length) : (value_type == 10 ? new Length((int)item_count * 32) : new Length(32L));
                    bufsize = (int)(8L * buf_length.getLength() + (long)buf_length.getBitLength() + 7L) / 8;
                    int max_len = file.skipBytes(bufsize);
                    file.seek(start_offset);
                    if (max_len < bufsize) {
                        bufsize = max_len = Math.max(max_len, 0);
                        buf_length = new Length(max_len);
                    }
                    buffer = new byte[bufsize];
                }
                file.readFully(buffer, 0, buf_length);
            }
            if (encoding == 2) {
                if (descriptor.charsetName == "US-ASCII") {
                    for (int i = 0; i < buffer.length; ++i) {
                        buffer[i] = (byte)(buffer[i] & 0x7F);
                    }
                } else if (descriptor.charsetName != "ASCII") {
                    String text = new String(buffer, descriptor.charsetName);
                    buffer = text.getBytes();
                }
            }
            if (encoding != 2 && encoding != 1) {
                logger.error("fr.gael.drb.impl.sdf.BlockTools.extractValue() : Encoding not supported ! (encoding=" + encoding + ").");
                return null;
            }
            switch (value_type) {
                case 7: {
                    return new fr.gael.drb.value.String(buffer);
                }
                case 1: 
                case 12: {
                    byte byte_value;
                    if (encoding == 2) {
                        Length stop_index = new Length(length, 0L);
                        byte_value = (byte)BlockTools.extractAsciiLong(buffer, stop_index);
                        stop_offset.setLength(start_offset.getLength() + stop_index.getLength());
                        logger.debug("Extracted ASCII byte value (" + byte_value + ")");
                    } else {
                        byte_value = bit_length == 0 && length == 1 ? buffer[0] : BlockTools.extractBinaryInteger(buffer, value_length, value_type == 1).byteValue();
                    }
                    if (value_type == 1) {
                        return new Byte(byte_value);
                    }
                    return new UnsignedByte(byte_value);
                }
                case 2: 
                case 13: {
                    short short_value;
                    if (encoding == 2) {
                        Length stop_index = new Length(length, 0L);
                        short_value = (short)BlockTools.extractAsciiLong(buffer, stop_index);
                        stop_offset.setLength(start_offset.getLength() + stop_index.getLength());
                    } else {
                        short_value = bit_length == 0 && length == 2 ? (byte_order == 1 ? (short)(((buffer[1] & 0xFF) << 8) + (buffer[0] & 0xFF)) : (short)(((buffer[0] & 0xFF) << 8) + (buffer[1] & 0xFF))) : BlockTools.extractBinaryInteger(buffer, value_length, value_type == 2).shortValue();
                    }
                    if (value_type == 2) {
                        return new Short(short_value);
                    }
                    return new UnsignedShort(short_value);
                }
                case 3: 
                case 14: {
                    int int_value;
                    if (encoding == 2) {
                        Length stop_index = new Length(length, 0L);
                        int_value = (int)BlockTools.extractAsciiLong(buffer, stop_index);
                        stop_offset.setLength(start_offset.getLength() + stop_index.getLength());
                    } else {
                        int_value = bit_length == 0 && length == 4 ? (byte_order == 2 ? ((buffer[0] & 0xFF) << 24) + ((buffer[1] & 0xFF) << 16) + ((buffer[2] & 0xFF) << 8) + (buffer[3] & 0xFF) : ((buffer[3] & 0xFF) << 24) + ((buffer[2] & 0xFF) << 16) + ((buffer[1] & 0xFF) << 8) + (buffer[0] & 0xFF)) : BlockTools.extractBinaryInteger(buffer, value_length, value_type == 3).intValue();
                    }
                    if (value_type == 3) {
                        return new Int(int_value);
                    }
                    return new UnsignedInt(int_value);
                }
                case 4: 
                case 15: {
                    long long_value;
                    if (encoding == 2) {
                        Length stop_index = new Length(length, 0L);
                        long_value = BlockTools.extractAsciiLong(buffer, stop_index);
                        stop_offset.setLength(start_offset.getLength() + stop_index.getLength());
                    } else {
                        long_value = bit_length == 0 && length == 8 ? (byte_order == 1 ? ((long)(buffer[7] & 0xFF) << 56) + ((long)(buffer[6] & 0xFF) << 48) + ((long)(buffer[5] & 0xFF) << 40) + ((long)(buffer[4] & 0xFF) << 32) + ((long)(buffer[3] & 0xFF) << 24) + ((long)(buffer[2] & 0xFF) << 16) + ((long)(buffer[1] & 0xFF) << 8) + (long)(buffer[0] & 0xFF) : ((long)(buffer[0] & 0xFF) << 56) + ((long)(buffer[1] & 0xFF) << 48) + ((long)(buffer[2] & 0xFF) << 40) + ((long)(buffer[3] & 0xFF) << 32) + ((long)(buffer[4] & 0xFF) << 24) + ((long)(buffer[5] & 0xFF) << 16) + ((long)(buffer[6] & 0xFF) << 8) + (long)(buffer[7] & 0xFF)) : BlockTools.extractBinaryInteger(buffer, value_length, value_type == 4).longValue();
                    }
                    if (value_type == 4) {
                        return new fr.gael.drb.value.Long(long_value);
                    }
                    return new UnsignedLong(long_value);
                }
                case 5: {
                    float float_value;
                    if (encoding == 2) {
                        Length stop_index = new Length(length, 0L);
                        float_value = (float)BlockTools.extractAsciiDouble(buffer, stop_index);
                        if (length < 0) {
                            stop_offset.setLength(start_offset.getLength() + stop_index.getLength());
                        }
                    } else if (bit_length == 0 && length == 4) {
                        float_value = byte_order == 1 ? Float.intBitsToFloat(((buffer[3] & 0xFF) << 24) + ((buffer[2] & 0xFF) << 16) + ((buffer[1] & 0xFF) << 8) + (buffer[0] & 0xFF)) : Float.intBitsToFloat(((buffer[0] & 0xFF) << 24) + ((buffer[1] & 0xFF) << 16) + ((buffer[2] & 0xFF) << 8) + (buffer[3] & 0xFF));
                    } else {
                        logger.error("Only IEEE format is supported for BINARY float. (length=" + length + ", bits=" + bit_length + ")");
                        return null;
                    }
                    return new fr.gael.drb.value.Float(float_value);
                }
                case 6: {
                    double double_value;
                    if (encoding == 2) {
                        Length stop_index = new Length(length, 0L);
                        double_value = BlockTools.extractAsciiDouble(buffer, stop_index);
                        if (length < 0) {
                            stop_offset.setLength(start_offset.getLength() + stop_index.getLength());
                        }
                    } else if (bit_length == 0 && length == 8) {
                        long long_value = byte_order == 1 ? ((long)(buffer[7] & 0xFF) << 56) + ((long)(buffer[6] & 0xFF) << 48) + ((long)(buffer[5] & 0xFF) << 40) + ((long)(buffer[4] & 0xFF) << 32) + ((long)(buffer[3] & 0xFF) << 24) + ((long)(buffer[2] & 0xFF) << 16) + ((long)(buffer[1] & 0xFF) << 8) + (long)(buffer[0] & 0xFF) : ((long)(buffer[0] & 0xFF) << 56) + ((long)(buffer[1] & 0xFF) << 48) + ((long)(buffer[2] & 0xFF) << 40) + ((long)(buffer[3] & 0xFF) << 32) + ((long)(buffer[4] & 0xFF) << 24) + ((long)(buffer[5] & 0xFF) << 16) + ((long)(buffer[6] & 0xFF) << 8) + (long)(buffer[7] & 0xFF);
                        double_value = java.lang.Double.longBitsToDouble(long_value);
                    } else {
                        logger.error("Only IEEE format is supported for BINARY double. (length=" + length + ", bits=" + bit_length + ")");
                        return null;
                    }
                    return new Double(double_value);
                }
                case 26: {
                    if (encoding == 2) {
                        Length stop_index = new Length(length, 0L);
                        Decimal value = new Decimal(BlockTools.extractAsciiDecimal(new String(buffer), stop_index));
                        if (length < 0) {
                            stop_offset.setLength(start_offset.getLength() + stop_index.getLength());
                        }
                        return value;
                    }
                    logger.warn("decimal is not supported for BINARY encoding.");
                    return null;
                }
                case 27: {
                    BigInteger integer_value;
                    if (encoding == 2) {
                        Length stop_index = new Length(length, 0L);
                        integer_value = new BigInteger(BlockTools.extractAsciiDecimal(new String(buffer), stop_index));
                        if (length < 0) {
                            stop_offset.setLength(start_offset.getLength() + stop_index.getLength());
                        }
                    } else if (byte_order == 1) {
                        int i1 = 0;
                        int i2 = length - 1;
                        while (i1 < i2) {
                            byte tmp = buffer[i1];
                            buffer[i1++] = buffer[i2];
                            buffer[i2--] = tmp;
                        }
                        integer_value = new BigInteger(buffer);
                    } else {
                        integer_value = BlockTools.extractBinaryInteger(buffer, value_length, true);
                    }
                    return new Integer(integer_value);
                }
                case 8: {
                    if (encoding == 2) {
                        int len = buffer.length;
                        if (buffer.length > 27) {
                            len = 27;
                        }
                        DateTime value = new DateTime(new String(buffer, 0, len));
                        stop_offset.setLength(start_offset.getLength() + (long)((Object)value).toString().length());
                        return value;
                    }
                    return new DateTime(buffer);
                }
                case 0: {
                    if (encoding == 2) {
                        Length stop_index = new Length(length, 0L);
                        Boolean value = new Boolean(BlockTools.extractAsciiBoolean(new String(buffer), stop_index));
                        stop_offset.setLength(start_offset.getLength() + stop_index.getLength());
                        return value;
                    }
                    if (bit_length == 0 && length == 1) {
                        return new Boolean(buffer[0]);
                    }
                    return new Boolean(BlockTools.extractBinaryInteger(buffer, value_length, false).intValue());
                }
                case 10: {
                    int curOffset = 0;
                    Length stop_index = new Length(element_length, element_bit_length);
                    switch (array_value_type) {
                        case 1: 
                        case 12: {
                            byte[] byteArray = buffer;
                            if (encoding == 2) {
                                byteArray = new byte[array_size];
                                for (int i = 0; i < array_size; ++i) {
                                    byteArray[i] = (byte)BlockTools.extractAsciiLong(buffer, curOffset, stop_index);
                                    if (element_length > 0) {
                                        curOffset += element_length;
                                        continue;
                                    }
                                    curOffset = BlockTools.skipDelimiter(buffer, curOffset + (int)stop_index.getLength(), array_delimiter);
                                }
                                stop_offset.setLength(start_offset.getLength() + (long)curOffset);
                            } else if (element_bit_length != 0 || element_length != 1) {
                                file.seek(start_offset);
                                for (int i = 0; i < array_size; ++i) {
                                    byteArray[i] = file.readInteger(item_length, array_value_type == 1).byteValue();
                                }
                            } else {
                                byteArray = buffer;
                            }
                            if (array_value_type == 12) {
                                return new UnsignedByteArray(byteArray);
                            }
                            return new ByteArray(byteArray);
                        }
                        case 6: {
                            double[] doubleArray = new double[array_size];
                            if (encoding == 2) {
                                for (int i = 0; i < array_size; ++i) {
                                    doubleArray[i] = BlockTools.extractAsciiDouble(buffer, curOffset, stop_index);
                                    if (element_length > 0) {
                                        curOffset += element_length;
                                        continue;
                                    }
                                    curOffset = BlockTools.skipDelimiter(buffer, curOffset + (int)stop_index.getLength(), array_delimiter);
                                }
                                stop_offset.setLength(start_offset.getLength() + (long)curOffset);
                            } else if (element_bit_length == 0 && element_length == 8) {
                                long tmpLong = 0L;
                                if (byte_order == 1) {
                                    for (int i = 0; i < array_size; ++i) {
                                        tmpLong = ((long)(buffer[i * 8 + 7] & 0xFF) << 56) + ((long)(buffer[i * 8 + 6] & 0xFF) << 48) + ((long)(buffer[i * 8 + 5] & 0xFF) << 40) + ((long)(buffer[i * 8 + 4] & 0xFF) << 32) + ((long)(buffer[i * 8 + 3] & 0xFF) << 24) + ((long)(buffer[i * 8 + 2] & 0xFF) << 16) + ((long)(buffer[i * 8 + 1] & 0xFF) << 8) + (long)(buffer[i * 8] & 0xFF);
                                        doubleArray[i] = java.lang.Double.longBitsToDouble(tmpLong);
                                    }
                                } else {
                                    for (int i = 0; i < array_size; ++i) {
                                        tmpLong = ((long)(buffer[i * 8] & 0xFF) << 56) + ((long)(buffer[i * 8 + 1] & 0xFF) << 48) + ((long)(buffer[i * 8 + 2] & 0xFF) << 40) + ((long)(buffer[i * 8 + 3] & 0xFF) << 32) + ((long)(buffer[i * 8 + 4] & 0xFF) << 24) + ((long)(buffer[i * 8 + 5] & 0xFF) << 16) + ((long)(buffer[i * 8 + 6] & 0xFF) << 8) + (long)(buffer[i * 8 + 7] & 0xFF);
                                        doubleArray[i] = java.lang.Double.longBitsToDouble(tmpLong);
                                    }
                                }
                            } else {
                                logger.error("Only IEEE format is supported for BINARY double. (length=" + element_length + ", bits=" + element_bit_length + ")");
                                return null;
                            }
                            return new DoubleArray(doubleArray);
                        }
                        case 5: {
                            float[] floatArray = new float[array_size];
                            if (encoding == 2) {
                                for (int i = 0; i < array_size; ++i) {
                                    floatArray[i] = (float)BlockTools.extractAsciiDouble(buffer, curOffset, stop_index);
                                    if (element_length > 0) {
                                        curOffset += element_length;
                                        continue;
                                    }
                                    curOffset = BlockTools.skipDelimiter(buffer, curOffset + (int)stop_index.getLength(), array_delimiter);
                                }
                                stop_offset.setLength(start_offset.getLength() + (long)curOffset);
                            } else if (element_bit_length == 0 && element_length == 4) {
                                int tmpInt = 0;
                                for (int i = 0; i < array_size; ++i) {
                                    tmpInt = byte_order == 1 ? ((buffer[i * 4 + 3] & 0xFF) << 24) + ((buffer[i * 4 + 2] & 0xFF) << 16) + ((buffer[i * 4 + 1] & 0xFF) << 8) + (buffer[i * 4] & 0xFF) : ((buffer[i * 4] & 0xFF) << 24) + ((buffer[i * 4 + 1] & 0xFF) << 16) + ((buffer[i * 4 + 2] & 0xFF) << 8) + (buffer[i * 4 + 3] & 0xFF);
                                    floatArray[i] = Float.intBitsToFloat(tmpInt);
                                }
                            } else {
                                logger.error("Only IEEE format is supported for BINARY float. (length=" + element_length + ", bits=" + element_bit_length + ")");
                                return null;
                            }
                            return new FloatArray(floatArray);
                        }
                        case 26: {
                            DefaultValueArray decimalArray = new DefaultValueArray(array_size);
                            if (encoding == 2) {
                                for (int i = 0; i < array_size; ++i) {
                                    decimalArray.assign(i, new Decimal(BlockTools.extractAsciiDecimal(new String(buffer, curOffset, buffer.length - curOffset), stop_index)));
                                    if (element_length > 0) {
                                        curOffset += element_length;
                                        continue;
                                    }
                                    curOffset = BlockTools.skipDelimiter(buffer, curOffset + (int)stop_index.getLength(), array_delimiter);
                                }
                            } else {
                                logger.error("fr.gael.drb.impl.sdf.BlockTools.extractValue() : Decimal array not supported for BINARY encoding.");
                                return null;
                            }
                            stop_offset.setLength(start_offset.getLength() + (long)curOffset);
                            return decimalArray;
                        }
                        case 3: 
                        case 14: {
                            int[] intArray = new int[array_size];
                            if (encoding == 2) {
                                for (int i = 0; i < array_size; ++i) {
                                    intArray[i] = (int)BlockTools.extractAsciiLong(buffer, curOffset, stop_index);
                                    if (element_length > 0) {
                                        curOffset += element_length;
                                        continue;
                                    }
                                    curOffset = BlockTools.skipDelimiter(buffer, curOffset + (int)stop_index.getLength(), array_delimiter);
                                }
                                stop_offset.setLength(start_offset.getLength() + (long)curOffset);
                            } else if (element_bit_length != 0 || element_length != 4) {
                                file.seek(start_offset);
                                for (int i = 0; i < array_size; ++i) {
                                    intArray[i] = file.readInteger(item_length, array_value_type == 3).intValue();
                                }
                            } else if (byte_order == 1) {
                                for (int i = 0; i < array_size; ++i) {
                                    intArray[i] = ((buffer[i * 4 + 3] & 0xFF) << 24) + ((buffer[i * 4 + 2] & 0xFF) << 16) + ((buffer[i * 4 + 1] & 0xFF) << 8) + (buffer[i * 4 + 0] & 0xFF);
                                }
                            } else {
                                for (int i = 0; i < array_size; ++i) {
                                    intArray[i] = ((buffer[i * 4] & 0xFF) << 24) + ((buffer[i * 4 + 1] & 0xFF) << 16) + ((buffer[i * 4 + 2] & 0xFF) << 8) + (buffer[i * 4 + 3] & 0xFF);
                                }
                            }
                            if (array_value_type == 14) {
                                return new UnsignedIntArray(intArray);
                            }
                            return new IntArray(intArray);
                        }
                        case 4: 
                        case 15: {
                            long[] longArray = new long[array_size];
                            if (encoding == 2) {
                                for (int i = 0; i < array_size; ++i) {
                                    longArray[i] = BlockTools.extractAsciiLong(buffer, curOffset, stop_index);
                                    if (element_length > 0) {
                                        curOffset += element_length;
                                        continue;
                                    }
                                    curOffset = BlockTools.skipDelimiter(buffer, curOffset + (int)stop_index.getLength(), array_delimiter);
                                }
                                stop_offset.setLength(start_offset.getLength() + (long)curOffset);
                            } else if (element_bit_length != 0 || element_length != 8) {
                                file.seek(start_offset);
                                for (int i = 0; i < array_size; ++i) {
                                    longArray[i] = file.readInteger(item_length, array_value_type == 4).longValue();
                                }
                            } else if (byte_order == 1) {
                                for (int i = 0; i < array_size; ++i) {
                                    longArray[i] = ((long)(buffer[i * 8 + 7] & 0xFF) << 56) + ((long)(buffer[i * 8 + 6] & 0xFF) << 48) + ((long)(buffer[i * 8 + 5] & 0xFF) << 40) + ((long)(buffer[i * 8 + 4] & 0xFF) << 32) + ((long)(buffer[i * 8 + 3] & 0xFF) << 24) + ((long)(buffer[i * 8 + 2] & 0xFF) << 16) + ((long)(buffer[i * 8 + 1] & 0xFF) << 8) + (long)(buffer[i * 8] & 0xFF);
                                }
                            } else {
                                for (int i = 0; i < array_size; ++i) {
                                    longArray[i] = ((long)(buffer[i * 8] & 0xFF) << 56) + ((long)(buffer[i * 8 + 1] & 0xFF) << 48) + ((long)(buffer[i * 8 + 2] & 0xFF) << 40) + ((long)(buffer[i * 8 + 3] & 0xFF) << 32) + ((long)(buffer[i * 8 + 4] & 0xFF) << 24) + ((long)(buffer[i * 8 + 5] & 0xFF) << 16) + ((long)(buffer[i * 8 + 6] & 0xFF) << 8) + (long)(buffer[i * 8 + 7] & 0xFF);
                                }
                            }
                            if (array_value_type == 15) {
                                return new UnsignedLongArray(longArray);
                            }
                            return new LongArray(longArray);
                        }
                        case 2: 
                        case 13: {
                            short[] shortArray = new short[array_size];
                            if (encoding == 2) {
                                for (int i = 0; i < array_size; ++i) {
                                    shortArray[i] = (short)BlockTools.extractAsciiLong(buffer, curOffset, stop_index);
                                    if (element_length > 0) {
                                        curOffset += element_length;
                                        continue;
                                    }
                                    curOffset = BlockTools.skipDelimiter(buffer, curOffset + (int)stop_index.getLength(), array_delimiter);
                                }
                                stop_offset.setLength(start_offset.getLength() + (long)curOffset);
                            } else if (element_bit_length != 0 || element_length != 2) {
                                file.seek(start_offset);
                                for (int i = 0; i < array_size; ++i) {
                                    shortArray[i] = file.readInteger(item_length, array_value_type == 2).shortValue();
                                }
                            } else if (byte_order == 1) {
                                for (int i = 0; i < array_size; ++i) {
                                    shortArray[i] = (short)((buffer[i * 2 + 1] << 8) + (buffer[i * 2] & 0xFF));
                                }
                            } else {
                                for (int i = 0; i < array_size; ++i) {
                                    shortArray[i] = (short)((buffer[i * 2] << 8) + (buffer[i * 2 + 1] & 0xFF));
                                }
                            }
                            if (array_value_type == 13) {
                                return UnsignedShortArray.wrap(shortArray);
                            }
                            return new ShortArray(shortArray);
                        }
                        case 0: {
                            boolean[] booleanArray = new boolean[array_size];
                            if (encoding == 2) {
                                for (int i = 0; i < array_size; ++i) {
                                    String bool_str = BlockTools.extractAsciiBoolean(new String(buffer, curOffset, buffer.length - curOffset), stop_index);
                                    boolean bl = booleanArray[i] = bool_str.equals("1") || bool_str.equals("true");
                                    if (element_length > 0) {
                                        curOffset += element_length;
                                        continue;
                                    }
                                    curOffset = BlockTools.skipDelimiter(buffer, curOffset + (int)stop_index.getLength(), array_delimiter);
                                }
                                stop_offset.setLength(start_offset.getLength() + (long)curOffset);
                            } else if (bit_length == 0 && length == 1) {
                                for (int i = 0; i < array_size; ++i) {
                                    booleanArray[i] = buffer[i] != 0;
                                }
                            } else {
                                file.seek(start_offset);
                                for (int i = 0; i < array_size; ++i) {
                                    booleanArray[i] = file.readInteger(item_length, false).intValue() != 0;
                                }
                            }
                            return new BooleanArray(booleanArray);
                        }
                        case 27: {
                            DefaultValueArray integerArray = new DefaultValueArray(array_size);
                            if (encoding == 2) {
                                for (int i = 0; i < array_size; ++i) {
                                    integerArray.assign(i, new Integer(BlockTools.extractAsciiDecimal(new String(buffer, curOffset, buffer.length - curOffset), stop_index)));
                                    if (element_length > 0) {
                                        curOffset += element_length;
                                        continue;
                                    }
                                    curOffset = BlockTools.skipDelimiter(buffer, curOffset + (int)stop_index.getLength(), array_delimiter);
                                }
                                stop_offset.setLength(start_offset.getLength() + (long)curOffset);
                            } else if (byte_order == 1) {
                                int k = 0;
                                byte[] integerBuffer = new byte[element_length];
                                for (int i = 0; i < array_size; ++i) {
                                    int j = element_length - 1;
                                    while (j >= 0) {
                                        integerBuffer[j--] = buffer[k++];
                                    }
                                    integerArray.assign(i, new Integer(integerBuffer));
                                }
                            } else {
                                file.seek(start_offset);
                                for (int i = 0; i < array_size; ++i) {
                                    integerArray.assign(i, new Integer(file.readInteger(new Length(element_length, element_bit_length), true)));
                                }
                            }
                            return integerArray;
                        }
                        case 8: {
                            DefaultValueArray dateArray = new DefaultValueArray(array_size);
                            byte[] dateBuffer = new byte[]{};
                            if (element_length > 0) {
                                dateBuffer = new byte[element_length];
                            }
                            curOffset = 0;
                            for (int i = 0; i < array_size; ++i) {
                                int date_length = element_length;
                                if (element_length < 0 && array_delimiter.length() > 0) {
                                    int end_offset = BlockTools.skipDelimiter(buffer, curOffset, array_delimiter);
                                    date_length = end_offset - curOffset - array_delimiter.length();
                                }
                                for (int j = 0; j < date_length; ++j) {
                                    dateBuffer[j] = buffer[curOffset++];
                                }
                                if (element_length >= 0) {
                                    curOffset = BlockTools.skipDelimiter(buffer, curOffset, array_delimiter);
                                }
                                if (encoding == 2) {
                                    dateArray.assign(i, new DateTime(new String(dateBuffer, 0, date_length)));
                                    continue;
                                }
                                dateArray.assign(i, new DateTime(dateBuffer));
                            }
                            stop_offset.setLength(start_offset.getLength() + (long)curOffset);
                            return dateArray;
                        }
                        case 7: {
                            DefaultValueArray stringArray = new DefaultValueArray(array_size);
                            curOffset = 0;
                            for (int i = 0; i < array_size; ++i) {
                                String current_string = null;
                                if (element_length >= 0) {
                                    current_string = new String(buffer, curOffset, element_length);
                                    curOffset += element_length;
                                }
                                if (array_delimiter.length() > 0) {
                                    int old_offset = curOffset;
                                    curOffset = BlockTools.skipDelimiter(buffer, curOffset, array_delimiter);
                                    if (element_length < 0) {
                                        current_string = new String(buffer, old_offset, curOffset - old_offset - array_delimiter.length());
                                    }
                                }
                                stringArray.assign(i, new fr.gael.drb.value.String(current_string));
                            }
                            stop_offset.setLength(start_offset.getLength() + (long)curOffset);
                            return stringArray;
                        }
                    }
                    logger.error("fr.gael.drb.impl.sdf.BlockTools.extractValue() : Array type not supported (" + array_value_type + ").");
                    return null;
                }
            }
            if (encoding == 2) {
                return new fr.gael.drb.value.String(buffer).convertTo(value_type);
            }
            logger.warn("The value type (" + value_type + ") is not supported for BINARY encoding.");
            return null;
        }
        catch (NumberFormatException e) {
            logger.debug("fr.gael.drb.impl.sdf.BlockTools.extractValue() : Error while extracting value from Ascii buffer.descriptor=" + descriptor.getName() + ", offset=" + offset + ", length=" + length + ", buffer='" + new String(buffer) + "').");
            logger.debug("   " + e);
            return null;
        }
        catch (EOFException e) {
            logger.debug("fr.gael.drb.impl.sdf.BlockTools.extractValue() : End of file reached.");
            logger.debug("   " + e);
            return null;
        }
        catch (Exception e) {
            logger.debug("fr.gael.drb.impl.sdf.BlockTools.extractValue() : Error while reading file (descriptor=" + descriptor.getName() + ", offset=" + offset + ", length=" + length + ", item_count=" + item_count + ", item_length=" + item_length + ", value_type=" + value_type + ", buffer='" + new String(buffer) + "').");
            logger.debug("   " + e);
            return null;
        }
    }

    private static final String getFixedString(Value in_value, int length, char fill_char) {
        if (length == 0) {
            return "";
        }
        if (in_value == null) {
            return BlockTools.getFixedString("", length, fill_char);
        }
        return BlockTools.getFixedString(in_value.toString(), length, fill_char);
    }

    public static final String getFixedString(String in_str, int length, char fill_char) {
        int inStrLength;
        if (length == 0) {
            return "";
        }
        if (in_str == null) {
            in_str = "";
        }
        if ((inStrLength = in_str.length()) == length || length < 0) {
            return in_str;
        }
        if (inStrLength > length) {
            return in_str.substring(0, length);
        }
        for (int i = 0; i < length - inStrLength; ++i) {
            in_str = fill_char + in_str;
        }
        return in_str;
    }

    protected static final Length encodeValue(RandomAccessData file, Descriptor descriptor, Length start_offset, Length value_length, long item_count, Length item_length, Value value) throws IOException {
        int encoding = descriptor.getEncoding();
        int byte_order = descriptor.getByteOrdering();
        int value_type = descriptor.getValueType();
        int array_value_type = descriptor.getArrayValueType();
        String array_delimiter = descriptor.getArrayDelimiter();
        byte[] buffer = new byte[]{};
        if (logger.isDebugEnabled()) {
            logger.debug("encodeValue(file, start_offset=" + start_offset + ", value_length=" + value_length + ", item_length=" + item_length + ", encoding=" + encoding + ", byte_order=" + byte_order + ", value_type=" + value_type + ", array_value_type=" + array_value_type);
        }
        if (file == null) {
            return null;
        }
        Value output_value = value;
        ValueArray value_array = null;
        int array_size = 0;
        byte bit_offset = start_offset.getBitLength();
        long offset = start_offset.getLength();
        int bit_length = -1;
        int length = -1;
        int element_bit_length = -1;
        int element_length = -1;
        if (item_length != null) {
            element_length = (int)item_length.getLength();
            element_bit_length = item_length.getBitLength();
        }
        if (value_length != null) {
            length = (int)value_length.getLength();
            bit_length = value_length.getBitLength();
        }
        try {
            file.seek(start_offset);
            if (encoding != 2 && encoding != 1) {
                logger.error("fr.gael.drb.impl.sdf.BlockTools.encodeValue() : Encoding not supported ! (encoding=" + encoding + ").");
                return null;
            }
            if (encoding == 2) {
                if (value_type != 10) {
                    String out_string = null;
                    if (value != null) {
                        output_value = value.convertTo(value_type);
                    }
                    if (descriptor.textFormat == null || value == null) {
                        out_string = BlockTools.getFixedString(output_value, length, ' ');
                    } else {
                        out_string = descriptor.textFormat.formatString(output_value);
                        out_string = BlockTools.getFixedString(out_string, length, ' ');
                    }
                    logger.debug("Encoded input '" + value + "' as '" + out_string + "'");
                    file.writeBytes(out_string);
                    return new Length(out_string.length());
                }
                value_array = null;
                if (value != null) {
                    output_value = value.convertTo(10);
                    value_array = (ValueArray)output_value;
                }
                if (item_count < 0L && value_array != null) {
                    item_count = value_array.length();
                }
                long total_length = 0L;
                int i = 0;
                while ((long)i < item_count) {
                    Value value_item = null;
                    if (value_array != null && i < value_array.length()) {
                        value_item = value_array.getElement(i).convertTo(array_value_type);
                    }
                    String out_string = null;
                    if (descriptor.textFormat == null || value_item == null) {
                        out_string = BlockTools.getFixedString(value_item, element_length, ' ');
                    } else {
                        out_string = descriptor.textFormat.formatString(value_item);
                        out_string = BlockTools.getFixedString(out_string, element_length, ' ');
                    }
                    if (element_length < 0 && array_delimiter.length() == 0 && (long)i != item_count - 1L) {
                        out_string = out_string + " ";
                    }
                    file.writeBytes(out_string + array_delimiter);
                    total_length += (long)out_string.length();
                    ++i;
                }
                if (length < 0) {
                    value_length = new Length(total_length);
                } else if (total_length < (long)length) {
                    file.writeBytes(BlockTools.getFixedString("", (int)((long)length - total_length), ' '));
                }
                return value_length;
            }
            switch (value_type) {
                case 0: 
                case 1: 
                case 12: {
                    if (bit_length == 0 && length == 1) {
                        if (value == null) {
                            file.writeByte(0);
                        } else {
                            output_value = value.convertTo(9);
                            file.writeByte(((Numeric)output_value).byteValue());
                        }
                        return value_length;
                    }
                    if (value != null) {
                        output_value = value.convertTo(9);
                        file.writeInteger((Numeric)output_value, value_length, value_type == 1);
                        return value_length;
                    }
                    file.writeInteger(new Short(0), value_length, false);
                    return value_length;
                }
                case 2: 
                case 13: {
                    int short_value = 0;
                    if (bit_length == 0 && length == 2) {
                        if (value != null) {
                            output_value = value.convertTo(9);
                            short_value = ((Numeric)output_value).shortValue();
                        }
                        if (byte_order == 1) {
                            short_value = (short)((short_value & 0xFF00) >>> 8 | (short_value & 0xFF) << 8);
                        }
                        file.writeShort(short_value);
                        return value_length;
                    }
                    if (value != null) {
                        output_value = value.convertTo(9);
                        file.writeInteger((Numeric)output_value, value_length, value_type == 2);
                        return value_length;
                    }
                    file.writeInteger(new Short(0), value_length, false);
                    return value_length;
                }
                case 3: 
                case 14: {
                    if (bit_length == 0 && length == 4) {
                        int int_value = 0;
                        if (value != null) {
                            output_value = value.convertTo(9);
                            int_value = ((Numeric)output_value).intValue();
                        }
                        if (byte_order == 1) {
                            int_value = (int_value & 0xFF000000) >>> 24 | (int_value & 0xFF0000) >>> 8 | (int_value & 0xFF00) << 8 | (int_value & 0xFF) << 24;
                        }
                        file.writeInt(int_value);
                        return value_length;
                    }
                    if (value != null) {
                        output_value = value.convertTo(9);
                        file.writeInteger((Numeric)output_value, value_length, value_type == 3);
                        return value_length;
                    }
                    file.writeInteger(new Int(0), value_length, false);
                    return value_length;
                }
                case 4: 
                case 15: {
                    if (bit_length == 0 && length == 8) {
                        long long_value = 0L;
                        if (value != null) {
                            output_value = value.convertTo(9);
                            long_value = ((Numeric)output_value).longValue();
                        }
                        if (byte_order == 1) {
                            long_value = (long_value & 0xFF00000000000000L) >>> 56 | (long_value & 0xFF000000000000L) >>> 40 | (long_value & 0xFF0000000000L) >>> 24 | (long_value & 0xFF00000000L) >>> 8 | (long_value & 0xFF000000L) << 8 | (long_value & 0xFF0000L) << 24 | (long_value & 0xFF00L) << 40 | (long_value & 0xFFL) << 56;
                        }
                        file.writeLong(long_value);
                        return value_length;
                    }
                    if (value != null) {
                        output_value = value.convertTo(9);
                        file.writeInteger((Numeric)output_value, value_length, value_type == 4);
                        return value_length;
                    }
                    file.writeInteger(new Int(0), value_length, false);
                    return value_length;
                }
                case 5: {
                    if (bit_length == 0 && length == 4) {
                        float float_value = 0.0f;
                        if (value != null) {
                            output_value = value.convertTo(9);
                            float_value = ((Numeric)output_value).floatValue();
                        }
                        file.writeFloat(float_value);
                        return value_length;
                    }
                    logger.error("Only IEEE format is supported for BINARY float. (length=" + length + ", bits=" + bit_length + ")");
                    return null;
                }
                case 6: {
                    if (bit_length == 0 && length == 8) {
                        double double_value = 0.0;
                        if (value != null) {
                            output_value = value.convertTo(6);
                            double_value = ((Numeric)output_value).doubleValue();
                        }
                        if (byte_order != 1) {
                            file.writeDouble(double_value);
                        }
                        return value_length;
                    }
                    logger.error("Only IEEE format is supported for BINARY double. (length=" + length + ", bits=" + bit_length + ")");
                    return null;
                }
                case 26: {
                    logger.warn("decimal is not supported for BINARY encoding.");
                    return null;
                }
                case 27: {
                    if (value == null) {
                        file.writeInteger(new Int(0), value_length, false);
                        return value_length;
                    }
                    if (byte_order == 1) {
                        buffer = new byte[length];
                        output_value = value.convertTo(27);
                        byte[] int_buf = ((Integer)output_value).integerValue().toByteArray();
                        int i1 = 0;
                        int i2 = int_buf.length - 1;
                        while (i1 < length && i2 >= 0) {
                            buffer[i1++] = int_buf[i2--];
                        }
                        byte pad = (byte)((int_buf[0] & 0x80) != 0 ? 255 : 0);
                        while (i1 < length) {
                            buffer[i1++] = pad;
                        }
                        file.write(buffer, 0, value_length);
                        return value_length;
                    }
                    output_value = value.convertTo(27);
                    file.writeInteger((Numeric)output_value, value_length, true);
                    return value_length;
                }
                case 8: {
                    if (bit_length == 0 && length == 12) {
                        DateTime date_value = null;
                        if (value != null) {
                            output_value = value.convertTo(8);
                            date_value = (DateTime)output_value;
                        } else {
                            date_value = new DateTime(0L);
                        }
                        byte[] date_buffer = date_value.getFormattedBuffer();
                        file.write(date_buffer);
                        return value_length;
                    }
                    logger.error("Only MJD2000 format is supported for BINARY dateTime. (length=" + length + ", bits=" + bit_length + ")");
                    return null;
                }
                case 10: {
                    if (value != null) {
                        output_value = value.convertTo(10);
                        value_array = (ValueArray)output_value;
                        array_size = value_array.length();
                    }
                    if (!(item_count <= 0L && (long)array_size * item_count == 0L || element_length >= 0 && element_bit_length >= 0)) {
                        logger.error("Cannot encode array with undefined item length. (length=" + element_length + ", bits=" + element_bit_length + ")");
                        return null;
                    }
                    if (value == null && length >= 0) {
                        byte[] byte_array = new byte[length];
                        Arrays.fill(byte_array, (byte)0);
                        file.write(byte_array);
                        return value_length;
                    }
                    if (value_length == null) {
                        value_length = new Length(array_size * element_length, array_size * element_bit_length);
                    }
                    if (item_count >= 0L) break;
                    item_count = array_size;
                    break;
                }
                default: {
                    logger.error("fr.gael.drb.impl.sdf.BlockTools.encodeValue() : Value type not supported (" + value_type + ").");
                    return null;
                }
            }
            switch (array_value_type) {
                case 0: 
                case 1: 
                case 12: {
                    value_array = ((AbstractValueArray)output_value).convertArrayTo(array_value_type);
                    if (element_bit_length == 0 && element_length == 1) {
                        byte[] byte_array = ((ValueFormat)((Object)value_array)).getFormattedBuffer();
                        file.write(byte_array);
                        return value_length;
                    }
                    int i = 0;
                    while ((long)i < item_count) {
                        file.writeInteger((Numeric)value_array.getElement(i), item_length, array_value_type == 1);
                        ++i;
                    }
                    return value_length;
                }
                case 6: {
                    value_array = ((AbstractValueArray)output_value).convertArrayTo(array_value_type);
                    if (element_bit_length == 0 && element_length == 8) {
                        byte[] byte_array = ((ValueFormat)((Object)value_array)).getFormattedBuffer();
                        file.write(byte_array);
                        return value_length;
                    }
                    logger.error("Only IEEE format is supported for BINARY double. (length=" + element_length + ", bits=" + element_bit_length + ")");
                    return null;
                }
                case 5: {
                    value_array = ((AbstractValueArray)output_value).convertArrayTo(array_value_type);
                    if (element_bit_length == 0 && element_length == 4) {
                        byte[] byte_array = ((ValueFormat)((Object)value_array)).getFormattedBuffer();
                        file.write(byte_array);
                        return value_length;
                    }
                    logger.error("Only IEEE format is supported for BINARY float. (length=" + element_length + ", bits=" + element_bit_length + ")");
                    return null;
                }
                case 3: 
                case 14: {
                    value_array = ((AbstractValueArray)output_value).convertArrayTo(array_value_type);
                    if (element_bit_length == 0 && element_length == 4) {
                        byte[] b = ((ValueFormat)((Object)value_array)).getFormattedBuffer();
                        if (byte_order == 1) {
                            int i = 0;
                            while ((long)i < item_count) {
                                int j = i * 4;
                                byte tmp = b[j + 0];
                                b[j + 0] = b[j + 3];
                                b[j + 3] = tmp;
                                tmp = b[j + 1];
                                b[j + 1] = b[j + 2];
                                b[j + 2] = tmp;
                                ++i;
                            }
                        }
                        file.write(b);
                        return value_length;
                    }
                    int i = 0;
                    while ((long)i < item_count) {
                        file.writeInteger((Numeric)value_array.getElement(i), item_length, array_value_type == 3);
                        ++i;
                    }
                    return value_length;
                }
                case 4: 
                case 15: {
                    value_array = ((AbstractValueArray)output_value).convertArrayTo(array_value_type);
                    if (element_bit_length == 0 && element_length == 8) {
                        byte[] b = ((ValueFormat)((Object)value_array)).getFormattedBuffer();
                        if (byte_order == 1) {
                            int i = 0;
                            while ((long)i < item_count) {
                                int j = i * 8;
                                byte tmp = b[j + 0];
                                b[j + 0] = b[j + 7];
                                b[j + 7] = tmp;
                                tmp = b[j + 1];
                                b[j + 1] = b[j + 6];
                                b[j + 6] = tmp;
                                tmp = b[j + 2];
                                b[j + 2] = b[j + 5];
                                b[j + 5] = tmp;
                                tmp = b[j + 3];
                                b[j + 3] = b[j + 4];
                                b[j + 4] = tmp;
                                ++i;
                            }
                        }
                        file.write(b);
                        return value_length;
                    }
                    int i = 0;
                    while ((long)i < item_count) {
                        file.writeInteger((Numeric)value_array.getElement(i), item_length, array_value_type == 4);
                        ++i;
                    }
                    return value_length;
                }
                case 2: 
                case 13: {
                    value_array = ((AbstractValueArray)output_value).convertArrayTo(array_value_type);
                    if (element_bit_length == 0 && element_length == 2) {
                        byte[] b = ((ValueFormat)((Object)value_array)).getFormattedBuffer();
                        if (byte_order == 1) {
                            int i = 0;
                            while ((long)i < item_count) {
                                int j = i * 2;
                                byte tmp = b[j];
                                b[j] = b[j + 1];
                                b[j + 1] = tmp;
                                ++i;
                            }
                        }
                        file.write(b);
                        return value_length;
                    }
                    int i = 0;
                    while ((long)i < item_count) {
                        file.writeInteger((Numeric)value_array.getElement(i), item_length, array_value_type == 2);
                        ++i;
                    }
                    return value_length;
                }
                case 27: {
                    if (byte_order == 1) {
                        byte[] integerBuffer = new byte[element_length];
                        int i = 0;
                        while ((long)i < item_count) {
                            Integer integer_value = (Integer)value_array.getElement(i).convertTo(27);
                            buffer = integer_value.integerValue().toByteArray();
                            int k = buffer.length - 1;
                            int j = 0;
                            while (k >= 0 && j < element_length) {
                                integerBuffer[j++] = buffer[k--];
                            }
                            byte pad = (byte)((buffer[0] & 0x80) != 0 ? 255 : 0);
                            while (j < element_length) {
                                integerBuffer[j++] = pad;
                            }
                            file.write(integerBuffer);
                            ++i;
                        }
                    } else {
                        int i = 0;
                        while ((long)i < item_count) {
                            Numeric integer_value = (Numeric)value_array.getElement(i).convertTo(27);
                            file.writeInteger(integer_value, item_length, true);
                            ++i;
                        }
                    }
                    return value_length;
                }
                case 8: {
                    if (element_bit_length == 0 && element_length == 12) {
                        int i = 0;
                        while ((long)i < item_count) {
                            DateTime date_value = (DateTime)value_array.getElement(i).convertTo(8);
                            byte[] date_buffer = date_value.getFormattedBuffer();
                            file.write(date_buffer);
                            ++i;
                        }
                        return value_length;
                    }
                    logger.error("Only MJD2000 format is supported for BINARY dateTime. (length=" + element_length + ", bits=" + element_bit_length + ")");
                    return null;
                }
                case 26: {
                    logger.error("fr.gael.drb.impl.sdf.BlockTools.encodeValue() : Decimal array not supported for BINARY encoding.");
                    return null;
                }
                case 16: {
                    logger.error("fr.gael.drb.impl.sdf.BlockTools.encodeValue() : Duration array not supported for BINARY encoding.");
                    return null;
                }
            }
            logger.error("fr.gael.drb.impl.sdf.BlockTools.encodeValue() : Array type not supported (" + array_value_type + ").");
            return null;
        }
        catch (ClassCastException e) {
            logger.error("fr.gael.drb.impl.sdf.BlockTools.encodeValue() : Error while encoding value (descriptor=" + descriptor.getPath() + " value_type=" + value_type + ", array_value_type=" + array_value_type + ", value='" + value + "').");
            logger.error("   " + e);
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) throws Exception {
        Pattern integerPattern = Pattern.compile("(\\+|\\-)?\\p{Digit}*\\.?\\p{Digit}*((d|D|e|E)(\\+|\\-)?\\p{Digit}+)?");
        Matcher matcher = integerPattern.matcher("1 04");
        matcher.find(0);
        System.err.println("[" + matcher.start() + " - " + matcher.end() + "]:'" + matcher.group() + "'");
    }
}

