/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.impl.sds;

import fr.gael.drb.impl.sds.IntMapEntry;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.log4j.Logger;

final class IntMap {
    private static Logger logger = Logger.getLogger(IntMap.class);
    private ArrayList item = new ArrayList();

    protected IntMap() {
    }

    protected final int get(int[] key) {
        if (key == null) {
            logger.error("IntMap.get() ERROR: Invalid parameter.");
            logger.error("   key is null.");
            return -1;
        }
        int size = this.item.size();
        for (int i = size - 1; i >= 0; --i) {
            IntMapEntry entry = (IntMapEntry)this.item.get(i);
            if (!Arrays.equals(entry.getKey(), key)) continue;
            return entry.getValue();
        }
        return -1;
    }

    protected final void add(int[] key, int value) {
        if (key == null) {
            logger.warn("IntMap.add() WARNING: Invalid parameter.");
            logger.warn("   key is null, nothing added to the map.");
            return;
        }
        IntMapEntry entry = new IntMapEntry(key, value);
        this.item.add(entry);
    }

    protected static final int[] getParentKey(int[] key) {
        if (key == null || key.length == 0) {
            return null;
        }
        int[] parentKey = new int[key.length - 1];
        System.arraycopy(key, 0, parentKey, 0, key.length - 1);
        return parentKey;
    }

    protected static final int[] getChildKey(int[] key, int child_id) {
        if (key == null) {
            return null;
        }
        int[] childKey = new int[key.length + 1];
        System.arraycopy(key, 0, childKey, 0, key.length);
        childKey[childKey.length - 1] = child_id;
        return childKey;
    }

    protected static final int[] getSiblingKey(int[] key, int sibling_id) {
        if (key == null) {
            return null;
        }
        if (key.length == 0) {
            return new int[0];
        }
        int[] siblingKey = new int[key.length];
        System.arraycopy(key, 0, siblingKey, 0, key.length - 1);
        siblingKey[siblingKey.length - 1] = sibling_id;
        return siblingKey;
    }

    public static final String keyToString(int[] key) {
        if (key == null) {
            return null;
        }
        String info = "{";
        for (int i = 0; i < key.length; ++i) {
            info = info + key[i];
            if (i >= key.length - 1) continue;
            info = info + " ";
        }
        info = info + "}";
        return info;
    }

    public final String toString() {
        String info = "{" + this.item.size() + " ";
        for (int i = 0; i < this.item.size(); ++i) {
            info = info + this.item.get(i);
            if (i >= this.item.size() - 1) continue;
            info = info + ", ";
        }
        info = info + "}";
        return info;
    }

    public static void main(String[] args) {
        IntMap map = new IntMap();
        map.get(null);
        map.get(new int[0]);
        System.out.println("map = " + map);
        map.add(new int[0], 10);
        map.add(new int[]{1}, 11);
        map.add(new int[]{2}, 20);
        map.add(new int[]{1, 0}, 40);
        map.add(new int[]{1, 0, 1}, 90);
        map.add(new int[]{1, 0, 5}, 340);
        System.out.println("map = " + map);
        System.out.println("getKey() = " + IntMap.keyToString(((IntMapEntry)map.item.get(5)).getKey()));
        System.out.println("\nparentKey({5,4,3,2}) = " + IntMap.keyToString(IntMap.getParentKey(new int[]{5, 4, 3, 2})));
        System.out.println("\nchildKey({5,4,3,2},7) = " + IntMap.keyToString(IntMap.getChildKey(new int[]{5, 4, 3, 2}, 7)));
        System.out.println("\nsiblingKey({5,4,3,2},7) = " + IntMap.keyToString(IntMap.getSiblingKey(new int[]{5, 4, 3, 2}, 7)));
    }
}

