/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.impl.sds;

import fr.gael.drb.impl.sds.Length;
import fr.gael.drb.impl.sds.RandomAccessData;
import fr.gael.drb.value.BinaryInteger;
import fr.gael.drb.value.Int;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.log4j.Logger;

class RandomAccessFileData
extends RandomAccessData {
    private static Logger logger = Logger.getLogger(RandomAccessFileData.class);
    RandomAccessFile file;
    int bitPosition = 0;
    int bitValue = -1;

    public RandomAccessFileData(RandomAccessFile file) {
        this.file = file;
    }

    public RandomAccessFileData(File file) throws IOException {
        this.file = new RandomAccessFile(file, "rw");
    }

    protected void finalize() throws Throwable {
        this.file.close();
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.file.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        return this.file.readByte();
    }

    @Override
    public char readChar() throws IOException {
        return this.file.readChar();
    }

    @Override
    public double readDouble() throws IOException {
        return this.file.readDouble();
    }

    @Override
    public float readFloat() throws IOException {
        return this.file.readFloat();
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        if (this.bitPosition > 0) {
            this.readFully(b, 0, b.length);
        } else {
            this.file.read(b);
        }
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        if (this.bitPosition > 0) {
            int bit_pos = this.bitPosition;
            int comp_bit_pos = 8 - this.bitPosition;
            byte[] buffer = new byte[len + 1];
            if (this.bitValue == -1) {
                this.file.read(buffer, off, len + 1);
            } else {
                this.file.read(buffer, off + 1, len);
                buffer[off] = (byte)this.bitValue;
            }
            int count = len;
            for (int i = 0; i < count; ++i) {
                b[off + i] = (byte)((buffer[i] & 0xFF) << bit_pos | (buffer[i + 1] & 0xFF) >>> comp_bit_pos);
            }
            this.bitValue = buffer[buffer.length - 1] & 0xFF;
        } else {
            this.file.read(b, off, len);
        }
    }

    @Override
    public void readFully(byte[] b, int off, Length len) throws IOException {
        int byte_len = (int)len.getLength();
        byte bit_len = len.getBitLength();
        if (bit_len == 0) {
            this.readFully(b, off, byte_len);
        } else if (this.bitPosition > 0) {
            int bit_pos = this.bitPosition;
            int comp_bit_pos = 8 - this.bitPosition;
            if (this.bitValue == -1) {
                this.file.read(b, off, byte_len + 1);
            } else {
                this.file.read(b, off + 1, byte_len);
                b[off] = (byte)this.bitValue;
            }
            this.bitValue = b[off + byte_len] & 0xFF;
            for (int i = 0; i < byte_len; ++i) {
                b[i + off] = (byte)((b[i + off] & 0xFF) << bit_pos | (b[i + off + 1] & 0xFF) >>> comp_bit_pos);
            }
            if (this.bitPosition + bit_len <= 8) {
                b[off + byte_len] = (byte)((b[off + byte_len] & 0xFF) << bit_pos);
            } else {
                this.bitValue = this.file.read();
                b[off + byte_len] = (byte)((b[off + byte_len] & 0xFF) << bit_pos | (this.bitValue & 0xFF) >>> comp_bit_pos);
            }
            this.bitPosition = (this.bitPosition + bit_len) % 8;
        } else {
            this.file.read(b, off, byte_len + 1);
            this.bitValue = b[off + byte_len] & 0xFF;
            this.bitPosition = bit_len;
        }
    }

    @Override
    public int readInt() throws IOException {
        return this.file.readInt();
    }

    @Override
    public String readLine() throws IOException {
        return this.file.readLine();
    }

    @Override
    public long readLong() throws IOException {
        return this.file.readLong();
    }

    @Override
    public short readShort() throws IOException {
        return this.file.readShort();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.file.readUnsignedByte();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.file.readUnsignedShort();
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return this.file.skipBytes(n);
    }

    @Override
    public String readUTF() throws IOException {
        return this.file.readUTF();
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.file.writeBoolean(v);
    }

    @Override
    public final void writeByte(int v) throws IOException {
        this.file.writeByte(v);
    }

    @Override
    public final void writeBits(int v, int bit_len) throws IOException {
        logger.debug("v=" + v + " (" + Integer.toBinaryString(v) + ")  len=" + bit_len + " bitValue=" + Integer.toBinaryString(this.bitValue) + " offs=" + this.file.getFilePointer() + " bit_offs=" + this.bitPosition);
        if (bit_len < 8) {
            byte val = 0;
            if (this.bitPosition == 0) {
                int b = this.file.read();
                if (b != -1) {
                    val = (byte)(b & 0xFF);
                    long off = this.file.getFilePointer();
                    this.file.seek(off);
                }
            } else if (this.bitValue != -1) {
                val = (byte)(this.bitValue & 0xFF);
                long off = this.file.getFilePointer();
                this.file.seek(off - 1L);
                logger.debug("WriteBits: seeked to " + (off - 1L));
            }
            logger.debug("val=" + Integer.toBinaryString(val & 0xFF));
            if (this.bitPosition + bit_len <= 8) {
                int mask = 255 >>> this.bitPosition & 255 << 8 - this.bitPosition - bit_len;
                logger.debug("mask=" + Integer.toBinaryString(mask));
                logger.debug("~mask=" + Integer.toBinaryString(mask ^ 0xFF));
                this.bitValue = val & (mask ^ 0xFF) | (v & 0xFF) << 8 - this.bitPosition - bit_len & mask;
                this.file.writeByte(this.bitValue);
            }
            logger.debug("new bitValue=" + Integer.toBinaryString(this.bitValue));
            this.bitPosition = (this.bitPosition + bit_len) % 8;
            if (this.bitPosition == 0) {
                this.bitValue = 0;
            }
        }
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.file.writeChar(v);
    }

    @Override
    public void writeChars(String s) throws IOException {
        this.file.writeChars(s);
    }

    @Override
    public void writeBytes(String s) throws IOException {
        this.file.writeBytes(s);
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.file.writeDouble(v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.file.writeFloat(v);
    }

    @Override
    public final void write(byte[] b) throws IOException {
        if (this.bitPosition == 0) {
            this.file.write(b);
        } else {
            this.write(b, 0, new Length(b.length, 0L));
        }
    }

    @Override
    void insert(byte[] b) throws IOException {
        throw new IOException("Insert not supported");
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.bitPosition == 0) {
            this.file.write(b, off, len);
        } else {
            this.write(b, off, new Length(len, 0L));
        }
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.file.writeInt(v);
    }

    @Override
    public void write(int v) throws IOException {
        this.file.write(v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.file.writeLong(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.file.writeShort(v);
    }

    @Override
    public void writeUTF(String str) throws IOException {
        this.file.writeUTF(str);
    }

    @Override
    public void write(byte[] b, int off, Length len) throws IOException {
        int byte_len = (int)len.getLength();
        byte bit_len = len.getBitLength();
        int comp_bit_pos = 8 - this.bitPosition;
        logger.debug("writeBytes: in file_pos=" + this.file.getFilePointer() + ", file_size=" + this.file.length());
        logger.debug("writeBytes: in bitPosition=" + this.bitPosition);
        logger.debug("writeBytes: in bitValue=" + new BinaryInteger(this.bitValue, 9));
        for (int i = 0; i < byte_len + (7 + bit_len) / 8; ++i) {
            logger.debug("writeBytes: inValue[" + i + "]=" + new BinaryInteger(b[off + i] & 0xFF, 8));
        }
        if (this.bitPosition == 0) {
            if (byte_len > 0) {
                logger.debug("write(b,off,len): Writing " + byte_len + " first bytes " + new BinaryInteger(b[off] & 0xFF, 8));
                this.file.write(b, off, byte_len);
            }
        } else if (this.bitPosition + 8 * byte_len + bit_len >= 8) {
            byte[] buffer = new byte[byte_len + (bit_len + this.bitPosition) / 8];
            long fp = this.file.getFilePointer();
            if (this.bitValue == -1) {
                int v = this.file.read();
                if (v != -1) {
                    this.bitValue = v & 0xFF;
                    this.file.seek(fp);
                } else {
                    this.bitValue = 0;
                }
            } else {
                this.file.seek(fp - 1L);
            }
            buffer[0] = (byte)((b[off] & 0xFF) >>> this.bitPosition | this.bitValue & 255 << comp_bit_pos);
            for (int i = buffer.length - 1; i > 0; --i) {
                buffer[i] = (byte)((b[off + i] & 0xFF) >>> this.bitPosition | (b[off + i - 1] & 0xFF) << comp_bit_pos);
            }
            for (int j = 0; j < buffer.length; ++j) {
                logger.debug("write(b,off,len): Shifted byte[" + j + "]=" + new BinaryInteger(buffer[j] & 0xFF, 8));
            }
            this.file.write(buffer);
            this.bitValue = -1;
        }
        if ((this.bitPosition + bit_len) % 8 != 0) {
            long fp = this.file.getFilePointer();
            int v = this.bitValue;
            if (this.bitValue == -1) {
                v = this.file.read();
                this.file.seek(fp);
            } else {
                this.file.seek(fp - 1L);
            }
            if (v == -1) {
                v = 0;
            }
            int mask = 0;
            if (this.bitPosition + bit_len > 8) {
                mask = 255 << 16 - this.bitPosition - bit_len;
                this.bitValue = (b[off + byte_len] & 0xFF) << comp_bit_pos & 0xFF;
            } else if (byte_len > 0) {
                mask = 255 << 8 - this.bitPosition - bit_len;
                this.bitValue = bit_len > 0 ? (b[off + byte_len] & 0xFF) >>> this.bitPosition | (b[off + byte_len - 1] & 0xFF) << comp_bit_pos : (b[off + byte_len - 1] & 0xFF) << comp_bit_pos;
            } else if (bit_len > 0) {
                mask = 255 >>> this.bitPosition & 255 << 8 - this.bitPosition - bit_len;
                this.bitValue = (b[off + byte_len] & 0xFF) >>> this.bitPosition;
            }
            logger.debug("writeBytes: File bits=" + new BinaryInteger(v, 8));
            logger.debug("writeBytes: Shift bits=" + new BinaryInteger(this.bitValue, 8));
            logger.debug("writeBytes: mask=" + new BinaryInteger(mask, 8));
            this.bitValue = v & (mask ^ 0xFF) | this.bitValue & mask;
            this.file.write(this.bitValue);
        }
        this.bitPosition = (this.bitPosition + bit_len) % 8;
        if (this.bitPosition == 0) {
            this.bitValue = -1;
        }
        logger.debug("writeBytes: out bitPosition=" + this.bitPosition);
        logger.debug("writeBytes: out bitValue=" + new BinaryInteger(this.bitValue, 8));
    }

    @Override
    void close() throws IOException {
        this.file.close();
    }

    @Override
    public final long available() throws IOException {
        return this.file.length() - this.file.getFilePointer();
    }

    @Override
    final void seek(long pos) throws IOException {
        this.file.seek(pos);
        this.bitPosition = 0;
        this.bitValue = -1;
    }

    @Override
    final void seek(long pos, int bit_pos) throws IOException {
        this.file.seek(pos);
        this.bitPosition = bit_pos;
        this.bitValue = -1;
    }

    @Override
    final long length() throws IOException {
        return this.file.length();
    }

    @Override
    void setLength(long len) throws IOException {
        this.file.setLength(len);
    }

    public static void main(String[] args) throws Exception {
        int i;
        int val;
        int i2;
        File temp_file = File.createTempFile("sdf-bit5-", ".tmp");
        RandomAccessFileData file = new RandomAccessFileData(temp_file);
        System.out.println("Writing 5-bits unsigned values");
        for (i2 = 0; i2 < 32; ++i2) {
            logger.debug("Writing " + i2 + " on 5-bits.");
            file.writeInteger(new Int(i2), new Length(0L, 5L), false);
        }
        file.seek(0L);
        for (i2 = 0; i2 < 32; ++i2) {
            val = file.readInteger(new Length(0L, 5L), false).intValue();
            if (val != i2) {
                System.err.println("Expected  " + i2 + " instead of " + val);
                return;
            }
            System.out.println(new BinaryInteger(val, 5));
        }
        System.out.println("");
        temp_file = File.createTempFile("sdf-bit7-", ".tmp");
        file = new RandomAccessFileData(temp_file);
        System.out.println("Writing 7-bits values");
        file.seek(0L);
        for (i2 = 0; i2 < 128; ++i2) {
            logger.debug("Writing " + i2 + " on 7-bits.");
            file.writeInteger(new Int(i2), new Length(0L, 7L), false);
        }
        file.seek(0L);
        for (i2 = 0; i2 < 128; ++i2) {
            val = file.readInteger(new Length(0L, 7L), false).intValue();
            if (val == i2) continue;
            System.err.println("Expected  " + i2 + " instead of " + val);
            return;
        }
        System.out.println("");
        System.out.println("Writing 13-bits values");
        temp_file = File.createTempFile("sdf-bit13-", ".tmp");
        file = new RandomAccessFileData(temp_file);
        file.seek(0L);
        for (i2 = 0; i2 < 8192; ++i2) {
            logger.debug("Writing " + i2 + " on 13-bits.");
            file.writeInteger(new Int(i2), new Length(0L, 13L), false);
        }
        file.seek(0L);
        byte[] buf_13 = new byte[80];
        for (i = 0; i < buf_13.length; ++i) {
            buf_13[i] = file.readByte();
        }
        file.seek(0L);
        for (i = 0; i < 8192; ++i) {
            int val2 = file.readInteger(new Length(0L, 13L), false).intValue();
            if (val2 == i) continue;
            System.err.println("Expected  " + i + " instead of " + val2);
            break;
        }
        System.out.println("");
    }
}

