/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.impl.sds;

import fr.gael.drb.DrbAbstractNode;
import fr.gael.drb.DrbAttribute;
import fr.gael.drb.DrbAttributeList;
import fr.gael.drb.DrbFactory;
import fr.gael.drb.DrbFactoryImpl;
import fr.gael.drb.DrbNode;
import fr.gael.drb.DrbNodeList;
import fr.gael.drb.impl.DrbFactoryResolver;
import fr.gael.drb.impl.DrbNodeImpl;
import fr.gael.drb.impl.sds.AbstractBlock;
import fr.gael.drb.impl.sds.DateTimeFormat;
import fr.gael.drb.impl.sds.Descriptor;
import fr.gael.drb.impl.sds.Length;
import fr.gael.drb.impl.sds.LengthAttribute;
import fr.gael.drb.impl.sds.NumericFormat;
import fr.gael.drb.impl.sds.OffsetAttribute;
import fr.gael.drb.impl.sds.PhysicalAttribute;
import fr.gael.drb.impl.sds.RandomAccessData;
import fr.gael.drb.impl.sds.SdfViewDescriptor;
import fr.gael.drb.impl.sds.StaticException;
import fr.gael.drb.impl.sds.WriterBlock;
import fr.gael.drb.impl.spi.DrbNodeSpi;
import fr.gael.drb.impl.xml.XmlFactory;
import fr.gael.drb.meta.DrbMetadata;
import fr.gael.drb.value.Numeric;
import fr.gael.drb.value.Value;
import fr.gael.drb.xsd.Namespace;
import fr.gael.drb.xsd.XmlSchema;
import fr.gael.drb.xsd.XsdComplexType;
import fr.gael.drb.xsd.XsdElement;
import fr.gael.drb.xsd.XsdFacet;
import fr.gael.drb.xsd.XsdFactory;
import fr.gael.drb.xsd.XsdLengthFacet;
import fr.gael.drb.xsd.XsdListType;
import fr.gael.drb.xsd.XsdModelGroup;
import fr.gael.drb.xsd.XsdParticle;
import fr.gael.drb.xsd.XsdSimpleType;
import fr.gael.drb.xsd.XsdType;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.Charset;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.log4j.Logger;

public final class SdfFactory
implements DrbFactoryImpl {
    public static final String SDF_2005_04_NAMESPACE = "http://www.gael.fr/2005/04/drb/sdf";
    public static final String SDF_2004_12_NAMESPACE = "http://www.gael.fr/2004/12/drb/sdf";
    public static final String SDF_2002_02_NAMESPACE = "http://www.gael.fr/drb/impl/sdf-20020222";
    private static Logger logger = Logger.getLogger(SdfFactory.class);
    private String defaultVersion = SdfFactory.getDefaultVersion();
    private String defaultSchema;
    private static boolean isEhCacheAvailable;
    private static boolean isEhCacheChecked;
    private CacheManager cacheManager = null;
    private Cache xmlSchemaCache = null;
    private static final String xmlSchemaCacheName = "fr.gael.drb.impl.sds.XmlSchemaCache";

    public SdfFactory() {
        this.initializeXmlSchemaCache();
    }

    private static boolean isEhCacheAvailable() {
        return isEhCacheAvailable;
    }

    private static boolean isEhCacheChecked() {
        return isEhCacheChecked;
    }

    private static void setEhCacheAvailable(boolean isEhCacheAvailable) {
        SdfFactory.isEhCacheAvailable = isEhCacheAvailable;
    }

    private static void setEhCacheChecked(boolean isEhCacheChecked) {
        SdfFactory.isEhCacheChecked = isEhCacheChecked;
    }

    private CacheManager getCacheManager() {
        return this.cacheManager;
    }

    private void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    private static String getXmlSchemaCacheName() {
        return xmlSchemaCacheName;
    }

    private Cache getXmlSchemaCache() {
        return this.xmlSchemaCache;
    }

    private void setXmlSchemaCache(Cache xmlSchemaCache) {
        this.xmlSchemaCache = xmlSchemaCache;
    }

    private void initializeXmlSchemaCache() {
        CacheManager cacheManager;
        if (SdfFactory.isEhCacheChecked() && !SdfFactory.isEhCacheAvailable()) {
            return;
        }
        if (!SdfFactory.isEhCacheChecked()) {
            try {
                Class.forName("net.sf.ehcache.Cache");
            }
            catch (ClassNotFoundException exception) {
                logger.info("No caching system available at runtime.");
                SdfFactory.setEhCacheAvailable(false);
                SdfFactory.setEhCacheChecked(true);
                return;
            }
            logger.debug("Caching system available.");
            SdfFactory.setEhCacheAvailable(true);
            SdfFactory.setEhCacheChecked(true);
        }
        if ((cacheManager = this.getCacheManager()) == null) {
            try {
                cacheManager = CacheManager.create(this.getClass().getResource("ehcache.xml"));
                logger.debug("XML Schema cache manager created.");
            }
            catch (CacheException exception) {
                logger.error("Cannot create XML Schema cache manager - disabling caching functionality.", exception);
                this.setXmlSchemaCache(null);
                SdfFactory.setEhCacheAvailable(false);
                return;
            }
            this.setCacheManager(cacheManager);
            cacheManager.addCacheIfAbsent(SdfFactory.getXmlSchemaCacheName());
            Cache cache = cacheManager.getCache(SdfFactory.getXmlSchemaCacheName());
            this.setXmlSchemaCache(cache);
            logger.debug("Cache of XML Schema's created.");
        } else {
            Cache cache = this.getXmlSchemaCache();
            if (cache != null) {
                cache.removeAll();
                logger.info("Cache of XML Schema's cleared.");
            } else {
                logger.error("Inconsistent XML Schema cache state: null cache with an available manager - functionality disabled");
                cacheManager.shutdown();
                this.setCacheManager(null);
                SdfFactory.setEhCacheAvailable(false);
                return;
            }
        }
    }

    private void putXmlSchemaInCache(String schemaLocation, XmlSchema xmlSchema) {
        if (schemaLocation == null) {
            throw new NullPointerException("Null schema location.");
        }
        if (xmlSchema == null) {
            throw new NullPointerException("Null XML Schema.");
        }
        Cache cache = this.getXmlSchemaCache();
        if (cache != null) {
            Element element = new Element(schemaLocation, xmlSchema);
            cache.put(element);
            logger.debug("Putting in XML Schema cache: \"" + schemaLocation + "\"");
        }
    }

    private XmlSchema getXmlSchemaFromCache(String schemaLocation) {
        Element element;
        if (schemaLocation == null) {
            throw new NullPointerException("Null item path.");
        }
        Cache cache = this.getXmlSchemaCache();
        if (cache != null && (element = cache.get((Serializable)((Object)schemaLocation))) != null) {
            logger.debug("Retrieved from XML Schema cache: \"" + schemaLocation + "\"");
            return (XmlSchema)element.getObjectValue();
        }
        return null;
    }

    public static String getDefaultVersion() {
        return SDF_2005_04_NAMESPACE;
    }

    @Override
    public final String getIdentifier() {
        return "sdf";
    }

    @Override
    public final String getName() {
        return "Structured Data File";
    }

    public final void setSchema(String path) throws UnsupportedOperationException {
        this.defaultSchema = path;
    }

    @Override
    public final DrbNode open(URL uri) {
        if (this.defaultSchema == null) {
            return null;
        }
        return DrbFactory.openURI(uri.toString());
    }

    @Override
    public final DrbNode open(DrbNode base_node) {
        Value schema_location_value;
        if (base_node == null) {
            return null;
        }
        String schema_location = null;
        DrbMetadata metadata = DrbFactoryResolver.getMetadataResolver().resolveMetadata(base_node);
        if (metadata != null && (schema_location_value = metadata.getProperty("schemaLocation")) != null) {
            schema_location = schema_location_value.toString();
        }
        if (schema_location != null) {
            XmlSchema xmlSchema = this.getXmlSchemaFromCache(schema_location);
            if (xmlSchema != null) {
                return this.open(base_node, xmlSchema, schema_location);
            }
            logger.debug("Opening schema \"" + schema_location + "\".");
            DrbNode schema = DrbFactory.openURI(schema_location);
            if (schema == null) {
                logger.warn("Cannot open schema from: " + schema_location);
                return null;
            }
            if ((schema = new XmlFactory().open(schema)) == null) {
                logger.warn("Schema \"" + schema_location + "\"has no root node.");
                return null;
            }
            return this.open(base_node, schema, schema_location);
        }
        return null;
    }

    @Override
    public final DrbNode open(URL uri, DrbNode base_node) {
        return null;
    }

    public DrbNode open(DrbNode base_node, DrbNode schema_node, String schemaLocation) {
        Namespace ns_bindings;
        if (base_node == null || schema_node == null) {
            logger.error("fr.gael.drb.impl.sdf.SdfFactory.open() : null parameter.");
            logger.error("   base_node   = " + (base_node == null ? null : "\"" + base_node.getName() + "\""));
            logger.error("   schema_node = " + (schema_node == null ? null : "\"" + schema_node.getName() + "\""));
            return null;
        }
        XsdFactory descLoader = new XsdFactory();
        String descName = schema_node.getName();
        XmlSchema schemaDesc = descLoader.open(schema_node);
        if (schemaDesc == null || schemaDesc.getRootElements() == null) {
            logger.error("fr.gael.drb.impl.sdf.SdfFactory.open() : No element found in  \"" + descName + "\"");
            return null;
        }
        this.putXmlSchemaInCache(schemaLocation, schemaDesc);
        if (schema_node instanceof DrbAbstractNode && (ns_bindings = ((DrbAbstractNode)schema_node).getNamespaceBindings()) != null) {
            if (ns_bindings.resolvePrefix(SDF_2002_02_NAMESPACE) != null) {
                this.defaultVersion = SDF_2002_02_NAMESPACE;
                logger.warn("Activated compatibility with SDF-2002-02. New features of the SDF engine may not work. Declare the '" + AbstractBlock.SDF_NAMESPACE + "' namespace to avoid this warning.");
            } else if (ns_bindings.resolvePrefix(SDF_2004_12_NAMESPACE) != null) {
                this.defaultVersion = SDF_2004_12_NAMESPACE;
            } else if (ns_bindings.resolvePrefix(SDF_2005_04_NAMESPACE) != null) {
                this.defaultVersion = SDF_2005_04_NAMESPACE;
            } else {
                logger.warn("No SDF namespace declaration in the schema.");
            }
        }
        return this.open(base_node, schemaDesc, schema_node.getParent().getPath());
    }

    public DrbNode open(DrbNode base_node, XmlSchema xml_schema, String schema_path) {
        Descriptor rootDesc;
        RandomAccessData fileData = null;
        boolean create_mode = false;
        if (base_node == null || xml_schema == null) {
            logger.error("null parameter.");
            logger.error("   base_node   = " + (base_node == null ? null : "\"" + base_node.getName() + "\""));
            return null;
        }
        if (!(base_node instanceof DrbNodeImpl)) {
            logger.error("cannot retrieve a valid implementation." + (base_node == null ? null : "\"" + base_node.getName() + "\""));
            return null;
        }
        DrbNodeImpl baseImpl = (DrbNodeImpl)base_node;
        try {
            if (xml_schema.getRootElements() == null) {
                logger.error("fr.gael.drb.impl.sdf.SdfFactory.open() : No element found from schema \"" + schema_path + "\"");
                return null;
            }
            if (xml_schema.getRootElements().length != 1) {
                logger.error("fr.gael.drb.impl.sdf.SdfFactory.open() : Node descriptor is not unique (nb=" + xml_schema.getRootElements().length + ") from schema \"" + schema_path + "\"");
                return null;
            }
            XsdElement nodeDesc = xml_schema.getDefaultRootElement();
            create_mode = false;
            if (baseImpl.hasImpl(File.class)) {
                create_mode = ((File)baseImpl.getImpl(File.class)).length() <= 0L;
            }
            rootDesc = this.parseNodeDescriptor(fileData, create_mode, nodeDesc, null, 0);
            rootDesc.setAsRoot(base_node, schema_path);
        }
        catch (StaticException e) {
            logger.error(e.getMessage(), e);
            return null;
        }
        catch (Exception e) {
            logger.error("ERROR:" + e.getMessage(), e);
            e.printStackTrace();
            return null;
        }
        DrbNode rootBlock = create_mode ? new WriterBlock(rootDesc, new int[0]) : AbstractBlock.createOptimalBlock(rootDesc, new int[0], 1);
        return DrbNodeSpi.getDrb250FileNodeFromImplNode(rootBlock, base_node);
    }

    private Descriptor parseNodeDescriptor(RandomAccessData file, boolean create_mode, XsdParticle particle, Descriptor parent_descriptor, int depth) {
        XsdType element_type;
        if (particle == null) {
            return null;
        }
        Descriptor currentDescriptor = null;
        XsdModelGroup complex_content = null;
        if (particle instanceof XsdElement) {
            XsdElement element = (XsdElement)particle;
            currentDescriptor = new Descriptor(file, create_mode, element, depth);
            this.parseExternalChildren(currentDescriptor, element);
            XsdType xsdType = element_type = currentDescriptor.viewDesc != null ? currentDescriptor.viewDesc.baseType : element.getType();
            if (element_type != null && element_type.isComplex()) {
                Object[] type_derivation = element_type.getDerivation().toArray();
                for (int ideriv = 0; ideriv < type_derivation.length; ++ideriv) {
                    if (!((XsdType)type_derivation[ideriv]).isComplex()) continue;
                    XsdElement susbtitution_element = new XsdElement(element.getMinOccurs(), element.getMaxOccurs(), element.getName(), (XsdType)type_derivation[ideriv]);
                    susbtitution_element.setAnnotation(element.getAnnotation());
                    Descriptor substitution_descriptor = this.parseNodeDescriptor(file, create_mode, susbtitution_element, parent_descriptor, depth);
                    if (!substitution_descriptor.hasSignature()) continue;
                    currentDescriptor.addSubstitution(substitution_descriptor);
                }
            }
            if (element_type == null || element_type.getStructure() == null) {
                return currentDescriptor;
            }
            XsdComplexType structure_type = element_type.getStructure();
            complex_content = structure_type.getComplexContent();
        } else if (particle instanceof XsdModelGroup) {
            XsdModelGroup group_content = (XsdModelGroup)particle;
            if (group_content.getCompositor() == 2) {
                element_type = new XsdComplexType(null, (XsdModelGroup)particle, null);
                XsdElement element = new XsdElement(particle.getMinOccurs(), particle.getMaxOccurs(), "choice", element_type);
                element.setAnnotation(group_content.getAnnotation());
                element.setExternalNodes(group_content.getExternalNodes());
                element.setExternalAttributes(group_content.getExternalAttributes());
                currentDescriptor = new Descriptor(file, create_mode, element, depth);
                this.parseExternalChildren(currentDescriptor, element);
                for (int i = 0; i < group_content.getLength(); ++i) {
                    XsdParticle choice_particle = group_content.getParticle(i);
                    Descriptor choice_descriptor = this.parseNodeDescriptor(file, create_mode, choice_particle, parent_descriptor, depth);
                    currentDescriptor.addSubstitution(choice_descriptor);
                }
            } else if (complex_content != null && complex_content.getCompositor() == 1) {
                currentDescriptor = parent_descriptor;
            }
        } else {
            logger.error("fr.gael.drb.impl.sdf.SdfFactory.parseNodeDescriptor() : Only ELEMENT_TERM is implemented at this time.");
            throw new StaticException("Unrecognized XS particle");
        }
        if (complex_content == null) {
            return currentDescriptor;
        }
        if (complex_content.getCompositor() == 2) {
            Descriptor choiceDescriptor = this.parseNodeDescriptor(file, create_mode, complex_content, currentDescriptor, depth + 1);
            currentDescriptor.addChild(choiceDescriptor);
            return currentDescriptor;
        }
        Descriptor nextDescriptor = null;
        int length = complex_content.getLength();
        for (int i = 0; i < length; ++i) {
            nextDescriptor = this.parseNodeDescriptor(file, create_mode, complex_content.getParticle(i), currentDescriptor, depth + 1);
            if (nextDescriptor == null || currentDescriptor == nextDescriptor) continue;
            currentDescriptor.addChild(nextDescriptor);
        }
        return currentDescriptor;
    }

    private static short parseUnit(DrbAttribute attribute) {
        logger.debug("parseUnit()");
        Value attributeValue = null;
        try {
            attributeValue = attribute.getValue();
            if (attributeValue == null) {
                logger.error("fr.gael.drb.impl.sdf.Descriptor.parseUnit() : Unit attribute value is null.");
                return -1;
            }
            String attributeValueStr = attributeValue.toString();
            if (attributeValueStr.equals("byte")) {
                return 2;
            }
            if (attributeValueStr.equals("bit")) {
                return 1;
            }
            logger.error("fr.gael.drb.impl.sdf.SdfFactory.parseUnit() : Unknown unit attribute value (" + attributeValueStr + ").");
            return -1;
        }
        catch (ClassCastException e) {
            logger.error("fr.gael.drb.impl.sdf.SdfFactory.parseUnit() : Error while extracting unit attribute value (" + attributeValue + ").");
            logger.error("   " + e);
            return -1;
        }
    }

    private static short parseContext(DrbAttribute attribute) {
        logger.debug("parseContext()");
        Value attributeValue = null;
        try {
            attributeValue = attribute.getValue();
            if (attributeValue == null) {
                logger.error("fr.gael.drb.impl.sdf.Descriptor.parseContext() : Unit attribute value is null.");
                return -1;
            }
            String attributeValueStr = attributeValue.toString();
            if (attributeValueStr.equals("root")) {
                return 1;
            }
            if (attributeValueStr.equals("parent")) {
                return 2;
            }
            if (attributeValueStr.equals("self")) {
                return 3;
            }
            logger.error("fr.gael.drb.impl.sdf.Descriptor.parseContext() : Unknown origin attribute value (" + attributeValueStr + ").");
            return -1;
        }
        catch (ClassCastException e) {
            logger.error("fr.gael.drb.impl.sdf.Descriptor.parseContext() : Error while extracting origin attribute value (" + attributeValue + ").");
            logger.error("   " + e);
            return -1;
        }
    }

    private static short parseOrigin(DrbAttribute attribute) {
        logger.debug("parseOrigin()");
        Value attributeValue = null;
        try {
            attributeValue = attribute.getValue();
            if (attributeValue == null) {
                logger.error("fr.gael.drb.impl.sdf.Descriptor.parseOrigin() : Unit attribute value is null.");
                return -1;
            }
            String attributeValueStr = attributeValue.toString();
            if (attributeValueStr.equals("root")) {
                return 1;
            }
            if (attributeValueStr.equals("parent")) {
                return 2;
            }
            if (attributeValueStr.equals("previous")) {
                return 3;
            }
            logger.error("fr.gael.drb.impl.sdf.Descriptor.parseOrigin() : Unknown origin attribute value (" + attributeValueStr + ").");
            return -1;
        }
        catch (ClassCastException e) {
            logger.error("fr.gael.drb.impl.sdf.Descriptor.parseOrigin() : Error while extracting origin attribute value (" + attributeValue + ").");
            logger.error("   " + e);
            return -1;
        }
    }

    private Descriptor.Signature parseSignature(Descriptor descriptor, DrbNode node) {
        logger.debug("parseSignature()");
        Value nodeValue = node.getValue();
        if (nodeValue != null) {
            return new Descriptor.Signature(nodeValue.toString());
        }
        DrbAttribute query_attrib = node.getAttribute("query");
        if (query_attrib != null) {
            return new Descriptor.Signature(query_attrib.getValue().toString());
        }
        DrbAttribute value_attrib = node.getAttribute("value");
        if (value_attrib != null && value_attrib.getValue() != null) {
            Value target_value = value_attrib.getValue().convertTo(descriptor.valueType);
            return new Descriptor.Signature(target_value);
        }
        return null;
    }

    private String parseValue(DrbNode node) {
        logger.debug("parseValue()");
        Value nodeValue = node.getValue();
        if (nodeValue != null) {
            return nodeValue.toString();
        }
        return null;
    }

    private PhysicalAttribute parseNodeName(DrbNode node) throws StaticException {
        logger.debug("parseNodeName()");
        PhysicalAttribute nodeName = new PhysicalAttribute(3);
        boolean nameQueryDefined = false;
        int nbAttribute = 0;
        DrbAttributeList attributeList = node.getAttributes();
        nameQueryDefined = false;
        if (attributeList != null && (nbAttribute = attributeList.getLength()) > 0) {
            for (int j = 0; j < nbAttribute; ++j) {
                DrbAttribute attribute = attributeList.item(j);
                Value attributeValue = null;
                if ("context".equals(attribute.getName())) {
                    short query_context = SdfFactory.parseContext(attribute);
                    nodeName.setQueryContext(query_context);
                    continue;
                }
                if ("query".equals(attribute.getName())) {
                    try {
                        attributeValue = attribute.getValue();
                        if (attributeValue == null) {
                            logger.error("fr.gael.drb.impl.sds.Descriptor.parseNodeName() : Name query attribute value is null.");
                            throw new StaticException("Name query attribute value is null.");
                        }
                        String nameQuery = attributeValue.toString();
                        nodeName.setQuery(nameQuery);
                        nodeName.setAccessType(3);
                        nameQueryDefined = true;
                        continue;
                    }
                    catch (ClassCastException e) {
                        logger.error("fr.gael.drb.impl.sdf.Descriptor.parseNodeName() : Error while extracting name query attribute value (" + attributeValue + ").");
                        logger.error("   " + e);
                        throw new StaticException("Error while extracting name query attribute.");
                    }
                }
                if ("constant".equals(attribute.getName())) {
                    try {
                        attributeValue = attribute.getValue();
                        if (attributeValue == null) {
                            logger.error("fr.gael.drb.impl.sdf.Descriptor.parseNodeName():Name 'constant' attribute value is null.");
                            throw new StaticException("Name 'constant' attribute value is null.");
                        }
                        if (attributeValue.toString().equals("false")) {
                            nodeName.setOccurrenceType(3);
                            continue;
                        }
                        if (attributeValue.toString().equals("true")) {
                            nodeName.setOccurrenceType(1);
                            continue;
                        }
                        logger.error("fr.gael.drb.impl.sdf.Descriptor.parseNodeName():Name 'constant' attribute value is invalid. value='" + attributeValue.toString() + "'");
                        throw new StaticException("Name 'constant' attribute value is invalid.");
                    }
                    catch (ClassCastException e) {
                        String msg_error = "fr.gael.drb.impl.sdf.Descriptor.parseNodeName() : Error while extracting name 'constant'  attribute value (" + attributeValue + ").";
                        logger.error(msg_error);
                        logger.error("   " + e);
                        throw new StaticException(msg_error);
                    }
                }
                logger.error("fr.gael.drb.impl.sdf.Descriptor.parseNodeName() : Unknown nodeName attribute (" + attribute.getName() + ").");
                throw new StaticException("Unknown nodeName attribute (" + attribute.getName() + ").");
            }
        }
        return nodeName;
    }

    private LengthAttribute parseLength(DrbNode node) throws StaticException {
        logger.debug("parseLength()");
        LengthAttribute length = new LengthAttribute(3);
        int nbAttribute = 0;
        DrbAttributeList attributeList = node.getAttributes();
        length.setUnit((short)2);
        boolean lengthQueryDefined = false;
        if (attributeList != null && (nbAttribute = attributeList.getLength()) > 0) {
            for (int j = 0; j < nbAttribute; ++j) {
                DrbAttribute attribute = attributeList.item(j);
                Value attributeValue = null;
                if (attribute.getName().equals("unit")) {
                    short unit = SdfFactory.parseUnit(attribute);
                    length.setUnit(unit);
                    continue;
                }
                if (attribute.getName().equals("context")) {
                    short query_context = SdfFactory.parseContext(attribute);
                    length.setQueryContext(query_context);
                    continue;
                }
                if (attribute.getName().equals("query")) {
                    try {
                        attributeValue = attribute.getValue();
                        if (attributeValue == null) {
                            logger.error("fr.gael.drb.impl.sdf.Descriptor.parseLength() : Length query attribute value is null.");
                            throw new StaticException("Length query attribute value is null.");
                        }
                        String lengthQuery = attributeValue.toString();
                        length.setQuery(lengthQuery);
                        length.setAccessType(3);
                        lengthQueryDefined = true;
                        continue;
                    }
                    catch (ClassCastException e) {
                        logger.error("fr.gael.drb.impl.sdf.Descriptor.parseLength() : Error while extracting length query attribute value (" + attributeValue + ").");
                        logger.error("   " + e);
                        throw new StaticException("Error while extracting length query attribute.");
                    }
                }
                if (attribute.getName().equals("constant")) {
                    try {
                        attributeValue = attribute.getValue();
                        if (attributeValue == null) {
                            logger.error("fr.gael.drb.impl.sdf.Descriptor.parseLength():Length constant attribute value is null.");
                            throw new StaticException("Length constant attribute value is null.");
                        }
                        if (attributeValue.toString().equals("false")) {
                            length.setOccurrenceType(3);
                            continue;
                        }
                        if (attributeValue.toString().equals("true")) {
                            length.setOccurrenceType(1);
                            continue;
                        }
                        logger.error("fr.gael.drb.impl.sdf.Descriptor.parseLength():Length constant attribute value is invalid. value='" + attributeValue.toString() + "'");
                        throw new StaticException("Length constant attribute value is invalid.");
                    }
                    catch (ClassCastException e) {
                        logger.error("fr.gael.drb.impl.sdf.Descriptor.parseLength() : Error while extracting length constant  attribute value (" + attributeValue + ").");
                        logger.error("   " + e);
                        throw new StaticException("Error while extracting length constant  attribute value (" + attributeValue + ").");
                    }
                }
                logger.error("fr.gael.drb.impl.sdf.Descriptor.parseLength() : Unknown length attribute (" + attribute.getName() + ").");
                throw new StaticException("Unknown length attribute (" + attribute.getName() + ").");
            }
        }
        if (!lengthQueryDefined) {
            Value nodeValue = null;
            try {
                nodeValue = node.getValue();
                if (nodeValue == null) {
                    logger.error("fr.gael.drb.impl.sdf.Descriptor.parseLength() : Length value is null.");
                    throw new StaticException("Length value is null.");
                }
                if (nodeValue.toString().equals("unbounded")) {
                    length.setAccessType(3);
                } else {
                    String node_string = nodeValue.toString().trim();
                    long valueLength = Long.parseLong(node_string);
                    length.setAccessType(1);
                    length.setOccurrenceType(1);
                    switch (length.getUnit()) {
                        case 1: {
                            length.setLength(null, new Length(0L, valueLength));
                            break;
                        }
                        case 2: {
                            length.setLength(null, new Length(valueLength));
                        }
                    }
                }
            }
            catch (ClassCastException e) {
                logger.error("fr.gael.drb.impl.sdf.Descriptor.parseLength() : Error while extracting length value (" + nodeValue + ").");
                logger.error("   " + e);
                throw new StaticException("Error while extracting length value.");
            }
        }
        length.setSpecified(true);
        return length;
    }

    private int parseEncoding(DrbNode node) throws StaticException {
        logger.debug("parseEncoding()");
        Value nodeValue = null;
        nodeValue = node.getValue();
        if (nodeValue == null) {
            logger.error("Encoding value is null.");
            throw new StaticException("Encoding value is null.");
        }
        String tmpString = nodeValue.toString().toUpperCase();
        if (tmpString.equals("BINARY")) {
            return 1;
        }
        return 2;
    }

    private String parseCharset(DrbNode node) throws StaticException {
        logger.debug("parseCharset)");
        Value nodeValue = null;
        nodeValue = node.getValue();
        if (nodeValue == null) {
            logger.error("Charset name is null.");
            throw new StaticException("Charset name is null.");
        }
        String tmpString = nodeValue.toString().toUpperCase();
        if (tmpString.equals("ASCII")) {
            return "ASCII";
        }
        if (tmpString.equals("EBCDIC")) {
            return "cp037";
        }
        if (tmpString.equals("US-ASCII")) {
            return "US-ASCII";
        }
        if (Charset.isSupported(tmpString)) {
            return tmpString;
        }
        logger.error("Unknown charset name (" + tmpString + ").");
        throw new StaticException("Unknown encoding value (" + tmpString + ").");
    }

    private int parseByteOrder(DrbNode node) throws StaticException {
        logger.debug("parseByteOrder()");
        Value nodeValue = null;
        nodeValue = node.getValue();
        if (nodeValue == null) {
            logger.error("fr.gael.drb.impl.sdf.Descriptor.parseByteOrder() : Byte Order value is null.");
            throw new StaticException("Byte Order value is null.");
        }
        String tmpString = nodeValue.toString();
        if (tmpString.equals("LSB")) {
            return 1;
        }
        if (tmpString.equals("MSB")) {
            return 2;
        }
        logger.error("fr.gael.drb.impl.sdf.Descriptor.parseByteOrder() : Unknown byte order value (" + tmpString + ").");
        throw new StaticException("Unknown byte order value (" + tmpString + ").");
    }

    private String parseDelimiter(DrbNode node) {
        DrbAttribute value_attrib;
        logger.debug("parseDelimiter()");
        String tmpString = null;
        Value nodeValue = null;
        Value codeValue = null;
        nodeValue = node.getValue();
        if (nodeValue == null && (value_attrib = node.getAttribute("value")) != null) {
            nodeValue = value_attrib.getValue();
        }
        if (nodeValue == null) {
            value_attrib = node.getAttribute("code");
            if (value_attrib != null) {
                codeValue = value_attrib.getValue();
            }
            if (codeValue != null) {
                String code_string = Character.toString((char)Integer.parseInt(codeValue.toString()));
                nodeValue = new fr.gael.drb.value.String(code_string);
            }
        }
        if (nodeValue != null) {
            tmpString = nodeValue.toString();
        }
        if (tmpString == null) {
            logger.debug("fr.gael.drb.impl.sdf.Descriptor.parseDelimiter() : delimiter value is null.('10)");
            return "\n";
        }
        return tmpString;
    }

    private void parseBlock(Descriptor descriptor, DrbNode node) {
        logger.debug("parseBlock()");
        Value attributeValue = null;
        int nbAttribute = 0;
        DrbAttributeList attributeList = node.getAttributes();
        if (attributeList != null && (nbAttribute = attributeList.getLength()) > 0) {
            for (int j = 0; j < nbAttribute; ++j) {
                DrbAttribute attribute = attributeList.item(j);
                if (attribute.getName().equals("query")) {
                    try {
                        attributeValue = attribute.getValue();
                        if (attributeValue == null) {
                            logger.error("fr.gael.drb.impl.sdf.Descriptor.parseLength() : Length query attribute value is null.");
                            return;
                        }
                        descriptor.fileNodePath = attributeValue.toString();
                        continue;
                    }
                    catch (ClassCastException e) {
                        logger.error("fr.gael.drb.impl.sdf.Descriptor.parseLength() : Error while extracting length query attribute value (" + attributeValue + ").");
                        logger.error("   " + e);
                        throw new StaticException("Error while extracting length query attribute value (" + attributeValue + ").");
                    }
                }
                logger.error("fr.gael.drb.impl.sdf.Descriptor.parseBlock() : Unknown attribute (" + attribute.getName() + ").");
                return;
            }
        }
        for (int i = 0; i < node.getChildrenCount(); ++i) {
            DrbNode nodeChild = node.getChildAt(i);
            String nodeName = nodeChild.getName();
            if ("occurrence".equals(nodeName)) {
                descriptor.occurrenceCount = this.parseOccurrence(nodeChild);
                continue;
            }
            if ("length".equals(nodeName)) {
                descriptor.contentLength = this.parseLength(nodeChild);
                continue;
            }
            if ("offset".equals(nodeName)) {
                descriptor.blockOffset = SdfFactory.parseOffset(nodeChild);
                continue;
            }
            if ("padding".equals(nodeName)) {
                this.parsePadding(descriptor, nodeChild);
                continue;
            }
            if ("encoding".equals(nodeName)) {
                descriptor.encoding = this.parseEncoding(nodeChild);
                if (descriptor.encoding != 2) continue;
                descriptor.charsetName = this.parseCharset(nodeChild);
                continue;
            }
            if ("numericFormat".equals(nodeName)) {
                descriptor.textFormat = this.parseNumericFormat(nodeChild);
                continue;
            }
            if ("dateFormat".equals(nodeName)) {
                descriptor.textFormat = this.parseDateFormat(nodeChild);
                continue;
            }
            if ("byteOrder".equals(nodeName)) {
                descriptor.byteOrdering = this.parseByteOrder(nodeChild);
                continue;
            }
            if ("delimiter".equals(nodeName)) {
                descriptor.delimiter = this.parseDelimiter(nodeChild);
                continue;
            }
            if ("signature".equals(nodeName)) {
                descriptor.signature = this.parseSignature(descriptor, nodeChild);
                continue;
            }
            if ("value".equals(nodeName)) {
                descriptor.valueQuery = this.parseValue(nodeChild);
                continue;
            }
            if ("array".equals(nodeName)) {
                this.parseArray(descriptor, nodeChild);
                continue;
            }
            if ("nodeName".equals(nodeName)) {
                descriptor.blockName = this.parseNodeName(nodeChild);
                continue;
            }
            logger.warn("fr.gael.drb.impl.sdf.Descriptor.parseBlock() : Unknown element \"" + nodeName + "\", ignored.");
        }
    }

    private void parseArrayBlock(Descriptor descriptor, DrbNode node) {
        logger.debug("parseArrayBlock()");
        for (int i = 0; i < node.getChildrenCount(); ++i) {
            DrbNode nodeChild = node.getChildAt(i);
            String nodeName = nodeChild.getName();
            if ("encoding".equals(nodeName)) {
                descriptor.encoding = this.parseEncoding(nodeChild);
                if (descriptor.encoding != 2) continue;
                descriptor.charsetName = this.parseCharset(nodeChild);
                continue;
            }
            if ("numericFormat".equals(nodeName)) {
                descriptor.textFormat = this.parseNumericFormat(nodeChild);
                continue;
            }
            if ("dateFormat".equals(nodeName)) {
                descriptor.textFormat = this.parseDateFormat(nodeChild);
                continue;
            }
            if ("byteOrder".equals(nodeName)) {
                descriptor.byteOrdering = this.parseByteOrder(nodeChild);
                continue;
            }
            if ("occurrence".equals(nodeName)) {
                descriptor.itemCount = this.parseOccurrence(nodeChild);
                continue;
            }
            if ("length".equals(nodeName)) {
                descriptor.itemLength = this.parseLength(nodeChild);
                continue;
            }
            if ("delimiter".equals(nodeName)) {
                descriptor.arrayDelimiter = this.parseDelimiter(nodeChild);
                continue;
            }
            logger.warn("fr.gael.drb.impl.sdf.Descriptor.parseArrayBlock() : Unknown element \"" + nodeName + "\", ignored.");
        }
    }

    private void parseArray(Descriptor descriptor, DrbNode node) {
        logger.debug("parseArray()");
        for (int i = 0; i < node.getChildrenCount(); ++i) {
            DrbNode nodeChild = node.getChildAt(i);
            String nodeName = nodeChild.getName();
            if ("occurrence".equals(nodeName)) {
                descriptor.itemCount = this.parseOccurrence(nodeChild);
                continue;
            }
            if ("length".equals(nodeName)) {
                descriptor.itemLength = this.parseLength(nodeChild);
                continue;
            }
            if ("delimiter".equals(nodeName)) {
                descriptor.arrayDelimiter = this.parseDelimiter(nodeChild);
                continue;
            }
            logger.warn("fr.gael.drb.impl.sdf.Descriptor.parseArray() : Unknown element \"" + nodeName + "\", ignored.");
        }
    }

    private NumericFormat parseNumericFormat(DrbNode node) {
        logger.debug("parseNumericFormat()");
        Value attributeValue = null;
        NumericFormat format = new NumericFormat();
        int nbAttribute = 0;
        DrbAttributeList attributeList = node.getAttributes();
        if (attributeList != null && (nbAttribute = attributeList.getLength()) > 0) {
            for (int j = 0; j < nbAttribute; ++j) {
                DrbAttribute attribute = attributeList.item(j);
                if (attribute.getName().equals("pattern")) {
                    try {
                        attributeValue = attribute.getValue();
                        if (attributeValue == null) {
                            logger.error("fr.gael.drb.impl.sdf.Descriptor.parseNumericFormat() : Pattern attribute value is null.");
                            throw new StaticException("fr.gael.drb.impl.sdf.Descriptor.parseNumericFormat() : Pattern attribute value is null.");
                        }
                        String pattern = attributeValue.toString();
                        if (pattern.startsWith("+") && pattern.indexOf(";") < 0) {
                            String positive_pattern = pattern;
                            String negative_pattern = "-" + positive_pattern.substring(1);
                            pattern = positive_pattern + ";" + negative_pattern;
                        }
                        format = new NumericFormat(attributeValue.toString());
                        continue;
                    }
                    catch (ClassCastException e) {
                        logger.error("fr.gael.drb.impl.sdf.Descriptor.parseNumericFormat() : Error while extracting pattern attribute value (" + attributeValue + ").");
                        logger.error("   " + e);
                        throw new StaticException("Error while extracting pattern attribute value (" + attributeValue + ").");
                    }
                }
                logger.error("fr.gael.drb.impl.sdf.Descriptor.parseNumericFormat() : Unknown attribute (" + attribute.getName() + ").");
            }
        }
        for (int i = 0; i < node.getChildrenCount(); ++i) {
            int val;
            String node_string;
            Value max;
            Value min;
            DrbNode nodeChild = node.getChildAt(i);
            String nodeName = nodeChild.getName();
            if ("integerDigits".equals(nodeName)) {
                if (nodeChild.getAttribute("min") != null) {
                    min = nodeChild.getAttribute("min").getValue();
                    format.setMinimumIntegerDigits(((Numeric)min.convertTo(9)).intValue());
                }
                if (nodeChild.getAttribute("max") != null) {
                    max = nodeChild.getAttribute("max").getValue();
                    format.setMaximumIntegerDigits(((Numeric)max.convertTo(9)).intValue());
                }
                if (nodeChild.getValue() == null) continue;
                node_string = nodeChild.getValue().toString().trim();
                val = Integer.parseInt(node_string);
                format.setMinimumIntegerDigits(val);
                format.setMaximumIntegerDigits(val);
                continue;
            }
            if ("fractionDigits".equals(nodeName)) {
                if (nodeChild.getAttribute("min") != null) {
                    min = nodeChild.getAttribute("min").getValue();
                    format.setMinimumFractionDigits(((Numeric)min.convertTo(9)).intValue());
                }
                if (nodeChild.getAttribute("max") != null) {
                    max = nodeChild.getAttribute("max").getValue();
                    format.setMaximumFractionDigits(((Numeric)max.convertTo(9)).intValue());
                }
                if (nodeChild.getValue() == null) continue;
                node_string = nodeChild.getValue().toString().trim();
                val = Integer.parseInt(node_string);
                format.setMinimumFractionDigits(val);
                format.setMaximumFractionDigits(val);
                continue;
            }
            logger.warn("fr.gael.drb.impl.sdf.Descriptor.parseNumericFormat() : Unknown element \"" + nodeName + "\", ignored.");
        }
        return format;
    }

    private DateTimeFormat parseDateFormat(DrbNode node) {
        logger.debug("parseDateTimeFormat()");
        Value attributeValue = null;
        DateTimeFormat format = new DateTimeFormat();
        int nbAttribute = 0;
        DrbAttributeList attributeList = node.getAttributes();
        if (attributeList != null && (nbAttribute = attributeList.getLength()) > 0) {
            for (int j = 0; j < nbAttribute; ++j) {
                DrbAttribute attribute = attributeList.item(j);
                if (attribute.getName().equals("pattern")) {
                    try {
                        attributeValue = attribute.getValue();
                        if (attributeValue == null) {
                            logger.error("fr.gael.drb.impl.sdf.Descriptor.parseDateFormat() : Pattern attribute value is null.");
                            throw new StaticException("fr.gael.drb.impl.sdf.Descriptor.parseDateFormat() : Pattern attribute value is null.");
                        }
                        format = new DateTimeFormat(attributeValue.toString());
                        continue;
                    }
                    catch (ClassCastException e) {
                        logger.error("fr.gael.drb.impl.sdf.Descriptor.parseDateFormat() : Error while extracting pattern attribute value (" + attributeValue + ").");
                        logger.error("   " + e);
                        throw new StaticException("Error while extracting pattern attribute value (" + attributeValue + ").");
                    }
                }
                logger.error("fr.gael.drb.impl.sdf.Descriptor.parseDateFormat() : Unknown attribute (" + attribute.getName() + ").");
            }
        }
        return format;
    }

    private PhysicalAttribute parseOccurrence(DrbNode node) throws StaticException {
        logger.debug("parseOccurrence()");
        PhysicalAttribute occurrenceCount = new PhysicalAttribute(1);
        Value nodeValue = null;
        Value attributeValue = null;
        String occurrenceCountQuery = null;
        boolean occurrenceCountQueryConstant = true;
        int nbAttribute = 0;
        DrbAttributeList attributeList = node.getAttributes();
        if (attributeList != null && (nbAttribute = attributeList.getLength()) > 0) {
            for (int j = 0; j < nbAttribute; ++j) {
                DrbAttribute attribute = attributeList.item(j);
                if (attribute.getName().equals("query")) {
                    try {
                        attributeValue = attribute.getValue();
                        if (attributeValue == null) {
                            logger.error("fr.gael.drb.impl.sdf.Descriptor.parseOccurrence() : Occurrence query attribute value is null.");
                            throw new StaticException("Occurrence query attribute value is null.");
                        }
                        occurrenceCountQuery = attributeValue.toString();
                        logger.debug("   occurrenceCountQuery=[" + occurrenceCountQuery + "]");
                        occurrenceCount.setQuery(occurrenceCountQuery);
                        occurrenceCount.setAccessType(3);
                        continue;
                    }
                    catch (ClassCastException e) {
                        logger.error("fr.gael.drb.impl.sdf.Descriptor.parseOccurrence() : Error while extracting occurrence query attribute value (" + attributeValue + ").");
                        logger.error("   " + e);
                        throw new StaticException("Occurrence query attribute value is null.");
                    }
                }
                if (attribute.getName().equals("context")) {
                    short query_context = SdfFactory.parseContext(attribute);
                    occurrenceCount.setQueryContext(query_context);
                    continue;
                }
                if (attribute.getName().equals("constant")) {
                    try {
                        attributeValue = attribute.getValue();
                        if (attributeValue == null) {
                            logger.error("fr.gael.drb.impl.sdf.Descriptor.parseOccurrence():Occurrence constant attribute value is null.");
                            throw new StaticException("Occurrence constant attribute value is null.");
                        }
                        if (attributeValue.toString().equals("false")) {
                            occurrenceCountQueryConstant = false;
                            continue;
                        }
                        occurrenceCountQueryConstant = true;
                        continue;
                    }
                    catch (ClassCastException e) {
                        logger.error("fr.gael.drb.impl.sdf.Descriptor.parseOccurrence() : Error while extracting occurrence constant  attribute value (" + attributeValue + ").");
                        logger.error("   " + e);
                        throw new StaticException("Error while extracting occurrence constant  attribute value (" + attributeValue + ").");
                    }
                }
                if (attribute.getName().equals("parent")) {
                    logger.warn("fr.gael.drb.impl.sdf.Descriptor.parseOccurrence():Occurrence parent attribute is deprecated.");
                    continue;
                }
                logger.error("fr.gael.drb.impl.sdf.Descriptor.parseOccurrence() : Unknown occurrence attribute name (" + attribute.getName() + ").");
                throw new StaticException("Unknown occurrence attribute name (" + attribute.getName() + ").");
            }
            if (occurrenceCountQueryConstant) {
                occurrenceCount.setOccurrenceType(1);
            } else {
                occurrenceCount.setOccurrenceType(3);
            }
        } else {
            try {
                nodeValue = node.getValue();
                if (nodeValue == null) {
                    logger.error("fr.gael.drb.impl.sdf.Descriptor.parseOccurrence() : Occurrence value is null.");
                    throw new StaticException("Occurrence value is null.");
                }
                String node_string = nodeValue.toString().trim();
                if (node_string.equals("unbounded")) {
                    int occurrence = -1;
                    occurrenceCount.setAccessType(3);
                    occurrenceCount.setOccurrenceType(3);
                }
                int occurrence = Integer.parseInt(node_string);
                occurrenceCount.setAccessType(1);
                occurrenceCount.setOccurrenceType(1);
                occurrenceCount.setValue(occurrence);
            }
            catch (ClassCastException e) {
                logger.error("fr.gael.drb.impl.sdf.Descriptor.parseOccurrence() : Error while extracting occurrence value (" + nodeValue + ").");
                logger.error("   " + e);
                throw new StaticException("fr.gael.drb.impl.sdf.Descriptor.parseOccurrence() : Error while extracting occurrence value (" + nodeValue + ").");
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("   query=" + (occurrenceCountQuery != null) + ", constant=" + occurrenceCountQueryConstant + ", occurrence=" + occurrenceCount);
        }
        occurrenceCount.setSpecified(true);
        return occurrenceCount;
    }

    private PhysicalAttribute parseOccurrence(XsdParticle particle) throws StaticException {
        logger.debug("parseOccurrence()");
        PhysicalAttribute occurrenceCount = new PhysicalAttribute(1);
        if (particle.getMinOccurs() == particle.getMaxOccurs()) {
            occurrenceCount.setOccurrenceType(1);
            occurrenceCount.setValue(particle.getMinOccurs());
        } else {
            occurrenceCount.setAccessType(3);
        }
        return occurrenceCount;
    }

    private PhysicalAttribute parseOccurrence(XsdListType list_type) throws StaticException {
        logger.debug("parseOccurrence()");
        PhysicalAttribute occurrenceCount = new PhysicalAttribute(1);
        Value list_length = null;
        XsdFacet[] list_facets = list_type.getFacets();
        if (list_facets != null) {
            for (int i = 0; i < list_facets.length; ++i) {
                if (!(list_facets[i] instanceof XsdLengthFacet)) continue;
                list_length = list_facets[i].getValue();
            }
        }
        if (list_length != null) {
            occurrenceCount.setOccurrenceType(1);
            occurrenceCount.setValue(((Numeric)list_length).longValue());
        } else {
            occurrenceCount.setAccessType(3);
        }
        return occurrenceCount;
    }

    private void parsePadding(Descriptor descriptor, DrbNode node) {
        logger.debug("parsePadding()");
        Value nodeValue = null;
        Value attributeValue = null;
        String content = "";
        boolean innerType = false;
        boolean leftType = false;
        int nbAttribute = 0;
        DrbAttributeList attributeList = node.getAttributes();
        if (attributeList == null || (nbAttribute = attributeList.getLength()) == 0) {
            logger.error("fr.gael.drb.impl.sdf.Descriptor.parsePadding() : Missing padding attribute.");
            return;
        }
        for (int j = 0; j < nbAttribute; ++j) {
            DrbAttribute attribute = attributeList.item(j);
            if (attribute.getName().equals("type")) {
                try {
                    attributeValue = attribute.getValue();
                    if (attributeValue == null) {
                        logger.error("fr.gael.drb.impl.sdf.Descriptor.parsePadding() : Padding type attribute value is null.");
                        return;
                    }
                    nodeValue = node.getValue();
                    if (nodeValue == null) {
                        logger.error("fr.gael.drb.impl.sdf.Descriptor.parsePadding() : Padding value is null.");
                        return;
                    }
                    String node_string = node.getValue().toString().trim();
                    int padding = Integer.parseInt(node_string);
                    if (attributeValue.toString().equals("header")) {
                        innerType = false;
                        leftType = true;
                        descriptor.headerPadding.length += padding;
                        continue;
                    }
                    if (attributeValue.toString().equals("footer")) {
                        innerType = false;
                        leftType = false;
                        descriptor.footerPadding.length += padding;
                        continue;
                    }
                    if (attributeValue.toString().equals("leading")) {
                        innerType = true;
                        leftType = true;
                        descriptor.leading.length += padding;
                        continue;
                    }
                    if (attributeValue.toString().equals("trailing")) {
                        innerType = true;
                        leftType = false;
                        descriptor.trailing.length += padding;
                        continue;
                    }
                    logger.error("fr.gael.drb.impl.sdf.Descriptor.parsePadding() : Unknown padding attribute value (" + attributeValue + ").");
                    return;
                }
                catch (ClassCastException e) {
                    logger.error("fr.gael.drb.impl.sdf.Descriptor.parsePadding() : Error while extracting padding value (" + nodeValue + ").");
                    logger.error("   " + e);
                    return;
                }
            }
            if ("content".equals(attribute.getName())) {
                try {
                    attributeValue = attribute.getValue();
                    if (attributeValue == null) {
                        logger.error("fr.gael.drb.impl.sdf.Descriptor.parsePadding() : Padding content attribute value is null.");
                        return;
                    }
                    content = attributeValue.toString();
                    continue;
                }
                catch (ClassCastException e) {
                    logger.error("fr.gael.drb.impl.sdf.Descriptor.parsePadding() : Error while extracting padding content value (" + nodeValue + ").");
                    logger.error("   " + e);
                    return;
                }
            }
            if (attribute.getName().equals("code")) {
                try {
                    attributeValue = attribute.getValue();
                    if (attributeValue == null) {
                        logger.error("fr.gael.drb.impl.sdf.Descriptor.parsePadding() : Padding content attribute value is null.");
                        return;
                    }
                    content = Character.toString((char)Integer.parseInt(attributeValue.toString()));
                    continue;
                }
                catch (ClassCastException e) {
                    logger.error("fr.gael.drb.impl.sdf.Descriptor.parsePadding() : Error while extracting padding code value (" + nodeValue + ").");
                    logger.error("   " + e);
                    return;
                }
            }
            logger.error("fr.gael.drb.impl.sdf.Descriptor.parsePadding() : Unknown padding attribute name (" + attribute.getName() + ").");
            return;
        }
        if (innerType) {
            if (leftType) {
                descriptor.leading.content = content;
            } else {
                descriptor.trailing.content = content;
            }
        } else if (leftType) {
            descriptor.headerPadding.content = content;
        } else {
            descriptor.footerPadding.content = content;
        }
    }

    private void parseAnnotation(Descriptor descriptor, DrbNode node) {
        logger.debug("parseAnnotation()");
        for (int i = 0; i < node.getChildrenCount(); ++i) {
            DrbNode nodeChild = node.getChildAt(i);
            if (!"documentation".equals(nodeChild.getName())) continue;
            descriptor.documentation = this.parseDocumentation(nodeChild);
        }
    }

    private String parseDocumentation(DrbNode node) {
        logger.debug("parseDocumentation()");
        Value nodeValue = null;
        try {
            nodeValue = node.getValue();
            if (nodeValue != null) {
                return nodeValue.toString();
            }
        }
        catch (ClassCastException e) {
            logger.error("fr.gael.drb.impl.sdf.Descriptor.parseDocumentation() : Error while extracting documentation value (" + nodeValue + ").");
            logger.error("   " + e);
            throw new StaticException("fr.gael.drb.impl.sdf.Descriptor.parseDocumentation() : Error while extracting documentation value (" + nodeValue + ").");
        }
        return null;
    }

    private void parseView(Descriptor descriptor, DrbNodeList nodes) {
        logger.debug("parseView()");
        if (nodes == null) {
            return;
        }
        try {
            for (int i = 0; i < nodes.getLength(); ++i) {
                if (!"view".equals(nodes.getItem(i).getName())) continue;
                logger.debug("ParseView " + descriptor.getName());
                descriptor.viewDesc = new SdfViewDescriptor(descriptor.getSchema());
            }
        }
        catch (ClassCastException e) {
            logger.error("fr.gael.drb.impl.sdf.Descriptor.parseView() : Error while parsing view description ().");
            logger.error("   " + e);
            throw new StaticException("fr.gael.drb.impl.sdf.Descriptor.parseView() : Error while parsing view description ().");
        }
    }

    private static OffsetAttribute parseOffset(DrbNode node) {
        logger.debug("parseOffset()");
        OffsetAttribute block_offset = new OffsetAttribute(3);
        block_offset.setSpecified(true);
        Value nodeValue = null;
        Value attributeValue = null;
        String lengthQuery = null;
        short offset_origin = 3;
        int nbAttribute = 0;
        DrbAttributeList attributeList = node.getAttributes();
        block_offset.setUnit((short)2);
        boolean lengthQueryDefined = false;
        if (attributeList != null && (nbAttribute = attributeList.getLength()) > 0) {
            for (int j = 0; j < nbAttribute; ++j) {
                DrbAttribute attribute = attributeList.item(j);
                if (attribute.getName().equals("origin")) {
                    offset_origin = SdfFactory.parseOrigin(attribute);
                    continue;
                }
                if (attribute.getName().equals("unit")) {
                    short unit = SdfFactory.parseUnit(attribute);
                    block_offset.setUnit(unit);
                    continue;
                }
                if (attribute.getName().equals("context")) {
                    short query_context = SdfFactory.parseContext(attribute);
                    block_offset.setQueryContext(query_context);
                    continue;
                }
                if (attribute.getName().equals("query")) {
                    try {
                        attributeValue = attribute.getValue();
                        if (attributeValue == null) {
                            logger.error("fr.gael.drb.impl.sdf.Descriptor.parseOffset() : Length query attribute value is null.");
                            return null;
                        }
                        lengthQuery = attributeValue.toString();
                        lengthQueryDefined = true;
                        continue;
                    }
                    catch (ClassCastException e) {
                        logger.error("fr.gael.drb.impl.sdf.Descriptor.parseOffset() : Error while extracting length query attribute value (" + attributeValue + ").");
                        logger.error("   " + e);
                        throw new StaticException("fr.gael.drb.impl.sdf.Descriptor.parseOffset() : Error while extracting length query attribute value (" + attributeValue + ").");
                    }
                }
                if (attribute.getName().equals("constant")) {
                    try {
                        attributeValue = attribute.getValue();
                        if (attributeValue == null) {
                            logger.error("fr.gael.drb.impl.sdf.Descriptor.parseOffset():Offset constant attribute value is null.");
                            throw new StaticException("Offset constant attribute value is null.");
                        }
                        if (attributeValue.toString().equals("false")) {
                            block_offset.setOccurrenceType(3);
                            continue;
                        }
                        if (attributeValue.toString().equals("true")) {
                            block_offset.setOccurrenceType(1);
                            continue;
                        }
                        logger.error("fr.gael.drb.impl.sdf.Descriptor.parseOffset():Offset constant attribute value is invalid. value='" + attributeValue.toString() + "'");
                        throw new StaticException("Offset constant attribute value is invalid.");
                    }
                    catch (ClassCastException e) {
                        logger.error("fr.gael.drb.impl.sdf.Descriptor.parseOffset() : Error while extracting offset.constant  attribute value (" + attributeValue + ").");
                        logger.error("   " + e);
                        throw new StaticException("Error while extracting offset.constant  attribute value (" + attributeValue + ").");
                    }
                }
                logger.error("fr.gael.drb.impl.sdf.Descriptor.parseOffset() : Unknown length attribute (" + attribute.getName() + ").");
                throw new StaticException("fr.gael.drb.impl.sdf.Descriptor.parseOffset() : Unknown length attribute (" + attribute.getName() + ").");
            }
        }
        try {
            block_offset.setOrigin(offset_origin);
            if (lengthQueryDefined) {
                block_offset.setQuery(lengthQuery);
            } else {
                nodeValue = node.getValue();
                if (nodeValue == null) {
                    logger.error("fr.gael.drb.impl.sdf.Descriptor.parseOffset() : Offset value is null.");
                    throw new StaticException("Offset value is null.");
                }
                String node_string = node.getValue().toString().trim();
                long valueLength = Long.parseLong(node_string);
                block_offset.setAccessType(1);
                block_offset.setOccurrenceType(1);
                switch (block_offset.getUnit()) {
                    case 1: {
                        block_offset.setLength(null, new Length(0L, valueLength));
                        break;
                    }
                    case 2: {
                        block_offset.setLength(null, new Length(valueLength));
                    }
                }
            }
        }
        catch (ClassCastException e) {
            logger.error("fr.gael.drb.impl.sdf.Descriptor.parseOffset() : Error while extracting offset value (" + nodeValue + ").");
            logger.error("   " + e);
            throw new StaticException("fr.gael.drb.impl.sdf.Descriptor.parseOffset() : Error while extracting offset value (" + nodeValue + ").");
        }
        return block_offset;
    }

    private void parseExternalChildren(Descriptor descriptor, XsdElement node) {
        try {
            if (!this.defaultVersion.equals(SDF_2002_02_NAMESPACE)) {
                logger.debug(descriptor.getName() + ": Parse XS particle");
                descriptor.occurrenceCount = this.parseOccurrence(node);
            }
            logger.debug(descriptor.getName() + ": Parse array external children");
            XsdType node_type = node.getType();
            XsdSimpleType value_type = null;
            if (node_type != null) {
                value_type = node_type.getDatatype();
            }
            if (!this.defaultVersion.equals(SDF_2002_02_NAMESPACE) && value_type != null && value_type.getVariety() == 3) {
                descriptor.itemCount = this.parseOccurrence((XsdListType)value_type);
                this.parseArrayExternalChildren(descriptor, node.getName(), ((XsdListType)value_type).getItemType().getExternalNodes());
            }
            this.parseView(descriptor, node.getExternalNodes());
            if (descriptor.viewDesc != null) {
                logger.debug("Parse view/structure external children");
                if (descriptor.viewDesc.baseType != null) {
                    this.parseExternalChildren(descriptor, node.getName(), descriptor.viewDesc.baseType.getExternalNodes());
                }
            } else {
                logger.debug("Parse structure external children");
                this.parseExternalChildren(descriptor, node.getName(), node_type.getExternalNodes());
            }
            logger.debug("Parse node external children");
            this.parseExternalChildren(descriptor, node.getName(), node.getExternalNodes());
            if (descriptor.occurrenceCount.getValue() >= 0L && ((long)node.getMinOccurs() > descriptor.occurrenceCount.getValue() || (long)node.getMaxOccurs() < descriptor.occurrenceCount.getValue())) {
                logger.error("The occurrence of " + descriptor.getPath() + " is not consistent with the element definition.");
            }
        }
        catch (StaticException e) {
            throw new StaticException("Cannot parse definition for element '" + descriptor.getPath() + "' : " + e.getMessage());
        }
    }

    private void parseExternalChildren(Descriptor descriptor, String parsed_node_name, DrbNodeList external_children) {
        logger.debug("parseExternalChildren(" + parsed_node_name + ")");
        if (external_children == null) {
            return;
        }
        for (int i = 0; i < external_children.getLength(); ++i) {
            DrbNode nodeChild = external_children.item(i);
            String nodeName = nodeChild.getName();
            if (nodeName.equals("block")) {
                this.parseBlock(descriptor, nodeChild);
                if (SDF_2002_02_NAMESPACE.equals(nodeChild.getNamespaceURI())) {
                    if (descriptor.getType().getDatatype() == null || descriptor.occurrenceCount.getAccessType() != 3 && descriptor.occurrenceCount.getValue() <= 1L) continue;
                    int array_type = descriptor.valueType;
                    if (descriptor.valueType == 10) {
                        array_type = descriptor.arrayValueType;
                    } else {
                        logger.warn(descriptor.getPath() + " considered as array. Use the <array> definition within '" + AbstractBlock.SDF_NAMESPACE + "' namespace to avoid this warning.");
                    }
                    descriptor.arrayValueType = array_type;
                    descriptor.valueType = 10;
                    descriptor.itemCount = descriptor.occurrenceCount;
                    descriptor.itemLength = descriptor.contentLength;
                    descriptor.occurrenceCount = new PhysicalAttribute(1);
                    descriptor.occurrenceCount.setOccurrenceType(1);
                    descriptor.occurrenceCount.setValue(1L);
                    descriptor.contentLength = new LengthAttribute(3);
                    continue;
                }
                if (SDF_2004_12_NAMESPACE.equals(nodeChild.getNamespaceURI())) continue;
                if (SDF_2005_04_NAMESPACE.equals(nodeChild.getNamespaceURI()) || nodeChild.getNamespaceURI() == null) continue;
                logger.error(descriptor.getPath() + ": invalid SDF namespace(uri=" + nodeChild.getNamespaceURI() + ")");
                throw new StaticException(descriptor.getPath() + ": invalid SDF namespace(uri=" + nodeChild.getNamespaceURI() + ")");
            }
            if (!nodeName.equals("annotation")) continue;
            this.parseAnnotation(descriptor, nodeChild);
        }
    }

    private void parseArrayExternalChildren(Descriptor descriptor, String parsed_node_name, DrbNodeList external_children) {
        logger.debug("parseArrayExternalChildren(" + parsed_node_name + ")");
        if (external_children == null) {
            return;
        }
        for (int i = 0; i < external_children.getLength(); ++i) {
            DrbNode nodeChild = external_children.item(i);
            String nodeName = nodeChild.getName();
            if ("block".equals(nodeName)) {
                this.parseArrayBlock(descriptor, nodeChild);
                continue;
            }
            if (!"annotation".equals(nodeName)) continue;
            this.parseAnnotation(descriptor, nodeChild);
        }
    }

    public static void main(String[] args) {
        DrbNode base_node = DrbFactory.open(args[0]);
        DrbNode schema_node = DrbFactory.open(args[1]).getFirstChild();
        SdfFactory sdffactory = new SdfFactory();
        DrbNode node = sdffactory.open(base_node, schema_node, schema_node.getParent().getPath());
        System.err.println("node " + node.getName());
    }

    static {
        isEhCacheChecked = false;
    }
}

