/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.impl.sds;

import fr.gael.drb.DrbNode;
import fr.gael.drb.impl.sds.DefaultBlock;
import fr.gael.drb.impl.sds.Descriptor;
import fr.gael.drb.impl.sds.IntMap;
import java.io.IOException;
import org.apache.log4j.Logger;

class WriterBlock
extends DefaultBlock {
    private static Logger logger = Logger.getLogger(WriterBlock.class);
    private int[] descOccurrenceCount;

    protected WriterBlock(Descriptor descriptor, int[] key) {
        super(descriptor, key);
        this.descOccurrenceCount = new int[descriptor.getChildrenCount()];
        for (int i = 0; i < this.descOccurrenceCount.length; ++i) {
            this.descOccurrenceCount[i] = 0;
            if (descriptor.getChildAt(i).getOccurrenceCountType() == 1) continue;
        }
    }

    @Override
    public DrbNode appendChild(DrbNode node) throws NullPointerException, UnsupportedOperationException {
        if (node == null) {
            throw new NullPointerException("WriterBlock.appendChild(): The reference to the node to append is null.");
        }
        for (int i = 0; i < this.descriptor.getChildrenCount(); ++i) {
            Descriptor child_desc = this.descriptor.getChildAt(i);
            if (child_desc.isSame(node.getName())) {
                logger.debug("appendChild: occurs(" + node.getName() + ") = " + this.descOccurrenceCount[i]);
            }
            if (!child_desc.isSame(node.getName()) || (long)this.descOccurrenceCount[i] >= child_desc.getMaxOccurs()) continue;
            int n = i;
            this.descOccurrenceCount[n] = this.descOccurrenceCount[n] + 1;
            if (logger.isDebugEnabled()) {
                logger.debug("WriterBlock.appendChild: occurs(" + node.getName() + ") = " + this.descOccurrenceCount[i]);
            }
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("appendChild: replaced occurs " + this.descOccurrenceCount[i] + " by " + node.getName());
                }
                int[] child_key = IntMap.getChildKey(this.key, this.descOccurrenceCount[i] - 1);
                child_desc.create(node, child_key, false, 0);
                return new WriterBlock(child_desc, child_key);
            }
            catch (IOException e) {
                throw new UnsupportedOperationException(this.descriptor.getPath() + ": replaceChild failed due to an I/O error (" + e.getMessage() + ")");
            }
        }
        throw new UnsupportedOperationException(this.descriptor.getPath() + ": appendChild failed.");
    }
}

