/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.impl.sds.schema;

import fr.gael.drb.impl.sds.Length;
import fr.gael.drb.impl.sds.schema.SdfAttribute;
import org.apache.log4j.Logger;

public class SdfLength
extends SdfAttribute {
    private static Logger logger = Logger.getLogger(SdfLength.class);
    protected static final short UNIT_BIT = 1;
    protected static final short UNIT_BYTE = 2;
    protected static final short UNIT_UNKNOWN = -1;
    protected short unit = 1;

    protected SdfLength() {
        this(3);
    }

    protected SdfLength(int type) {
        super(type);
    }

    protected final short getUnit() {
        return this.unit;
    }

    protected final void setUnit(short unit) {
        this.unit = unit;
    }

    protected final Length getLength(int[] key) {
        long val = this.getValue(key);
        if (val == -1L) {
            return null;
        }
        if (this.unit == 2) {
            return new Length(val);
        }
        return new Length(0L, val);
    }

    protected final void setLength(int[] key, Length value) {
        if (value == null) {
            this.setValue(key, -1L);
        } else if (this.unit == 2) {
            this.setValue(key, value.getLength());
        } else {
            this.setValue(key, value.getLength() * 8L + (long)value.getBitLength());
        }
    }

    @Override
    public String toString() {
        String tmpStr;
        switch (this.accessType) {
            case 1: {
                tmpStr = "access=READ_ONLY";
                break;
            }
            case 3: {
                tmpStr = "access=READ_WRITE";
                break;
            }
            default: {
                tmpStr = "access=INVALID";
            }
        }
        if (this.unit == 1) {
            tmpStr = tmpStr + " unit=bit";
        } else if (this.unit == 2) {
            tmpStr = tmpStr + " unit=byte";
        }
        switch (this.occurrenceType) {
            case 1: {
                tmpStr = tmpStr + " occurs=SINGLE " + this.map;
                break;
            }
            case 2: {
                tmpStr = tmpStr + " occurs=MULTIPLE " + this.map;
                break;
            }
            default: {
                tmpStr = tmpStr + " occurs=INVALID";
            }
        }
        return "{" + tmpStr + "}";
    }
}

