/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.impl.xml;

import fr.gael.drb.impl.xml.SaxNode;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.log4j.Logger;

class SaxInputStream
extends InputStream {
    private static Logger logger = Logger.getLogger(SaxInputStream.class);
    int lineIndex = 0;
    int lineCount = 0;
    ArrayList lineOffset = new ArrayList();
    InputStream input;
    Long startHole = Long.MAX_VALUE;
    Long stopHole = Long.MAX_VALUE;
    Long offset = new Long(0L);
    SaxNode node;
    SaxNode[] ancestor;
    int depth = 0;
    boolean descending = true;

    SaxInputStream(InputStream input, SaxNode node) {
        this.input = input;
        this.node = node;
        this.ancestor = new SaxNode[node.depth + 1];
        SaxNode cur_node = node;
        for (int i = node.depth; i >= 0; --i) {
            this.ancestor[i] = cur_node;
            if (i <= 0) continue;
            cur_node = (SaxNode)cur_node.getParent();
        }
        this.depth = 1;
        this.addOffset(1, 1, 0L);
        this.update();
    }

    public long getOffset(int line_number, int column_number) {
        if (line_number < this.lineIndex + 1 || line_number > this.lineCount || column_number < 0) {
            logger.warn("Cannot find the offset for character at (" + line_number + ", " + column_number + ") within the incope lines.");
            return -1L;
        }
        ArrayList columnOffset = (ArrayList)this.lineOffset.get(line_number - 1 - this.lineIndex);
        for (int i = columnOffset.size() - 1; i > 0; i -= 2) {
            long colOffsetMap = ((Number)columnOffset.get(i)).longValue();
            int colNumberMap = ((Number)columnOffset.get(i - 1)).intValue();
            if (column_number < colNumberMap && (i != 1 || column_number != 0)) continue;
            return colOffsetMap + (long)(column_number - colNumberMap);
        }
        logger.warn("Cannot find offset for character at (" + line_number + ", " + column_number + ").");
        return -1L;
    }

    private void addOffset(int line_number, int column_number, long offset) {
        ArrayList columnOffset;
        if (line_number - this.lineIndex > 2000) {
            for (int i = 1000; i < this.lineOffset.size(); ++i) {
                ArrayList oldColumnOffset = (ArrayList)this.lineOffset.get(i - 1000);
                this.lineOffset.set(i - 1000, this.lineOffset.get(i));
                oldColumnOffset.clear();
                this.lineOffset.set(i, oldColumnOffset);
            }
            this.lineIndex += 1000;
        }
        if (line_number > this.lineIndex + this.lineOffset.size()) {
            columnOffset = new ArrayList();
            this.lineOffset.add(columnOffset);
        } else {
            columnOffset = (ArrayList)this.lineOffset.get(line_number - this.lineIndex - 1);
        }
        if (line_number > this.lineCount) {
            this.lineCount = line_number;
        }
        columnOffset.add(new Integer(column_number));
        columnOffset.add(new Long(offset));
    }

    private void removeOffset(int line_number, long start_offset, long end_offset) {
        logger.debug("Removing offset range at line " + line_number + ": start=" + start_offset + " end=" + end_offset);
        ArrayList columnOffsets = (ArrayList)this.lineOffset.get(line_number - this.lineIndex - 1);
        int lastColNumber = ((Number)columnOffsets.get(columnOffsets.size() - 2)).intValue();
        long lastColOffset = ((Number)columnOffsets.get(columnOffsets.size() - 1)).longValue();
        if (lastColOffset == start_offset) {
            logger.debug("Case of reiterated column mapping (L=" + line_number + " C=" + lastColNumber + ") -> offset=" + lastColOffset + " --> " + end_offset);
            columnOffsets.set(columnOffsets.size() - 1, new Long(end_offset));
        } else if (start_offset > lastColOffset) {
            int columnNumber = lastColNumber + (int)(start_offset - lastColOffset);
            logger.debug("Case of new column mapping (L=" + line_number + " C=" + columnNumber + ") -> offset=" + end_offset);
            columnOffsets.add(new Integer(columnNumber));
            columnOffsets.add(new Long(end_offset));
        }
    }

    private void update() {
        if (this.node == null) {
            return;
        }
        if (this.descending && this.depth < this.ancestor.length) {
            this.stopHole = this.startHole;
            if (this.ancestor[this.depth].tag.index > 0) {
                SaxNode parentNode = this.ancestor[this.depth - 1];
                this.startHole = parentNode.tag.endOpenOffset;
                this.stopHole = this.ancestor[this.depth].tag.startOffset;
            }
            if (this.depth == this.node.depth) {
                this.descending = false;
            } else {
                ++this.depth;
            }
            if (this.startHole.equals(this.stopHole)) {
                this.update();
            }
        } else if (this.depth > 0 && this.depth < this.ancestor.length) {
            SaxNode parentNode = this.ancestor[this.depth - 1];
            int currentIndex = this.ancestor[this.depth].tag.index;
            int lastIndex = this.ancestor[this.depth - 1].tag.childrenCount - 1;
            this.startHole = parentNode.getTagAt((int)currentIndex).endOffset;
            this.stopHole = parentNode.getTagAt((int)lastIndex).endOffset;
            --this.depth;
            if (this.startHole.equals(this.stopHole)) {
                this.update();
            }
        }
    }

    @Override
    public int read() throws IOException {
        if (this.offset.equals(this.startHole)) {
            if (this.stopHole == Long.MAX_VALUE) {
                return -1;
            }
            long size = this.stopHole - this.startHole;
            this.input.skip(size);
            this.removeOffset(this.lineCount, this.startHole, this.stopHole);
            this.update();
            this.offset = this.offset + size;
            return this.read();
        }
        int ch = this.input.read();
        if (ch == 10) {
            this.addOffset(this.lineCount + 1, 1, this.offset + 1L);
        }
        if (ch != -1) {
            this.offset = this.offset + 1L;
        }
        return ch;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.offset.equals(this.startHole)) {
            if (this.stopHole == Long.MAX_VALUE) {
                return -1;
            }
            long size = this.stopHole - this.startHole;
            this.input.skip(size);
            this.removeOffset(this.lineCount, this.startHole, this.stopHole);
            this.update();
            this.offset = this.offset + size;
            return this.read(b, off, len);
        }
        if (this.offset >= this.stopHole) {
            int lenRead = this.input.read(b, off, len);
            if (lenRead == -1) {
                return -1;
            }
            for (int i = 0; i < lenRead; ++i) {
                if (b[off + i] != 10) continue;
                this.addOffset(this.lineCount + 1, 1, this.offset + (long)i + 1L);
            }
            this.offset = this.offset + (long)lenRead;
            return lenRead;
        }
        if (this.offset < this.startHole) {
            long left = this.startHole - this.offset;
            if ((long)len <= left) {
                int lenRead = this.input.read(b, off, len);
                if (lenRead == -1) {
                    return -1;
                }
                for (int i = 0; i < lenRead; ++i) {
                    if (b[off + i] != 10) continue;
                    this.addOffset(this.lineCount + 1, 1, this.offset + (long)i + 1L);
                }
                this.offset = this.offset + (long)lenRead;
                return lenRead;
            }
            int len1 = this.input.read(b, off, (int)left);
            if (len1 == -1) {
                return -1;
            }
            for (int i = 0; i < len1; ++i) {
                if (b[off + i] != 10) continue;
                this.addOffset(this.lineCount + 1, 1, this.offset + (long)i + 1L);
            }
            this.offset = this.offset + (long)len1;
            if (this.stopHole == Long.MAX_VALUE) {
                return len1;
            }
            long size = this.stopHole - this.startHole;
            this.input.skip(size);
            this.removeOffset(this.lineCount, this.startHole, this.stopHole);
            this.update();
            this.offset = this.offset + size;
            int len2 = this.read(b, off + len1, len - len1);
            if (len2 == -1) {
                return len1;
            }
            return len1 + len2;
        }
        return -1;
    }

    @Override
    public int available() throws IOException {
        if (this.offset.equals(this.startHole)) {
            if (this.stopHole == Long.MAX_VALUE) {
                return 0;
            }
            long size = this.stopHole - this.startHole;
            this.input.skip(size);
            this.removeOffset(this.lineCount, this.startHole, this.stopHole);
            this.offset = this.offset + size;
            this.update();
            return this.available();
        }
        if (this.offset >= this.stopHole) {
            return this.input.available();
        }
        if (this.offset < this.startHole) {
            int left = this.input.available();
            if ((long)left < this.startHole - this.offset) {
                return left;
            }
            return (int)(this.startHole - this.offset);
        }
        return 0;
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }

    @Override
    public void mark(int readlimit) {
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("Mark not supported");
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

