/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.impl.xml;

import fr.gael.drb.DrbAttribute;
import fr.gael.drb.DrbAttributeList;
import fr.gael.drb.DrbDefaultAttribute;
import fr.gael.drb.DrbDefaultAttributeList;
import fr.gael.drb.DrbDefaultNodeList;
import fr.gael.drb.DrbDefaultSequence;
import fr.gael.drb.DrbNode;
import fr.gael.drb.DrbNodeList;
import fr.gael.drb.DrbSequence;
import fr.gael.drb.impl.DrbNodeImpl;
import fr.gael.drb.impl.xml.XmlItem;
import fr.gael.drb.impl.xml.XmlNode;
import fr.gael.drb.value.Value;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlDocument
extends DrbNodeImpl {
    private static Logger logger = Logger.getLogger(XmlDocument.class);
    protected Document document;
    protected DrbNode baseNode;

    public XmlDocument(String xml_string) {
        if (xml_string == null) {
            throw new NullPointerException("The XML string shall not be null.");
        }
        this.load(new InputSource(new StringReader(xml_string)));
    }

    public XmlDocument(Reader reader) {
        if (reader == null) {
            throw new NullPointerException("The XML reader shall not be null.");
        }
        this.load(new InputSource(reader));
    }

    public XmlDocument(InputStream input_stream) {
        if (input_stream == null) {
            throw new NullPointerException("The XML stream shall not be null.");
        }
        this.load(new InputSource(input_stream));
    }

    protected XmlDocument(DrbNode base_node) {
        InputSource input_source;
        if (base_node == null) {
            throw new NullPointerException("The base node shall not be null.");
        }
        this.baseNode = base_node;
        InputStream stream = (InputStream)this.getImpl(InputStream.class);
        if (stream != null) {
            input_source = new InputSource(stream);
            String system_id = this.getPath();
            if (system_id != null) {
                input_source.setSystemId(system_id);
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.load(input_source);
    }

    protected XmlDocument(InputSource input_source) {
        this.baseNode = null;
        this.load(input_source);
    }

    protected XmlDocument(Document document) {
        this.baseNode = null;
        this.document = document;
    }

    private void load(InputSource input_source) {
        if (input_source == null) {
            throw new IllegalArgumentException();
        }
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            builder.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    logger.debug("Resolving \"" + publicId + "\" - \"" + systemId + "\"");
                    if (systemId != null) {
                        URL url = new URL(systemId);
                        try {
                            return new InputSource(url.openStream());
                        }
                        catch (Exception e) {
                            logger.warn("Cannot access entity \"" + systemId + "\" - Continuing without ...");
                            logger.debug("Error accessing entity.", e);
                            return new InputSource(new ByteArrayInputStream("<?xml version='1.0' encoding='UTF-8'?>".getBytes()));
                        }
                    }
                    return null;
                }
            });
            this.document = builder.parse(input_source);
        }
        catch (ParserConfigurationException e) {
            logger.error("fr.gael.drb.impl.xml.XmlDocument(input_stream) : Warning : Document cannot be parsed: " + e.getMessage());
            logger.debug("fr.gael.drb.impl.xml.XmlDocument(input_stream) parsing error.", e);
            throw new IllegalArgumentException(e);
        }
        catch (IOException e) {
            logger.error("fr.gael.drb.impl.xml.XmlDocument(input_stream) : Warning : Document cannot be parsed.");
            logger.error("fr.gael.drb.impl.xml.XmlDocument(input_stream) : Warning : " + e.getMessage());
            throw new IllegalArgumentException();
        }
        catch (SAXException e) {
            logger.error("fr.gael.drb.impl.xml.XmlDocument(input_stream) : Warning : Document cannot be parsed.", e);
            logger.error("fr.gael.drb.impl.xml.XmlDocument(input_stream) : Warning : " + e.getMessage());
            throw new IllegalArgumentException();
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof XmlDocument) {
            XmlDocument dom_doc = (XmlDocument)obj;
            return this.document == dom_doc.document;
        }
        return false;
    }

    @Override
    public String getName() {
        if (this.baseNode == null) {
            return "";
        }
        return this.baseNode.getName();
    }

    @Override
    public String getNamespaceURI() {
        if (this.baseNode == null) {
            return null;
        }
        return this.baseNode.getNamespaceURI();
    }

    @Override
    public String getPath() {
        if (this.baseNode == null) {
            return "";
        }
        return this.baseNode.getPath();
    }

    @Override
    public int getIndex() {
        if (this.baseNode == null) {
            return -1;
        }
        return this.baseNode.getIndex();
    }

    @Override
    public int getValueType() {
        return -1;
    }

    @Override
    public Value getValue() {
        return null;
    }

    @Override
    public DrbAttributeList getAttributes() {
        if (this.baseNode == null) {
            return null;
        }
        DrbAttributeList attributes = this.baseNode.getAttributes();
        if (attributes == null || attributes.getLength() == 0) {
            return null;
        }
        DrbDefaultAttributeList list = new DrbDefaultAttributeList();
        for (int i = 0; i < attributes.getLength(); ++i) {
            DrbAttribute attrib = attributes.item(i);
            if (attrib == null) continue;
            list.add(new DrbDefaultAttribute(attrib.getName(), attrib.getValue(), this));
        }
        return list;
    }

    @Override
    public DrbNode getRoot() {
        if (this.baseNode != null) {
            return this.baseNode.getRoot();
        }
        return this;
    }

    @Override
    public DrbNode getParent() {
        if (this.baseNode == null) {
            return null;
        }
        return this.baseNode.getParent();
    }

    @Override
    public DrbNodeList getChildren() {
        Element doc_element = this.document.getDocumentElement();
        if (doc_element == null) {
            return null;
        }
        DrbDefaultNodeList list = new DrbDefaultNodeList();
        list.add(new XmlNode((Node)doc_element, (DrbNode)this));
        return list;
    }

    @Override
    public DrbSequence getContent() {
        DrbDefaultSequence list = new DrbDefaultSequence();
        for (Node child = this.document.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() == 1) {
                list.addItem(new XmlNode(child, (DrbNode)this));
                continue;
            }
            list.addItem(new XmlItem(child));
        }
        if (list.getLength() == 0) {
            return null;
        }
        return list;
    }

    @Override
    public boolean hasImpl(Class api) {
        if (this.baseNode != null && this.baseNode instanceof DrbNodeImpl) {
            return ((DrbNodeImpl)this.baseNode).hasImpl(api);
        }
        return super.hasImpl(api);
    }

    @Override
    public Object getImpl(Class api) {
        if (this.baseNode != null && this.baseNode instanceof DrbNodeImpl) {
            return ((DrbNodeImpl)this.baseNode).getImpl(api);
        }
        return super.getImpl(api);
    }
}

