/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.impl.xml;

import fr.gael.drb.DrbFactory;
import fr.gael.drb.DrbFactoryImpl;
import fr.gael.drb.DrbNode;
import fr.gael.drb.DrbUpdateImpl;
import fr.gael.drb.impl.DrbNodeImpl;
import fr.gael.drb.impl.xml.SaxDocument;
import fr.gael.drb.impl.xml.XmlDocument;
import fr.gael.drb.impl.xml.XmlWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.apache.log4j.Logger;

public class XmlFactory
implements DrbFactoryImpl,
DrbUpdateImpl {
    protected static long MAXIMUM_DOM_SIZE = 1000000L;
    private final Logger logger = Logger.getLogger(XmlFactory.class);

    public static void main(String[] args) {
        DrbNode inputNode = DrbFactory.open(args[0]);
        XmlFactory.writeXML(inputNode, System.out);
    }

    public static void writeXML(DrbNode node, OutputStream file) {
        XmlWriter.writeXML(node, file);
    }

    @Override
    public String getIdentifier() {
        return "xml";
    }

    @Override
    public String getName() {
        return "eXtensible Markup Language (XML)";
    }

    @Override
    public DrbNode open(DrbNode base_node) {
        if (base_node == null || !(base_node instanceof DrbNodeImpl)) {
            return null;
        }
        DrbNodeImpl baseImpl = (DrbNodeImpl)base_node;
        InputStream stream = (InputStream)baseImpl.getImpl(InputStream.class);
        if (stream != null) {
            try {
                int stream_size = stream.available();
                stream.close();
                long max_dom = Long.getLong("fr.gael.drb.impl.dom_max_size", MAXIMUM_DOM_SIZE);
                if ((long)stream_size > max_dom) {
                    this.logger.debug("Using SAX for '" + base_node.getPath() + "'");
                    return new SaxDocument(base_node);
                }
                return new XmlDocument(base_node);
            }
            catch (Exception e) {
                this.logger.error("Problem occurred while parsing " + base_node.getPath() + ". " + e.getMessage());
                return null;
            }
        }
        return null;
    }

    @Override
    public DrbNode open(URL uri) {
        DrbNode baseNode = DrbFactory.open(uri.toString());
        if (baseNode == null) {
            return null;
        }
        return this.open(baseNode);
    }

    @Override
    public DrbNode open(URL uri, DrbNode base_node) {
        return this.open(base_node);
    }

    @Override
    public void put(DrbNode input, DrbNode target_node) {
        if (input == null || !(target_node instanceof DrbNodeImpl)) {
            return;
        }
        DrbNodeImpl baseImpl = (DrbNodeImpl)target_node;
        OutputStream stream = (OutputStream)baseImpl.getImpl(OutputStream.class);
        if (stream != null) {
            try {
                XmlFactory.writeXML(input, stream);
            }
            catch (Exception e) {
                this.logger.error("Problem occurred while parsing " + target_node.getPath() + ". " + e.getMessage());
            }
        }
    }

    @Override
    public void put(DrbNode input, URL uri) {
        this.put(input, DrbFactory.open(uri.toString()));
    }

    @Override
    public void put(DrbNode input, URL uri, DrbNode base_node) {
        throw new UnsupportedOperationException("XmlFactory.put(input, uri, base) : This operation is not supported by this implementation.");
    }
}

