/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.query;

import fr.gael.drb.DrbDefaultSequence;
import fr.gael.drb.DrbItem;
import fr.gael.drb.DrbNode;
import fr.gael.drb.DrbSequence;
import fr.gael.drb.query.AbstractExpression;
import fr.gael.drb.query.DynamicContext;
import fr.gael.drb.query.DynamicException;
import fr.gael.drb.query.Expression;
import fr.gael.drb.query.Token;

class DeleteExpression
extends AbstractExpression {
    private Expression targetExpression = null;

    public DeleteExpression(Token token) {
        super("Delete", token);
    }

    public void setTargetExpression(Expression target_expression) {
        this.targetExpression = target_expression;
    }

    @Override
    public DrbSequence evaluate(DynamicContext context) {
        if (this.targetExpression == null) {
            throw new DynamicException(this, "Incomplete \"delete\" declaration");
        }
        DrbSequence target_sequence = this.targetExpression.evaluate(context);
        if (target_sequence == null) {
            throw new DynamicException(this, "Error while evaluating the target expression");
        }
        if (this.isCancellationRequested()) {
            this.throwCancelException();
        }
        for (int i = 0; i < target_sequence.getLength(); ++i) {
            int target_index;
            DrbNode target_parent;
            DrbItem target_item = target_sequence.getItem(i);
            if (target_item.getItemType() == 1) {
                DrbNode target_node = (DrbNode)target_item;
                target_parent = target_node.getParent();
                target_index = target_node.getIndex();
                if (target_parent == null) {
                    throw new DynamicException(this, "[XUST0001] - While deleting an element, the target node must have a parent");
                }
            } else {
                if (target_item.getItemType() == 2) {
                    throw new DynamicException(this, "[XUST0001] - 'Delete' expression is not implemented for attributes");
                }
                throw new DynamicException(this, "[XUST0001] - Cannot delete an atomic value");
            }
            target_parent.removeChild(target_index);
        }
        DrbDefaultSequence output_sequence = new DrbDefaultSequence();
        return output_sequence;
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public boolean isUpdating() {
        return true;
    }
}

