/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.query;

import fr.gael.drb.DrbDefaultSequence;
import fr.gael.drb.DrbItem;
import fr.gael.drb.DrbSequence;
import fr.gael.drb.query.AbstractExpression;
import fr.gael.drb.query.DynamicContext;
import fr.gael.drb.query.Expression;
import fr.gael.drb.query.PredicatsListExpression;
import fr.gael.drb.query.Query;
import fr.gael.drb.query.Token;

class FilterExpression
extends AbstractExpression {
    private Expression expression;
    private Expression predicatsList;

    public FilterExpression(Token token, Expression expression, Expression predicats) {
        super("Filter", token);
        this.expression = expression;
        this.predicatsList = predicats;
    }

    @Override
    public DrbSequence evaluate(DynamicContext context) {
        DrbSequence sequence = this.expression.evaluate(context);
        return this.filterSequence(context, sequence);
    }

    @Override
    public boolean isConstant() {
        return this.expression.isConstant() && this.predicatsList.isConstant();
    }

    private DrbSequence filterSequence(DynamicContext context, DrbSequence sequence) {
        DrbItem current_item;
        if (this.predicatsList == null || sequence == null) {
            return sequence;
        }
        DynamicContext innerContext = new DynamicContext(context);
        DrbDefaultSequence sequence_output = new DrbDefaultSequence();
        int[] positions = new int[2];
        if (!((PredicatsListExpression)this.predicatsList).getEvaluationLimit(context, positions)) {
            return sequence_output;
        }
        int min_position = positions[0];
        int max_position = positions[1];
        if (max_position > sequence.getLength()) {
            max_position = sequence.getLength();
        }
        if (min_position < 1) {
            min_position = 1;
        }
        for (int pos = min_position - 1; pos < max_position && (current_item = sequence.getItem(pos)) != null; ++pos) {
            innerContext.focus.setContextItem(current_item);
            innerContext.focus.setContextPosition(pos + 1);
            innerContext.focus.setContextSize(sequence.getLength());
            if (!Query.getEffectiveBooleanValue(this.predicatsList.evaluate(innerContext))) continue;
            sequence_output.addItem(current_item);
        }
        return sequence_output;
    }
}

