/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.query;

import fr.gael.drb.DrbSequence;
import fr.gael.drb.query.QName;
import fr.gael.drb.query.SequenceType;
import fr.gael.drb.query.TypeCastException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

class FunctionSignature {
    private QName name;
    private SequenceType returnType;
    private boolean isVarArgs;
    private boolean updating;
    private List<QName> parameterNames = new Vector<QName>();
    private List<SequenceType> parameterTypes = new Vector<SequenceType>();

    protected FunctionSignature(QName name) {
        this(name, new SequenceType());
    }

    protected FunctionSignature(QName name, SequenceType return_type) {
        this(name, return_type, false);
    }

    protected FunctionSignature(QName name, SequenceType return_type, boolean updating) {
        if (name == null) {
            throw new NullPointerException("Cannot initialize a function with a null name.");
        }
        this.name = new QName(name);
        this.setReturnType(return_type);
        this.updating = updating;
        this.isVarArgs = false;
    }

    protected FunctionSignature(String local_name, String uri, String return_type_name, String[] parameter_type_names) {
        this.name = new QName(local_name, uri);
        this.isVarArgs = false;
        for (String parameter_type_name : parameter_type_names) {
            SequenceType parameter_type = new SequenceType();
            if (parameter_type_name != null) {
                parameter_type = new SequenceType(parameter_type_name);
            }
            QName parameter_name = new QName("arg" + this.getArity());
            this.addParameter(parameter_name, parameter_type);
        }
        this.updating = false;
        SequenceType return_type = new SequenceType();
        if (return_type_name != null) {
            return_type = new SequenceType(return_type_name);
        }
        this.setReturnType(return_type);
    }

    protected QName getQName() {
        return this.name;
    }

    public String getName() {
        return this.name.getName();
    }

    protected SequenceType getReturnType() {
        return this.returnType;
    }

    protected void setReturnType(SequenceType return_type) {
        if (return_type == null) {
            throw new NullPointerException("Cannot initialize a function with a null return type.");
        }
        this.returnType = return_type;
    }

    protected void setName(String name) {
        if (name == null) {
            throw new NullPointerException("Cannot replace name with a null reference.");
        }
        this.name = new QName(name);
    }

    public String getSequenceTypeName() {
        return this.returnType.getName();
    }

    public boolean matches(QName name, int arity) {
        return this.name.equals(name) && (this.isVarArgs || this.getArity() == arity);
    }

    public void addParameter(QName parameter_name) {
        this.addParameter(parameter_name, new SequenceType());
    }

    public void addParameter(QName parameter_name, SequenceType parameter_type) {
        if (parameter_name == null || parameter_type == null) {
            throw new NullPointerException("Cannot add a null parameter");
        }
        this.parameterNames.add(new QName(parameter_name));
        this.parameterTypes.add(parameter_type);
    }

    public int getArity() {
        return this.parameterNames.size();
    }

    boolean isVarArgs() {
        return this.isVarArgs;
    }

    public QName getParameter(int parameter_index) {
        return this.parameterNames.get(parameter_index);
    }

    public SequenceType getParameterType(int parameter_index) {
        return this.parameterTypes.get(parameter_index);
    }

    public boolean isUpdating() {
        return this.updating;
    }

    public List<DrbSequence> convert(List<DrbSequence> parameters) throws TypeCastException {
        if (!this.isVarArgs() || parameters.size() != this.getArity()) {
            throw new IllegalArgumentException("The function " + this.getName() + "() requires " + this.getArity() + " parameter(s)");
        }
        ArrayList<DrbSequence> typed_values = new ArrayList<DrbSequence>();
        for (int iparam = 0; iparam < parameters.size(); ++iparam) {
            try {
                typed_values.add(this.getParameterType(iparam).convert(parameters.get(iparam)));
                continue;
            }
            catch (TypeCastException e) {
                throw new TypeCastException("Cannot convert the parameter " + this.getParameter(iparam) + " to " + this.getParameterType(iparam));
            }
        }
        return typed_values;
    }

    public String toString() {
        if (this.returnType != null) {
            return this.name.getName() + "()" + this.returnType;
        }
        return this.name.getName() + "()";
    }
}

