/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.query;

import fr.gael.drb.DrbSequence;
import fr.gael.drb.query.AbstractExpression;
import fr.gael.drb.query.DynamicContext;
import fr.gael.drb.query.DynamicException;
import fr.gael.drb.query.Expression;
import fr.gael.drb.query.LiteralResult;
import fr.gael.drb.query.Query;
import fr.gael.drb.query.Token;

class LogicalExpression
extends AbstractExpression {
    static int OR = 0;
    static int AND = 1;
    Expression leftOperand;
    Expression rightOperand;
    int operation;

    public LogicalExpression(Token token, Expression left_operand, int operation, Expression right_operand) {
        super("Local", token);
        this.leftOperand = left_operand;
        this.operation = operation;
        this.rightOperand = right_operand;
    }

    public String toString() {
        String operation_string = this.operation == OR ? "or" : (this.operation == AND ? "and" : "(unknown binary operation #" + this.operation + ")");
        return this.leftOperand + " " + operation_string + " " + this.rightOperand;
    }

    @Override
    public DrbSequence evaluate(DynamicContext context) {
        DrbSequence leftEval = this.leftOperand.evaluate(context);
        if (leftEval == null) {
            throw new DynamicException(this, "Error while evaluating the left operand");
        }
        boolean leftEbv = Query.getEffectiveBooleanValue(leftEval);
        if (this.operation == OR && leftEbv) {
            return LiteralResult.TRUE;
        }
        if (this.operation == AND && !leftEbv) {
            return LiteralResult.FALSE;
        }
        DrbSequence rightEval = this.rightOperand.evaluate(context);
        if (rightEval == null) {
            throw new DynamicException(this, "Error while evaluating the right operand");
        }
        boolean rightEbv = Query.getEffectiveBooleanValue(rightEval);
        boolean output_ebv = this.operation == OR ? leftEbv || rightEbv : leftEbv && rightEbv;
        return output_ebv ? LiteralResult.TRUE : LiteralResult.FALSE;
    }
}

