/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.query;

import fr.gael.drb.DrbAbstractSequence;
import fr.gael.drb.DrbItem;
import fr.gael.drb.DrbSequence;
import java.util.ArrayList;
import java.util.List;

final class SequenceResult
extends DrbAbstractSequence {
    private List<DrbSequence> subResults = new ArrayList<DrbSequence>();
    private int totalLength = -1;

    SequenceResult() {
    }

    @Override
    public int getLength() {
        if (this.totalLength < 0) {
            this.totalLength = 0;
            for (DrbSequence result : this.subResults) {
                this.totalLength += result.getLength();
            }
        }
        return this.totalLength;
    }

    void append(DrbSequence sub_result) {
        if (sub_result == null) {
            throw new NullPointerException("The sub-result cannot be null");
        }
        this.subResults.add(sub_result);
        this.totalLength = -1;
    }

    @Override
    public DrbItem getItem(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("Item index cannot be negative");
        }
        if (index >= this.totalLength && this.totalLength >= 0) {
            return null;
        }
        int position = 0;
        for (DrbSequence result : this.subResults) {
            int resultLen = result.getLength();
            if (index < position + resultLen) {
                return result.getItem(index - position);
            }
            position += resultLen;
        }
        this.totalLength = position;
        return null;
    }
}

