/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.query;

import fr.gael.drb.DrbDefaultSequence;
import fr.gael.drb.DrbSequence;
import fr.gael.drb.query.QName;
import fr.gael.drb.query.TypeCastException;
import fr.gael.drb.value.Value;
import fr.gael.drb.value.ValueArray;
import fr.gael.drb.xsd.XmlSchema;
import fr.gael.drb.xsd.XsdSimpleType;
import fr.gael.drb.xsd.XsdType;
import java.util.ArrayList;
import org.apache.log4j.Logger;

class SequenceType {
    private Logger logger = Logger.getLogger(SequenceType.class);
    public static final int ONE_OCCURRENCE = 0;
    public static final int ZERO_OR_ONE_OCCURRENCE = 1;
    public static final int ZERO_OR_MORE_OCCURRENCE = 2;
    public static final int ONE_OR_MORE_OCCURRENCE = 3;
    private QName typeName;
    private int valueTypeId = -2;
    private int occurrenceIndicator = 0;

    public SequenceType() {
        this(0, -2, 2);
    }

    public SequenceType(String type_name) {
        this(type_name.replace("[?+*]", ""), SequenceType.getOccurrenceIndicator(type_name));
    }

    public SequenceType(int item_kind, int value_type, int occurrence) {
        this.valueTypeId = value_type;
        this.typeName = new QName("xs:anyType");
        this.occurrenceIndicator = occurrence;
    }

    public SequenceType(QName schema_type) {
        this(schema_type, 0);
    }

    public SequenceType(String type_name, int occurrence) {
        this(new QName(type_name), occurrence);
    }

    public SequenceType(QName type_name, int occurrence) {
        this.typeName = type_name;
        this.occurrenceIndicator = occurrence;
        if (type_name.getName().equals("item()")) {
            this.valueTypeId = -2;
        } else if (type_name.getName().equals("node()")) {
            this.valueTypeId = -2;
        } else {
            XsdType schema_type = SequenceType.getSchemaType(type_name);
            if (schema_type == null) {
                this.logger.error("The schema type " + type_name + " is not declared.");
                this.valueTypeId = -2;
            } else {
                this.valueTypeId = SequenceType.getValueTypeId(schema_type);
            }
        }
    }

    static int getOccurrenceIndicator(String type_name) {
        if (type_name.endsWith("?")) {
            return 1;
        }
        if (type_name.endsWith("+")) {
            return 3;
        }
        if (type_name.endsWith("*")) {
            return 2;
        }
        return 0;
    }

    static XsdType getSchemaType(QName type_name) {
        return XmlSchema.getDefaultSchema().getType(type_name.getName());
    }

    static int getValueTypeId(XsdType schema_type) {
        XsdSimpleType simple_type;
        if (schema_type != null && (simple_type = schema_type.getDatatype()) != null) {
            return simple_type.getTypeId();
        }
        return -2;
    }

    static int getValueTypeId(QName type_name) {
        return SequenceType.getValueTypeId(SequenceType.getSchemaType(type_name));
    }

    public String getName() {
        return this.typeName.getName();
    }

    public int getOccurrenceIndicator() {
        return this.occurrenceIndicator;
    }

    public boolean matchesOccurrencesOf(DrbSequence sequence) {
        boolean occurrence_matches = true;
        if (this.occurrenceIndicator == 0 && sequence.getLength() != 1) {
            occurrence_matches = false;
        } else if (this.occurrenceIndicator == 3 && sequence.getLength() < 1) {
            occurrence_matches = false;
        } else if (this.occurrenceIndicator == 2 && sequence.getLength() < 0) {
            occurrence_matches = false;
        } else if (this.occurrenceIndicator == 1 && (sequence.getLength() < 0 || sequence.getLength() > 1)) {
            occurrence_matches = false;
        }
        return occurrence_matches;
    }

    public DrbSequence convert(DrbSequence sequence) throws TypeCastException {
        if (!this.matchesOccurrencesOf(sequence)) {
            throw new TypeCastException("Sequence of " + sequence.getLength() + " occurrence(s) does not match the sequence type occurrence indicator \"" + this + "\".");
        }
        if (this.valueTypeId == -2) {
            return sequence;
        }
        ValueArray array = sequence.atomize();
        ArrayList output_sequence = null;
        for (int iitem = 0; iitem < array.getLength(); ++iitem) {
            Value value = array.getElement(iitem);
            if (value.getType() == this.valueTypeId) continue;
            try {
                value = value.convertTo(this.valueTypeId);
            }
            catch (ClassCastException e) {
                throw new TypeCastException(e.getMessage());
            }
            if (output_sequence == null) {
                output_sequence = new DrbDefaultSequence();
                for (int jitem = 0; jitem < iitem; ++jitem) {
                    output_sequence.add(sequence.getItem(jitem).getValue());
                }
            }
            output_sequence.add(value);
        }
        if (output_sequence != null) {
            return output_sequence;
        }
        return array;
    }

    public String toString() {
        if (this.occurrenceIndicator == 3) {
            return this.typeName.getName() + "+";
        }
        if (this.occurrenceIndicator == 2) {
            return this.typeName.getName() + "*";
        }
        if (this.occurrenceIndicator == 1) {
            return this.typeName.getName() + "?";
        }
        return this.typeName.getName();
    }
}

