/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.query;

import fr.gael.drb.DrbSequence;
import fr.gael.drb.query.DefaultVariable;
import fr.gael.drb.query.DynamicContext;
import fr.gael.drb.query.DynamicException;
import fr.gael.drb.query.Expression;
import fr.gael.drb.query.Function;
import fr.gael.drb.query.FunctionSignature;
import fr.gael.drb.query.QName;
import fr.gael.drb.query.SequenceType;
import fr.gael.drb.query.TypeCastException;
import fr.gael.drb.query.TypeException;
import java.util.List;
import org.apache.log4j.Logger;

class UserDefinedFunction
extends Function {
    private Logger logger = Logger.getLogger(UserDefinedFunction.class);
    private Expression body;
    private static boolean isParameterTypeExpectionWarningPrinted = false;
    private static boolean isReturnTypeExpectionWarningPrinted = false;

    protected UserDefinedFunction(FunctionSignature signature) {
        super(signature);
    }

    protected UserDefinedFunction(QName name, boolean updating) {
        this(new FunctionSignature(name, new SequenceType(), updating));
    }

    protected Expression getExpression() {
        return this.body;
    }

    protected void setExpression(Expression expression) {
        this.body = expression;
    }

    @Override
    public DrbSequence evaluate(DynamicContext context, List<DrbSequence> values) {
        TypeException type_exception;
        DynamicContext innerContext = new DynamicContext(context);
        if (values.size() != this.getArity()) {
            throw new DynamicException(this.body, "XP0017 - Invalid arity of function \"" + this.getName() + "\" parameters (maximum expected: " + this.getArity() + ", provided: " + values.size() + ")");
        }
        for (int iparam = 0; iparam < values.size(); ++iparam) {
            try {
                DefaultVariable variable = new DefaultVariable(this.getParameter(iparam), this.getParameterType(iparam), values.get(iparam));
                innerContext.addInScopeVariable(variable);
                continue;
            }
            catch (TypeCastException e) {
                type_exception = new TypeException(this.getExpression(), "Cannot convert the parameter \"" + this.getParameter(iparam) + "\" of function \"" + this.getName() + "\" to " + this.getParameterType(iparam) + ": given value is \"" + values.get(iparam) + "\"");
                if (!context.isBackwardCompatibilityMode()) {
                    throw type_exception;
                }
                this.logger.error("Type Exception: " + type_exception.getMessage());
                if (!isParameterTypeExpectionWarningPrinted) {
                    this.logger.warn("Previous parameter type error did not interrupt the evaluation because the backward compatibility mode has been set. This compatibility may be disrupted in any future version so users are strongly invited to update their XQuery scripts to comply the W3C recommendation c.f. http://www.w3.org/TR/2007/REC-xquery-20070123 (This message will not be repeated in this session).");
                    isParameterTypeExpectionWarningPrinted = true;
                }
                DefaultVariable variable = new DefaultVariable(this.getParameter(iparam), null, values.get(iparam));
                innerContext.addInScopeVariable(variable);
            }
        }
        DrbSequence result = this.body.evaluate(innerContext);
        try {
            return this.getReturnType().convert(result);
        }
        catch (TypeCastException e) {
            type_exception = new TypeException(this.getExpression(), "Cannot convert the result of function \"" + this.getName() + "\" to return type " + this.getReturnType() + " (" + e.getMessage() + ")");
            if (!context.isBackwardCompatibilityMode()) {
                throw type_exception;
            }
            this.logger.error("Type Exception: " + type_exception.getMessage());
            if (!isReturnTypeExpectionWarningPrinted) {
                this.logger.warn("Previous return type error did not interrupt the evaluation because the backward compatibility mode has been set. This compatibility may be disrupted in any future version so users are strongly invited to update their XQuery scripts to comply the W3C recommendation c.f. http://www.w3.org/TR/2007/REC-xquery-20070123 (This message will not be repeated in this session).");
                isReturnTypeExpectionWarningPrinted = true;
            }
            return result;
        }
    }
}

