/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.value;

import fr.gael.drb.value.AbstractValue;
import fr.gael.drb.value.Comparison;
import fr.gael.drb.value.Int;
import fr.gael.drb.value.Logic;
import fr.gael.drb.value.String;
import fr.gael.drb.value.Value;

public class Boolean
extends AbstractValue
implements Logic {
    static final int PRIORITY = 0;
    private boolean value;

    public Boolean(boolean v) {
        this.value = v;
    }

    public Boolean(java.lang.String v) {
        if (v.compareToIgnoreCase("true") == 0 || v.equals("1")) {
            this.value = true;
        }
        if (v.compareToIgnoreCase("false") == 0 || v.equals("0")) {
            this.value = false;
        }
    }

    public Boolean(int v) {
        this.value = v != 0;
    }

    public java.lang.String toString() {
        return this.value ? "true" : "false";
    }

    @Override
    public final int getType() {
        return 0;
    }

    @Override
    public final int getPriority() {
        return 0;
    }

    @Override
    public final Value convertTo(int type) throws ClassCastException {
        switch (type) {
            case 0: {
                return this;
            }
            case 7: {
                return new String(this.toString());
            }
        }
        return new Int(this.value ? 1 : 0).convertTo(type);
    }

    @Override
    public void assign(Value v) {
        Boolean vb = (Boolean)v.convertTo(0);
        this.value = vb.booleanValue();
    }

    @Override
    public int compareTo(Value x) {
        if (this.getPriority() < x.getPriority()) {
            return ((Comparison)((Object)this.convertTo(x.getType()))).compareTo(x);
        }
        boolean b = ((Logic)((Object)x.convertTo(0))).booleanValue();
        if (this.booleanValue() == b) {
            return 0;
        }
        return b ? -1 : 1;
    }

    @Override
    public final boolean and(Value x) {
        return this.booleanValue() && ((Logic)((Object)x)).booleanValue();
    }

    @Override
    public final boolean or(Value x) {
        return this.booleanValue() || ((Logic)((Object)x)).booleanValue();
    }

    @Override
    public final boolean booleanValue() {
        return this.value;
    }
}

