/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.value;

import fr.gael.drb.value.AbstractValueArray;
import fr.gael.drb.value.Boolean;
import fr.gael.drb.value.NumericArray;
import fr.gael.drb.value.String;
import fr.gael.drb.value.Value;
import fr.gael.drb.value.ValueArray;

public class BooleanArray
extends AbstractValueArray
implements NumericArray {
    static final int PRIORITY = 0;
    private boolean[] value;

    public BooleanArray(boolean[] v) {
        this.value = new boolean[v.length];
        System.arraycopy(v, 0, this.value, 0, v.length);
    }

    public BooleanArray(java.lang.String v) {
        java.lang.String[] list = v.toString().trim().split(" ");
        this.value = new boolean[list.length];
        for (int i = 0; i < this.length(); ++i) {
            this.assign(i, new Boolean(list[i]));
        }
    }

    public BooleanArray(int size) {
        this.value = new boolean[size];
    }

    public final boolean[] getData() {
        return this.value;
    }

    @Override
    public final int getType() {
        return 10;
    }

    @Override
    public final int getPriority() {
        return 0;
    }

    @Override
    public final Value convertTo(int type) throws ClassCastException {
        if (type == 10) {
            return this;
        }
        if (type == 7) {
            return new String(this.toString());
        }
        throw new ClassCastException();
    }

    @Override
    public final void assign(Value v) throws ClassCastException {
        block4: {
            block3: {
                if (v.getType() == 7) {
                    v = new BooleanArray(v.toString());
                }
                if (!(v instanceof NumericArray)) break block3;
                NumericArray b = (NumericArray)v;
                this.value = new boolean[b.length()];
                for (int i = 0; i < this.length(); ++i) {
                    this.value[i] = b.booleanValue(i);
                }
                break block4;
            }
            if (v.getType() != 10) break block4;
            ValueArray b = (ValueArray)v;
            this.value = new boolean[b.length()];
            for (int i = 0; i < this.length(); ++i) {
                this.assign(i, b.getElement(i));
            }
        }
    }

    @Override
    public final int getArrayType() {
        return 0;
    }

    @Override
    public final Value getElement(int index) {
        return new Boolean(this.value[index]);
    }

    @Override
    public final void assign(int index, Value element) {
        element = element.convertTo(0);
        this.value[index] = ((Boolean)element).booleanValue();
    }

    @Override
    public final int length() {
        return this.value.length;
    }

    @Override
    public final boolean booleanValue(int index) {
        return this.value[index];
    }

    @Override
    public final byte byteValue(int index) {
        return (byte)(this.value[index] ? 1 : 0);
    }

    @Override
    public final int intValue(int index) {
        return this.value[index] ? 1 : 0;
    }

    @Override
    public final long longValue(int index) {
        return this.value[index] ? 1 : 0;
    }

    @Override
    public final short shortValue(int index) {
        return (short)(this.value[index] ? 1 : 0);
    }

    @Override
    public final float floatValue(int index) {
        return this.value[index] ? 1.0f : 0.0f;
    }

    @Override
    public final double doubleValue(int index) {
        return this.value[index] ? 1.0 : 0.0;
    }

    @Override
    public final void assign(int index, boolean value) {
        this.value[index] = value;
    }

    @Override
    public final void assign(int index, byte value) {
        this.value[index] = value != 0;
    }

    @Override
    public final void assign(int index, int value) {
        this.value[index] = value != 0;
    }

    @Override
    public final void assign(int index, short value) {
        this.value[index] = value != 0;
    }

    @Override
    public final void assign(int index, long value) {
        this.value[index] = value != 0L;
    }

    @Override
    public final void assign(int index, float value) {
        this.value[index] = value != 0.0f;
    }

    @Override
    public final void assign(int index, double value) {
        this.value[index] = value != 0.0;
    }

    public java.lang.String toString() {
        java.lang.String str = "";
        for (int i = 0; i < this.length(); ++i) {
            if (i != 0) {
                str = str + " ";
            }
            str = str + (this.value[i] ? "true" : "false");
        }
        return str;
    }
}

