/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.value;

import fr.gael.drb.value.AbstractNumericArray;
import fr.gael.drb.value.Float;
import fr.gael.drb.value.Numeric;
import fr.gael.drb.value.NumericArray;
import fr.gael.drb.value.String;
import fr.gael.drb.value.Value;
import fr.gael.drb.value.ValueFormat;

public class FloatArray
extends AbstractNumericArray
implements ValueFormat {
    static final int PRIORITY = 5;
    private float[] value;

    public FloatArray(float[] v) {
        this.value = new float[v.length];
        System.arraycopy(v, 0, this.value, 0, v.length);
    }

    public FloatArray(int size) {
        this.value = new float[size];
    }

    public final float[] getData() {
        return this.value;
    }

    @Override
    public java.lang.String getFormattedString(int length) {
        java.lang.String str = "";
        for (int i = 0; i < this.length(); ++i) {
            str = str + Float.getFormattedString(4, this.value[i]);
        }
        return str;
    }

    @Override
    public final byte[] getFormattedBuffer() {
        byte[] buffer = new byte[4 * this.length()];
        for (int i = 0; i < this.length(); ++i) {
            int int_value = java.lang.Float.floatToRawIntBits(this.value[i]);
            buffer[4 * i + 0] = (byte)(int_value >>> 24);
            buffer[4 * i + 1] = (byte)(int_value >>> 16);
            buffer[4 * i + 2] = (byte)(int_value >>> 8);
            buffer[4 * i + 3] = (byte)int_value;
        }
        return buffer;
    }

    @Override
    public final int getType() {
        return 10;
    }

    @Override
    public final int getPriority() {
        return 5;
    }

    @Override
    public final Value convertTo(int type) throws ClassCastException {
        if (type == 10) {
            return this;
        }
        if (type == 7) {
            return new String(this.toString());
        }
        throw new ClassCastException();
    }

    @Override
    public final void assign(Value v) throws ClassCastException {
        NumericArray b = (NumericArray)v;
        this.value = new float[b.length()];
        for (int i = 0; i < this.length(); ++i) {
            this.value[i] = b.floatValue(i);
        }
    }

    @Override
    public final int getArrayType() {
        return 5;
    }

    @Override
    public final Value getElement(int index) {
        return new Float(this.value[index]);
    }

    @Override
    public final void assign(int index, Value element) {
        element = element.convertTo(9);
        this.value[index] = ((Numeric)element).floatValue();
    }

    @Override
    public final int length() {
        return this.value.length;
    }

    @Override
    public final boolean booleanValue(int index) {
        return this.value[index] != 0.0f;
    }

    @Override
    public final byte byteValue(int index) {
        return (byte)this.value[index];
    }

    @Override
    public final int intValue(int index) {
        return (int)this.value[index];
    }

    @Override
    public final long longValue(int index) {
        return (long)this.value[index];
    }

    @Override
    public final short shortValue(int index) {
        return (short)this.value[index];
    }

    @Override
    public final float floatValue(int index) {
        return this.value[index];
    }

    @Override
    public final double doubleValue(int index) {
        return this.value[index];
    }

    @Override
    public final void assign(int index, boolean value) {
        this.value[index] = value ? 1 : 0;
    }

    @Override
    public final void assign(int index, byte value) {
        this.value[index] = value;
    }

    @Override
    public final void assign(int index, int value) {
        this.value[index] = value;
    }

    @Override
    public final void assign(int index, short value) {
        this.value[index] = value;
    }

    @Override
    public final void assign(int index, long value) {
        this.value[index] = value;
    }

    @Override
    public final void assign(int index, float value) {
        this.value[index] = value;
    }

    @Override
    public final void assign(int index, double value) {
        this.value[index] = (float)value;
    }

    public java.lang.String toString() {
        StringBuffer strbuf = new StringBuffer(this.value.length * 10);
        for (int i = 0; i < this.value.length; ++i) {
            if (i != 0) {
                strbuf.append(" ");
            }
            strbuf.append(this.value[i]);
        }
        return strbuf.toString();
    }
}

