/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.value;

import fr.gael.drb.value.AbstractNumeric;
import fr.gael.drb.value.Comparison;
import fr.gael.drb.value.Numeric;
import fr.gael.drb.value.Value;
import fr.gael.drb.value.ValueFormat;
import java.text.DecimalFormat;

public class Short
extends AbstractNumeric
implements ValueFormat {
    static final int PRIORITY = 2;
    short value;

    public Short(short v) {
        this.value = v;
    }

    public Short(int v) {
        this.value = (short)v;
    }

    public String toString() {
        return java.lang.Short.toString(this.value);
    }

    @Override
    public String getFormattedString(int length) {
        return Short.getFormattedString(length, this.value, true);
    }

    @Override
    public byte[] getFormattedBuffer() {
        return Short.getFormattedBuffer(this.value);
    }

    public static String getFormattedString(int length, short value, boolean is_signed) {
        if (is_signed) {
            return new String(new DecimalFormat("+00000;-00000").format(value));
        }
        return new String(new DecimalFormat("+00000;-00000").format(value & 0xFFFF));
    }

    public static byte[] getFormattedBuffer(short value) {
        byte[] buffer = new byte[]{(byte)(value >> 8), (byte)value};
        return buffer;
    }

    @Override
    public final int getType() {
        return 2;
    }

    @Override
    public final int getPriority() {
        return 2;
    }

    @Override
    public final Value convertTo(int type) throws ClassCastException {
        switch (type) {
            case 2: 
            case 9: {
                return this;
            }
        }
        return super.convertTo(type);
    }

    @Override
    public void assign(Value v) {
        Short vs = (Short)v.convertTo(2);
        this.value = vs.shortValue();
    }

    @Override
    public Value unaryMinus() {
        return new Short((int)(-this.value));
    }

    @Override
    public Value add(Value x) {
        if (this.getPriority() < x.getPriority()) {
            return ((Numeric)this.convertTo(x.getType())).add(x);
        }
        x = x.convertTo(9);
        return new Short(this.shortValue() + ((Numeric)x).shortValue());
    }

    @Override
    public Value sub(Value x) {
        if (this.getPriority() < x.getPriority()) {
            return ((Numeric)this.convertTo(x.getType())).sub(x);
        }
        x = x.convertTo(9);
        return new Short(this.shortValue() - ((Numeric)x).shortValue());
    }

    @Override
    public Value multiply(Value x) {
        if (this.getPriority() < x.getPriority()) {
            return ((Numeric)this.convertTo(x.getType())).multiply(x);
        }
        x = x.convertTo(9);
        return new Short(this.shortValue() * ((Numeric)x).shortValue());
    }

    @Override
    public final Value divide(Value x) {
        if (this.getPriority() < x.getPriority()) {
            return ((Numeric)this.convertTo(x.getType())).divide(x);
        }
        x = x.convertTo(9);
        return new Short(this.shortValue() / ((Numeric)x).shortValue());
    }

    @Override
    public Value modulus(Value x) {
        if (this.getPriority() < x.getPriority()) {
            return ((Numeric)this.convertTo(x.getType())).modulus(x);
        }
        x = x.convertTo(9);
        return new Short(this.shortValue() % ((Numeric)x).shortValue());
    }

    @Override
    public int compareTo(Value x) {
        if (this.getPriority() >= x.getPriority()) {
            return this.shortValue() - ((Numeric)x).shortValue();
        }
        return -((Comparison)((Object)x)).compareTo(this);
    }

    @Override
    public final boolean booleanValue() {
        return this.value != 0;
    }

    @Override
    public final byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public final int intValue() {
        return this.value;
    }

    @Override
    public final long longValue() {
        return this.value;
    }

    @Override
    public final short shortValue() {
        return this.value;
    }

    @Override
    public final float floatValue() {
        return this.value;
    }

    @Override
    public final double doubleValue() {
        return this.value;
    }

    @Override
    public final void assign(boolean value) {
        this.value = value ? (short)1 : 0;
    }

    @Override
    public final void assign(byte value) {
        this.value = value;
    }

    @Override
    public final void assign(int value) {
        this.value = (short)value;
    }

    @Override
    public final void assign(short value) {
        this.value = value;
    }

    @Override
    public final void assign(long value) {
        this.value = (short)value;
    }

    @Override
    public final void assign(float value) {
        this.value = (short)value;
    }

    @Override
    public final void assign(double value) {
        this.value = (short)value;
    }
}

