/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.value;

import fr.gael.drb.value.AbstractNumericArray;
import fr.gael.drb.value.Byte;
import fr.gael.drb.value.Numeric;
import fr.gael.drb.value.NumericArray;
import fr.gael.drb.value.String;
import fr.gael.drb.value.UnsignedByte;
import fr.gael.drb.value.Value;
import fr.gael.drb.value.ValueFormat;

public class UnsignedByteArray
extends AbstractNumericArray
implements ValueFormat {
    static final int PRIORITY = 1;
    private byte[] value;

    public UnsignedByteArray(byte[] src) {
        if (src != null) {
            this.value = new byte[src.length];
            System.arraycopy(src, 0, this.value, 0, src.length);
        } else {
            this.value = new byte[0];
        }
    }

    public UnsignedByteArray(int size) {
        this.value = new byte[size];
    }

    public final byte[] getData() {
        return this.value;
    }

    @Override
    public java.lang.String getFormattedString(int length) {
        java.lang.String str = "";
        for (int i = 0; i < this.length(); ++i) {
            str = str + Byte.getFormattedString(1, this.value[i], false);
        }
        return str;
    }

    @Override
    public byte[] getFormattedBuffer() {
        return this.value;
    }

    @Override
    public final int getType() {
        return 10;
    }

    @Override
    public final int getPriority() {
        return 1;
    }

    @Override
    public final Value convertTo(int type) {
        if (type == 10) {
            return this;
        }
        if (type == 7) {
            return new String(this.toString());
        }
        throw new ClassCastException();
    }

    @Override
    public final void assign(Value value) {
        if (value == null) {
            this.value = new byte[0];
        } else {
            NumericArray b = (NumericArray)value;
            this.value = new byte[b.length()];
            for (int i = 0; i < this.length(); ++i) {
                this.value[i] = b.byteValue(i);
            }
        }
    }

    @Override
    public final int getArrayType() {
        return 12;
    }

    @Override
    public final Value getElement(int index) {
        return new UnsignedByte(this.value[index]);
    }

    @Override
    public final void assign(int index, Value element) {
        element = element.convertTo(9);
        this.value[index] = ((Numeric)element).byteValue();
    }

    @Override
    public final int length() {
        return this.value.length;
    }

    @Override
    public final boolean booleanValue(int index) {
        return this.value[index] != 0;
    }

    @Override
    public final byte byteValue(int index) {
        return this.value[index];
    }

    @Override
    public final int intValue(int index) {
        return this.value[index] & 0xFF;
    }

    @Override
    public final long longValue(int index) {
        return (long)this.value[index] & 0xFFL;
    }

    @Override
    public final short shortValue(int index) {
        return (short)(this.value[index] & 0xFF);
    }

    @Override
    public final float floatValue(int index) {
        return this.value[index] & 0xFF;
    }

    @Override
    public final double doubleValue(int index) {
        return this.value[index] & 0xFF;
    }

    @Override
    public final void assign(int index, boolean value) {
        this.value[index] = (byte)(value ? 1 : 0);
    }

    @Override
    public final void assign(int index, byte value) {
        this.value[index] = value;
    }

    @Override
    public final void assign(int index, int value) {
        this.value[index] = (byte)value;
    }

    @Override
    public final void assign(int index, short value) {
        this.value[index] = (byte)value;
    }

    @Override
    public final void assign(int index, long value) {
        this.value[index] = (byte)value;
    }

    @Override
    public final void assign(int index, float value) {
        this.value[index] = (byte)value;
    }

    @Override
    public final void assign(int index, double value) {
        this.value[index] = (byte)value;
    }

    public java.lang.String toString() {
        StringBuffer strbuf = new StringBuffer(this.value.length * 3);
        for (int i = 0; i < this.value.length; ++i) {
            if (i != 0) {
                strbuf.append(" ");
            }
            strbuf.append(this.value[i] & 0xFF);
        }
        return strbuf.toString();
    }
}

