/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.xsd;

import java.util.HashMap;

public class Namespace
implements Cloneable {
    public static final String XML_SCHEMA_NAMESPACE = "http://www.w3.org/2001/XMLSchema";
    public static final String XML_SCHEMA_INSTANCE = "http://www.w3.org/2001/XMLSchema-instance";
    protected HashMap namespaceMap = new HashMap();
    protected HashMap prefixMap = new HashMap();
    protected String defaultNamespaceURI = null;

    public Namespace cloneNamespace() {
        Namespace namespace = new Namespace();
        namespace.namespaceMap = (HashMap)this.namespaceMap.clone();
        namespace.prefixMap = (HashMap)this.prefixMap.clone();
        namespace.defaultNamespaceURI = this.defaultNamespaceURI;
        return namespace;
    }

    public void addNamespaces(Namespace namespaces) {
        if (namespaces == null) {
            return;
        }
        String[] prefixes = namespaces.getDeclaredPrefixes();
        for (int i = 0; i < prefixes.length; ++i) {
            this.bind(prefixes[i], namespaces.resolveNamespace(prefixes[i]));
        }
    }

    public String resolveNamespace(String ns_prefix) {
        return (String)this.namespaceMap.get(ns_prefix);
    }

    public String resolvePrefix(String ns_full) {
        return (String)this.prefixMap.get(ns_full);
    }

    public void bind(String ns_prefix, String ns_full) {
        this.namespaceMap.put(ns_prefix, ns_full);
        this.prefixMap.put(ns_full, ns_prefix);
    }

    public String createPrefix(String ns_prefix, String ns_full) {
        int count = 1;
        String new_prefix = ns_prefix;
        while (this.resolveNamespace(new_prefix) != null) {
            new_prefix = ns_prefix + count++;
        }
        this.bind(new_prefix, ns_full);
        return new_prefix;
    }

    public void unbind(String ns_prefix) {
        String nsFull = this.resolveNamespace(ns_prefix);
        this.namespaceMap.remove(ns_prefix);
        if (nsFull != null) {
            this.prefixMap.remove(nsFull);
        }
    }

    public String getDefaultNamespaceURI() {
        return this.defaultNamespaceURI;
    }

    public void setDefaultNamespaceURI(String ns_uri) {
        this.defaultNamespaceURI = ns_uri;
    }

    public String[] getDeclaredPrefixes() {
        Object[] array = this.namespaceMap.keySet().toArray();
        String[] prefixes = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            prefixes[i] = array[i].toString();
        }
        return prefixes;
    }

    public static String toPrefix(String qualified_name) {
        char[] str = qualified_name.toCharArray();
        for (int i = 0; i < str.length; ++i) {
            if (str[i] != ':') continue;
            return qualified_name.substring(0, i);
        }
        return null;
    }

    public static String toLocal(String qualified_name) {
        char[] str = qualified_name.toCharArray();
        for (int i = 0; i < str.length; ++i) {
            if (str[i] != ':') continue;
            return qualified_name.substring(i + 1, qualified_name.length());
        }
        return qualified_name;
    }

    public String toString() {
        String string = "";
        for (String currentPrefix : this.prefixMap.values()) {
            string = string + currentPrefix + " -> " + (String)this.namespaceMap.get(currentPrefix) + "\n";
        }
        return string;
    }
}

