/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.xsd;

import fr.gael.drb.DrbDefaultMutableNode;
import fr.gael.drb.impl.xml.XmlWriter;
import fr.gael.drb.value.Boolean;
import fr.gael.drb.value.Byte;
import fr.gael.drb.value.Double;
import fr.gael.drb.value.Float;
import fr.gael.drb.value.Int;
import fr.gael.drb.value.Numeric;
import fr.gael.drb.value.Short;
import fr.gael.drb.value.String;
import fr.gael.drb.value.UnsignedByte;
import fr.gael.drb.value.UnsignedInt;
import fr.gael.drb.value.UnsignedLong;
import fr.gael.drb.value.UnsignedShort;
import fr.gael.drb.value.Value;
import fr.gael.drb.xsd.XmlSchema;
import fr.gael.drb.xsd.XsdFacet;
import fr.gael.drb.xsd.XsdMaxInclusiveFacet;
import fr.gael.drb.xsd.XsdMinInclusiveFacet;
import fr.gael.drb.xsd.XsdPatternFacet;
import fr.gael.drb.xsd.XsdSimpleType;
import fr.gael.drb.xsd.XsdValueSpace;

public class XsdAtomicType
extends XsdSimpleType {
    static final java.lang.String BOOLEAN_TAG = "boolean";
    static final java.lang.String BYTE_TAG = "byte";
    static final java.lang.String UNSIGNED_BYTE_TAG = "unsignedByte";
    static final java.lang.String SHORT_TAG = "short";
    static final java.lang.String UNSIGNED_SHORT_TAG = "unsignedShort";
    static final java.lang.String INT_TAG = "int";
    static final java.lang.String UNSIGNED_INT_TAG = "unsignedInt";
    static final java.lang.String LONG_TAG = "long";
    static final java.lang.String UNSIGNED_LONG_TAG = "unsignedLong";
    static final java.lang.String INTEGER_TAG = "integer";
    static final java.lang.String UNSIGNED_INTEGER_TAG = "unsignedInteger";
    static final java.lang.String NON_NEGATIVE_INTEGER_TAG = "nonNegativeInteger";
    static final java.lang.String POSITIVE_INTEGER_TAG = "positiveInteger";
    static final java.lang.String NON_POSITIVE_INTEGER_TAG = "nonPositiveInteger";
    static final java.lang.String NEGATIVE_INTEGER_TAG = "negativeInteger";
    static final java.lang.String FLOAT_TAG = "float";
    static final java.lang.String DOUBLE_TAG = "double";
    static final java.lang.String DECIMAL_TAG = "decimal";
    static final java.lang.String STRING_TAG = "string";
    static final java.lang.String DATE_TIME_TAG = "dateTime";
    static final java.lang.String DURATION_TAG = "duration";
    static final java.lang.String ANY_URI_TAG = "anyURI";
    static final java.lang.String DATE_TAG = "date";
    protected int primitive;
    private boolean bounded;
    private boolean ordered;
    private int orderRelation;
    private boolean numeric;
    private int cardinality;
    private Value inclusiveLowerBound;
    private Value inclusiveUpperBound;
    private XsdValueSpace valueSpace;

    public XsdAtomicType(int primitive) {
        this.init(primitive);
        this.facets = new XsdFacet[0];
    }

    protected void init(int primitive) {
        this.primitive = primitive;
        this.valueSpace = this;
        switch (primitive) {
            case 0: {
                this.name = BOOLEAN_TAG;
                this.ordered = false;
                this.orderRelation = 0;
                this.bounded = false;
                this.cardinality = 1;
                break;
            }
            case 1: {
                this.name = BYTE_TAG;
                this.ordered = true;
                this.orderRelation = 2;
                this.bounded = true;
                this.numeric = true;
                this.cardinality = 1;
                this.inclusiveLowerBound = new Byte(-128);
                this.inclusiveUpperBound = new Byte(127);
                break;
            }
            case 12: {
                this.name = UNSIGNED_BYTE_TAG;
                this.ordered = true;
                this.orderRelation = 2;
                this.bounded = true;
                this.numeric = true;
                this.cardinality = 1;
                this.inclusiveLowerBound = new UnsignedByte(0);
                this.inclusiveUpperBound = new UnsignedByte(255);
                break;
            }
            case 2: {
                this.name = SHORT_TAG;
                this.ordered = true;
                this.orderRelation = 2;
                this.bounded = true;
                this.numeric = true;
                this.cardinality = 1;
                this.inclusiveLowerBound = new Short((int)java.lang.Short.MIN_VALUE);
                this.inclusiveUpperBound = new Short((int)java.lang.Short.MAX_VALUE);
                break;
            }
            case 13: {
                this.name = UNSIGNED_SHORT_TAG;
                this.ordered = true;
                this.orderRelation = 2;
                this.bounded = true;
                this.numeric = true;
                this.cardinality = 1;
                this.inclusiveLowerBound = new UnsignedShort(0);
                this.inclusiveUpperBound = new UnsignedShort(65535);
                break;
            }
            case 3: {
                this.name = INT_TAG;
                this.ordered = true;
                this.orderRelation = 2;
                this.bounded = true;
                this.numeric = true;
                this.cardinality = 1;
                this.inclusiveLowerBound = new Int(Integer.MIN_VALUE);
                this.inclusiveUpperBound = new Int(Integer.MAX_VALUE);
                break;
            }
            case 14: {
                this.name = UNSIGNED_INT_TAG;
                this.ordered = true;
                this.orderRelation = 2;
                this.bounded = true;
                this.numeric = true;
                this.cardinality = 1;
                this.inclusiveLowerBound = new UnsignedInt(0);
                this.inclusiveUpperBound = new UnsignedInt(-1);
                break;
            }
            case 4: {
                this.name = LONG_TAG;
                this.ordered = true;
                this.orderRelation = 2;
                this.bounded = true;
                this.numeric = true;
                this.cardinality = 1;
                this.inclusiveLowerBound = new fr.gael.drb.value.Long(Long.MIN_VALUE);
                this.inclusiveUpperBound = new fr.gael.drb.value.Long(Long.MAX_VALUE);
                break;
            }
            case 15: {
                this.name = UNSIGNED_LONG_TAG;
                this.ordered = true;
                this.orderRelation = 2;
                this.bounded = true;
                this.numeric = true;
                this.cardinality = 1;
                this.inclusiveLowerBound = new UnsignedLong(0L);
                this.inclusiveUpperBound = new UnsignedLong(-1L);
                break;
            }
            case 27: {
                this.name = INTEGER_TAG;
                this.ordered = true;
                this.orderRelation = 2;
                this.bounded = false;
                this.numeric = true;
                this.cardinality = 2;
                break;
            }
            case 5: {
                this.name = FLOAT_TAG;
                this.ordered = true;
                this.orderRelation = 2;
                this.bounded = true;
                this.numeric = true;
                this.cardinality = 1;
                this.inclusiveLowerBound = new Float(-3.4028235E38f);
                this.inclusiveUpperBound = new Float(java.lang.Float.MAX_VALUE);
                break;
            }
            case 6: {
                this.name = DOUBLE_TAG;
                this.ordered = true;
                this.orderRelation = 2;
                this.bounded = true;
                this.numeric = true;
                this.cardinality = 1;
                this.inclusiveLowerBound = new Double(-1.7976931348623157E308);
                this.inclusiveUpperBound = new Double(java.lang.Double.MAX_VALUE);
                break;
            }
            case 26: {
                this.name = DECIMAL_TAG;
                this.ordered = true;
                this.orderRelation = 2;
                this.bounded = false;
                this.numeric = true;
                this.cardinality = 2;
                break;
            }
            case 7: {
                this.name = STRING_TAG;
                this.ordered = false;
                this.orderRelation = 0;
                this.bounded = false;
                this.numeric = false;
                this.cardinality = 2;
                break;
            }
            case 8: {
                this.name = DATE_TIME_TAG;
                this.ordered = true;
                this.orderRelation = 1;
                this.bounded = false;
                this.numeric = false;
                this.cardinality = 2;
                break;
            }
            case 16: {
                this.name = DURATION_TAG;
                this.ordered = true;
                this.orderRelation = 1;
                this.bounded = false;
                this.numeric = false;
                this.cardinality = 2;
                break;
            }
            case -2: {
                this.name = "anySimpleType";
                this.ordered = false;
                this.orderRelation = 0;
                this.bounded = false;
                this.numeric = false;
                this.cardinality = 2;
            }
        }
    }

    XsdAtomicType(int primitive, XsdFacet[] facets) {
        this(null, primitive, facets);
    }

    XsdAtomicType(java.lang.String name, int primitive, XsdFacet[] facets) {
        this(name, new XsdAtomicType(primitive), facets);
    }

    XsdAtomicType(java.lang.String name, XsdAtomicType base_type, XsdFacet[] facets) {
        if (facets == null) {
            facets = new XsdFacet[]{};
        }
        this.name = name;
        this.primitive = base_type.getTypeId();
        this.facets = facets;
        this.base = base_type;
        this.valueSpace = base_type.valueSpace;
        XsdFacet[] base_facets = base_type.getFacets();
        this.facets = new XsdFacet[facets.length + base_facets.length];
        System.arraycopy(base_facets, 0, this.facets, 0, base_facets.length);
        System.arraycopy(facets, 0, this.facets, base_facets.length, facets.length);
        this.ordered = base_type.isOrdered();
        this.orderRelation = base_type.getOrderRelation();
        this.bounded = base_type.isBounded();
        this.numeric = base_type.isNumeric();
        this.cardinality = base_type.getCardinality();
        this.inclusiveLowerBound = base_type.getInclusiveLowerBound();
        this.inclusiveUpperBound = base_type.getInclusiveUpperBound();
        this.setBase(base_type);
    }

    @Override
    public final int getVariety() {
        return 2;
    }

    @Override
    public int getTypeId() {
        return this.primitive;
    }

    @Override
    public Value getValue(java.lang.String text) {
        return new String(text).convertTo(this.primitive);
    }

    @Override
    public boolean isOrdered() {
        return this.ordered;
    }

    @Override
    public int getOrderRelation() {
        return this.orderRelation;
    }

    @Override
    public boolean isBounded() {
        return this.bounded;
    }

    @Override
    public Value getInclusiveLowerBound() {
        return this.inclusiveLowerBound;
    }

    @Override
    public Value getInclusiveUpperBound() {
        return this.inclusiveUpperBound;
    }

    @Override
    public Value getExclusiveLowerBound() {
        return null;
    }

    @Override
    public Value getExclusiveUpperBound() {
        return null;
    }

    @Override
    public int getCardinality() {
        return this.cardinality;
    }

    @Override
    public boolean isNumeric() {
        return this.numeric;
    }

    @Override
    protected boolean isValidType(Value value) {
        if (value == null) {
            return false;
        }
        int value_type = value.getType();
        if (value_type == this.primitive) {
            return true;
        }
        if (value_type == 10) {
            return false;
        }
        if (value_type == 7) {
            try {
                Value v = null;
                v = this.numeric && this.primitive != 5 && this.primitive != 6 && this.primitive != 26 ? value.convertTo(27) : value.convertTo(this.primitive);
                return true;
            }
            catch (ClassCastException e) {
                return false;
            }
        }
        if (this.numeric) {
            return value instanceof Numeric;
        }
        return false;
    }

    @Override
    public boolean isValid(Value value) {
        if (value != null) {
            try {
                value = value.convertTo(this.primitive);
            }
            catch (ClassCastException e) {
                return false;
            }
        }
        return super.isValid(value);
    }

    public static void main(java.lang.String[] args) {
        Int int_value = new Int(9942);
        DrbDefaultMutableNode int_node = new DrbDefaultMutableNode("toto");
        int_node.setValue(int_value);
        XsdSimpleType int_type = (XsdSimpleType)XmlSchema.getDefaultSchema().getType(INT_TAG);
        System.out.println("Test 1 : ");
        XmlWriter.writeXML(int_type.toNode(), System.out);
        System.out.println("Checking int_value (" + int_value + ") -> " + int_type.isValid(int_node));
        System.out.println("Test 2 : <xsd:simpleType name='myFloat'>");
        System.out.println("           <xsd:restriction base='xsd:float'>");
        System.out.println("             <xsd:minInclusive value='15'/>");
        System.out.println("             <xsd:maxInclusive value='25'/>");
        System.out.println("           </xsd:restriction>");
        System.out.println("         </xsd:simpleType>");
        XsdFacet[] facets = new XsdFacet[]{new XsdMinInclusiveFacet(new Float(15.0f)), new XsdMaxInclusiveFacet(new Float(25.0f))};
        XsdAtomicType atomic = new XsdAtomicType("myFloat", 5, facets);
        Float float_value = new Float(10.0f);
        Float float_value2 = new Float(20.0f);
        Float float_value3 = new Float(30.0f);
        Boolean boolean_value = new Boolean(true);
        System.out.println("Checking float_value (" + float_value + ") -> " + atomic.isValid(float_value));
        System.out.println("Checking float_value2 (" + float_value2 + ") -> " + atomic.isValid(float_value2));
        System.out.println("Checking float_value3 (" + float_value3 + ") -> " + atomic.isValid(float_value3));
        System.out.println("Checking boolean_value (" + boolean_value + ") -> " + atomic.isValid(boolean_value));
        System.out.println("\n\nTest 2 : <xsd:simpleType name='ProductFilename'>");
        System.out.println("           <xsd:restriction base='xsd:string'>");
        System.out.println("             <xsd:pattern value='???_???_???*.N1'/>");
        System.out.println("           </xsd:restriction>");
        System.out.println("         </xsd:simpleType>");
        XsdFacet[] facets2 = new XsdFacet[]{new XsdPatternFacet("..._..._...*\\.N1")};
        XsdAtomicType atomic2 = new XsdAtomicType("ProductFilename", 7, facets2);
        String string_value = new String("toto");
        String string_value2 = new String("MER_FR__1PTACR20000620_104323_00000099X000_00000_00000_0000.N1");
        String string_value3 = new String("MER_FR__1PTACR20000620_104323_00000099X000_00000_00000_0000.N2");
        System.out.println("Checking float_value (" + float_value + ") -> " + atomic2.isValid(float_value));
        System.out.println("Checking string_value (" + string_value + ") -> " + atomic2.isValid(string_value));
        System.out.println("Checking string_value (" + string_value2 + ") -> " + atomic2.isValid(string_value2));
        System.out.println("Checking string_value (" + string_value3 + ") -> " + atomic2.isValid(string_value3));
    }
}

