/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.xsd;

import fr.gael.drb.DrbAttribute;
import fr.gael.drb.DrbAttributeList;
import fr.gael.drb.DrbDefaultAttribute;
import fr.gael.drb.DrbDefaultAttributeList;
import fr.gael.drb.DrbDefaultMutableNode;
import fr.gael.drb.DrbDefaultNodeList;
import fr.gael.drb.DrbNode;
import fr.gael.drb.value.String;
import fr.gael.drb.value.Value;
import fr.gael.drb.xsd.NodeValidator;
import fr.gael.drb.xsd.ValueValidator;
import fr.gael.drb.xsd.XmlSchema;
import fr.gael.drb.xsd.XsdAtomicType;
import fr.gael.drb.xsd.XsdAttribute;
import fr.gael.drb.xsd.XsdAttributeGroup;
import fr.gael.drb.xsd.XsdElement;
import fr.gael.drb.xsd.XsdFacet;
import fr.gael.drb.xsd.XsdInvalid;
import fr.gael.drb.xsd.XsdInvalidAttributeGroup;
import fr.gael.drb.xsd.XsdInvalidComplexType;
import fr.gael.drb.xsd.XsdInvalidSimpleType;
import fr.gael.drb.xsd.XsdListType;
import fr.gael.drb.xsd.XsdModelGroup;
import fr.gael.drb.xsd.XsdName;
import fr.gael.drb.xsd.XsdParticle;
import fr.gael.drb.xsd.XsdSimpleType;
import fr.gael.drb.xsd.XsdType;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class XsdComplexType
extends XsdType
implements NodeValidator,
ValueValidator {
    static final java.lang.String TAG = "complexType";
    static final java.lang.String COMPLEX_CONTENT_TAG = "complexContent";
    static final java.lang.String SIMPLE_CONTENT_TAG = "simpleContent";
    XsdSimpleType simpleContent = null;
    XsdModelGroup complexContent = null;
    XsdAttributeGroup attribute = null;
    private HashMap typeMap = new HashMap();
    private HashMap attributeMap = new HashMap();
    private static Logger logger = Logger.getLogger(XsdComplexType.class);

    public XsdComplexType(java.lang.String name, XsdModelGroup complex_content, XsdType base_type) {
        this(name, null, complex_content, base_type, 1);
    }

    XsdComplexType(java.lang.String name, XsdModelGroup complex_content, XsdType base_type, int derivation_method) {
        this(name, null, complex_content, base_type, derivation_method);
    }

    public XsdComplexType(java.lang.String name, XsdAttributeGroup attrib_group, XsdModelGroup complex_content, XsdType base_type, int derivation_method) {
        super(name, base_type);
        this.derivationMethod = derivation_method;
        if (attrib_group == null) {
            attrib_group = new XsdAttributeGroup(null, new XsdAttribute[0]);
        }
        if (complex_content == null) {
            complex_content = new XsdModelGroup(1, 1, new XsdElement[0], 1);
        }
        if (base_type != null) {
            DrbDefaultNodeList node_list = new DrbDefaultNodeList();
            if (base_type.getExternalNodes() != null) {
                int k;
                for (k = 0; k < base_type.getExternalNodes().getLength(); ++k) {
                    node_list.add(base_type.getExternalNodes().item(k));
                }
                if (this.getExternalNodes() != null) {
                    for (k = 0; k < this.getExternalNodes().getLength(); ++k) {
                        node_list.add(this.getExternalNodes().item(k));
                    }
                }
                this.setExternalNodes(node_list);
            }
        }
        if (base_type != null && base_type.isComplex()) {
            XsdAttributeGroup base_attribs;
            XsdModelGroup base_content = ((XsdComplexType)base_type).getComplexContent();
            if (base_content != null) {
                if (derivation_method == 1) {
                    complex_content = base_content.deriveByExtension(complex_content);
                } else if (derivation_method == 2) {
                    complex_content = base_content.deriveByRestriction(complex_content);
                }
            }
            if ((base_attribs = ((XsdComplexType)base_type).getAttributeGroup()) != null) {
                attrib_group = base_attribs.deriveByExtension(attrib_group);
            }
        }
        if (base_type != null) {
            this.simpleContent = base_type.getDatatype();
        }
        this.complexContent = complex_content;
        this.mapType(complex_content);
        this.attribute = attrib_group;
        this.mapAttribute(attrib_group);
    }

    XsdComplexType(java.lang.String name, XsdAttributeGroup attrib_group, XsdFacet[] facets, XsdType base_type, int derivation_method) {
        super(name, base_type);
        this.derivationMethod = derivation_method;
        if (attrib_group == null) {
            attrib_group = new XsdAttributeGroup(null, new XsdAttribute[0]);
        }
        if (facets == null) {
            facets = new XsdFacet[]{};
        }
        if (base_type != null) {
            DrbDefaultNodeList node_list = new DrbDefaultNodeList();
            if (base_type.getExternalNodes() != null) {
                int k;
                for (k = 0; k < base_type.getExternalNodes().getLength(); ++k) {
                    node_list.add(base_type.getExternalNodes().item(k));
                }
                if (this.getExternalNodes() != null) {
                    for (k = 0; k < this.getExternalNodes().getLength(); ++k) {
                        node_list.add(this.getExternalNodes().item(k));
                    }
                }
                this.setExternalNodes(node_list);
            }
        }
        if (base_type != null && base_type.getDatatype() != null) {
            this.simpleContent = base_type.getDatatype();
            switch (this.simpleContent.getVariety()) {
                case 2: {
                    this.simpleContent = new XsdAtomicType(null, this.simpleContent.getTypeId(), facets);
                    break;
                }
                case 3: {
                    this.simpleContent = new XsdListType(null, ((XsdListType)this.simpleContent).getItemType(), facets);
                }
            }
        }
        if (base_type != null && base_type.isComplex()) {
            this.complexContent = ((XsdComplexType)base_type).getComplexContent();
            XsdAttributeGroup base_attribs = ((XsdComplexType)base_type).getAttributeGroup();
            if (base_attribs != null) {
                attrib_group = base_attribs.deriveByExtension(attrib_group);
            }
        }
        this.attribute = attrib_group;
        this.mapAttribute(attrib_group);
    }

    private void mapType(XsdModelGroup model_group) {
        XsdParticle[] particles = model_group.getContent();
        if (particles != null) {
            block4: for (int i = 0; i < particles.length; ++i) {
                switch (particles[i].getTerm()) {
                    case 2: {
                        XsdElement elt = (XsdElement)particles[i];
                        this.typeMap.put(elt.getName(), elt.getType());
                        continue block4;
                    }
                    case 1: {
                        this.mapType((XsdModelGroup)particles[i]);
                    }
                }
            }
        }
    }

    private void mapAttribute(XsdAttributeGroup attrib_group) {
        XsdAttribute[] attributes = attrib_group.getContent();
        if (attributes != null) {
            for (int i = 0; i < attributes.length; ++i) {
                XsdAttribute attrib = attributes[i];
                if (attrib == null || attrib.getName() == null) continue;
                this.attributeMap.put(new XsdName(attrib.getName(), attrib.getTargetNamespace()), attrib);
            }
        }
        XsdAttribute xsi_nil = new XsdAttribute("nil", new XsdAtomicType(0), null, 1);
        xsi_nil.setTargetNamespace("http://www.w3.org/2001/XMLSchema-instance");
        this.attributeMap.put(new XsdName(xsi_nil.getName(), xsi_nil.getTargetNamespace()), xsi_nil);
        XsdAttribute xsi_type = new XsdAttribute("type", new XsdAtomicType(7), null, 1);
        xsi_type.setTargetNamespace("http://www.w3.org/2001/XMLSchema-instance");
        this.attributeMap.put(new XsdName(xsi_type.getName(), xsi_type.getTargetNamespace()), xsi_type);
        XsdAttribute xsi_schemaLocation = new XsdAttribute("schemaLocation", new XsdListType(null, new XsdAtomicType("anyURI", 7, null), null), null, 1);
        xsi_schemaLocation.setTargetNamespace("http://www.w3.org/2001/XMLSchema-instance");
        this.attributeMap.put(new XsdName(xsi_schemaLocation.getName(), xsi_schemaLocation.getTargetNamespace()), xsi_schemaLocation);
        XsdAttribute xsi_noNamespace = new XsdAttribute("noNamespaceSchemaLocation", new XsdAtomicType("anyURI", 7, null), null, 1);
        xsi_noNamespace.setTargetNamespace("http://www.w3.org/2001/XMLSchema-instance");
        this.attributeMap.put(new XsdName(xsi_noNamespace.getName(), xsi_noNamespace.getTargetNamespace()), xsi_noNamespace);
    }

    XsdType getElementType(java.lang.String element_name) {
        return (XsdType)this.typeMap.get(element_name);
    }

    XsdAttribute getAttribute(java.lang.String attrib_name) {
        return (XsdAttribute)this.attributeMap.get(attrib_name);
    }

    XsdAttribute getAttribute(XsdName attrib_name) {
        return (XsdAttribute)this.attributeMap.get(attrib_name);
    }

    public XsdAttributeGroup getAttributeGroup() {
        return this.attribute;
    }

    void setAttributeGroup(XsdAttributeGroup attrib_group) {
        this.attributeMap = new HashMap();
        if (attrib_group == null) {
            attrib_group = new XsdAttributeGroup(null, new XsdAttribute[0]);
        }
        this.attribute = attrib_group;
        this.mapAttribute(attrib_group);
    }

    public XsdModelGroup getComplexContent() {
        return this.complexContent;
    }

    void setSimpleContent(XsdSimpleType simple_content) {
        this.simpleContent = simple_content;
    }

    void setComplexContent(XsdModelGroup complex_content) {
        if (complex_content == null) {
            complex_content = new XsdModelGroup(0, 0, new XsdElement[0], 1);
        }
        this.complexContent = complex_content;
        this.mapType(complex_content);
    }

    @Override
    DrbNode toNode() {
        DrbNode complex_node;
        DrbDefaultMutableNode type_node = new DrbDefaultMutableNode(TAG);
        type_node.setNamespaceURI("http://www.w3.org/2001/XMLSchema");
        DrbDefaultAttributeList attributes = new DrbDefaultAttributeList();
        if (this.schema != null && this.getName() != null) {
            attributes.add(new DrbDefaultAttribute("name", (Value)new String(this.getName()), type_node));
        }
        type_node.setAttributes(attributes);
        DrbDefaultMutableNode content_node = type_node;
        if (this.getBase() != null && !"anyType".equals(this.getBase().getName())) {
            java.lang.String prefix;
            java.lang.String base_local_name;
            content_node = new DrbDefaultMutableNode(COMPLEX_CONTENT_TAG);
            DrbDefaultMutableNode derivation_node = null;
            derivation_node = this.derivationMethod == 1 ? new DrbDefaultMutableNode("extension") : new DrbDefaultMutableNode("restriction");
            DrbDefaultAttributeList derivation_attributes = new DrbDefaultAttributeList();
            java.lang.String base_name = base_local_name = this.getBase().getName();
            XmlSchema base_schema = this.getBase().schema;
            if (base_schema != null && base_schema.namespaces != null && (prefix = this.schema.namespaces.resolvePrefix(this.getBase().getTargetNamespace())) != null) {
                base_name = prefix + ":" + base_local_name;
            }
            derivation_attributes.add(new DrbDefaultAttribute("base", (Value)new String(base_name), type_node));
            derivation_node.setAttributes(derivation_attributes);
        }
        if (this.complexContent != null && this.complexContent.getLength() > 0 && (complex_node = this.complexContent.toNode()) != null) {
            content_node.appendChild(complex_node);
        }
        return type_node;
    }

    @Override
    public final boolean isComplex() {
        return true;
    }

    @Override
    public final XsdSimpleType getDatatype() {
        return this.simpleContent;
    }

    @Override
    public final XsdComplexType getStructure() {
        return this;
    }

    @Override
    public boolean isValid(Value value) {
        if (this.getDatatype() != null) {
            return this.getDatatype().isValid(value);
        }
        return value == null;
    }

    @Override
    public XsdInvalid isValid(DrbNode node) {
        XsdInvalidComplexType invalid = new XsdInvalidComplexType(node, this);
        if (node == null) {
            return invalid;
        }
        if (this.getDatatype() != null) {
            XsdInvalid invalid_data = this.getDatatype().isValid(node);
            invalid.setSimpleContent(invalid_data);
            if (invalid_data != null) {
                return invalid_data;
            }
        } else {
            Value value = null;
            if (node.getValueType() != -1 && (value = node.getValue()) != null) {
                invalid.setSimpleContent(new XsdInvalidSimpleType(node, null, value));
                return invalid;
            }
        }
        DrbAttributeList attrib_list = node.getAttributes();
        XsdAttribute attrib_decl = null;
        HashMap<java.lang.String, DrbAttribute> attrib_map = new HashMap<java.lang.String, DrbAttribute>();
        if (attrib_list != null) {
            int i;
            XsdInvalid invalid_attrib_value = null;
            for (i = 0; i < attrib_list.getLength(); ++i) {
                DrbAttribute node_attrib = attrib_list.item(i);
                attrib_decl = null;
                if (node_attrib == null || node_attrib.getName() == null) break;
                java.lang.String attrib_uri = node_attrib.getNamespaceURI();
                if (attrib_uri == null) {
                    attrib_uri = node.getNamespaceURI();
                }
                if ((attrib_decl = this.getAttribute(new XsdName(node_attrib.getName(), attrib_uri))) == null) {
                    if (!"http://www.gael.fr/2005/04/drb/sdf".equals(attrib_uri) && !"http://www.gael.fr/2004/12/drb/sdf".equals(attrib_uri) && !"http://www.gael.fr/drb/impl/sdf-20020222".equals(attrib_uri)) break;
                    continue;
                }
                if (attrib_decl.getUse() == 3) break;
                XsdSimpleType attrib_type = attrib_decl.getType();
                if (attrib_type != null) {
                    DrbDefaultMutableNode attrib_node = new DrbDefaultMutableNode(node_attrib.getName());
                    attrib_node.setValue(node_attrib.getValue());
                    invalid_attrib_value = attrib_type.isValid(attrib_node);
                    if (invalid_attrib_value != null) break;
                }
                attrib_map.put(node_attrib.getName(), node_attrib);
            }
            if (i < attrib_list.getLength()) {
                XsdInvalidAttributeGroup invalid_attrib = new XsdInvalidAttributeGroup(attrib_list, attrib_decl, i);
                invalid_attrib.setSimpleType(invalid_attrib_value);
                invalid.setAttributeGroup(invalid_attrib);
                return invalid;
            }
        }
        attrib_decl = null;
        for (int k = 0; k < this.getAttributeGroup().getContent().length && ((attrib_decl = this.getAttributeGroup().getContent()[k]).getUse() != 2 || attrib_map.get(attrib_decl.getName()) != null); ++k) {
            attrib_decl = null;
        }
        if (attrib_decl != null) {
            invalid.setAttributeGroup(new XsdInvalidAttributeGroup(attrib_list, attrib_decl, attrib_list == null ? 0 : attrib_list.getLength()));
            return invalid;
        }
        XsdModelGroup content = this.getComplexContent();
        if (content == null) {
            return node.hasChild() ? invalid : null;
        }
        XsdInvalid invalid_content = content.isValid(node.getChildren());
        if (invalid_content != null) {
            invalid.setComplexContent(invalid_content);
            return invalid;
        }
        return null;
    }

    public static void main(java.lang.String[] args) {
        XsdAtomicType float_type = new XsdAtomicType(5, null);
        XsdListType list_type = new XsdListType(float_type, null);
        XsdElement x_elt = new XsdElement(1, 1, "x", float_type);
        XsdElement y_elt = new XsdElement(1, 1, "y", float_type);
        XsdElement z_elt = new XsdElement(1, 1, "z", list_type);
        XsdModelGroup group = new XsdModelGroup(1, 1, new XsdParticle[]{x_elt, y_elt, z_elt}, 1);
        logger.error("Derivation by extention");
        XsdComplexType point_type = new XsdComplexType("point", group, null);
        System.out.println(point_type.getElementType("z").toNode());
    }
}

