/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.xsd;

import fr.gael.drb.DrbAbstractNode;
import fr.gael.drb.DrbAttribute;
import fr.gael.drb.DrbAttributeList;
import fr.gael.drb.DrbDefaultAttributeList;
import fr.gael.drb.DrbDefaultNodeList;
import fr.gael.drb.DrbFactory;
import fr.gael.drb.DrbNode;
import fr.gael.drb.DrbNodeList;
import fr.gael.drb.DrbSequence;
import fr.gael.drb.DrbSimpleNode;
import fr.gael.drb.impl.xml.XmlFactory;
import fr.gael.drb.query.Query;
import fr.gael.drb.value.Value;
import fr.gael.drb.xsd.Namespace;
import fr.gael.drb.xsd.XmlSchema;
import fr.gael.drb.xsd.XsdAnnotation;
import fr.gael.drb.xsd.XsdAppinfo;
import fr.gael.drb.xsd.XsdAtomicType;
import fr.gael.drb.xsd.XsdAttribute;
import fr.gael.drb.xsd.XsdAttributeGroup;
import fr.gael.drb.xsd.XsdComplexType;
import fr.gael.drb.xsd.XsdComponent;
import fr.gael.drb.xsd.XsdDocumentation;
import fr.gael.drb.xsd.XsdElement;
import fr.gael.drb.xsd.XsdEnumerationFacet;
import fr.gael.drb.xsd.XsdFacet;
import fr.gael.drb.xsd.XsdFractionDigitsFacet;
import fr.gael.drb.xsd.XsdLengthFacet;
import fr.gael.drb.xsd.XsdListType;
import fr.gael.drb.xsd.XsdMaxExclusiveFacet;
import fr.gael.drb.xsd.XsdMaxInclusiveFacet;
import fr.gael.drb.xsd.XsdMaxLengthFacet;
import fr.gael.drb.xsd.XsdMinExclusiveFacet;
import fr.gael.drb.xsd.XsdMinInclusiveFacet;
import fr.gael.drb.xsd.XsdMinLengthFacet;
import fr.gael.drb.xsd.XsdModelGroup;
import fr.gael.drb.xsd.XsdName;
import fr.gael.drb.xsd.XsdParticle;
import fr.gael.drb.xsd.XsdPatternFacet;
import fr.gael.drb.xsd.XsdSimpleType;
import fr.gael.drb.xsd.XsdTotalDigitsFacet;
import fr.gael.drb.xsd.XsdType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class XsdFactory {
    private static Logger logger = Logger.getLogger(XsdFactory.class);
    Context context;

    private void init(XmlSchema base_schema) {
        this.context = new Context(base_schema);
    }

    private XsdType resolveType(String qname) {
        if (qname == null) {
            return null;
        }
        String local_name = Namespace.toLocal(qname);
        XsdType type = (XsdType)this.context.globalTypeMap.get(local_name);
        if (type == null) {
            DrbNode type_node = (DrbNode)this.context.unresolvedTypeMap.get(local_name);
            if (type_node == null) {
                logger.error("XsdFactory.resolveType : Type '" + local_name + " unknown !");
                return null;
            }
            if ("complexType".equals(type_node.getName())) {
                type = new XsdComplexType(local_name, null, null);
                this.context.globalTypeMap.put(local_name, type);
                type = this.loadComplexType((XsdComplexType)type, type_node);
            } else if ("simpleType".equals(type_node.getName())) {
                type = this.loadSimpleType(type_node);
            } else {
                logger.error("XsdFactory.resolveType : Type '" + local_name + " unresolved !");
                return null;
            }
            this.context.unresolvedTypeMap.remove(local_name);
            if (type == null) {
                logger.error("XsdFactory.resolveType ->  '" + qname + "' null type");
            } else {
                this.context.globalTypeMap.put(type.getName(), type);
                type.setTargetNamespace(this.context.targetNamespace);
            }
        }
        return type;
    }

    private XsdAttribute resolveAttribute(String qname) {
        String local_name = Namespace.toLocal(qname);
        String prefix_name = Namespace.toPrefix(qname);
        String uri = this.context.namespaces.resolveNamespace(prefix_name);
        XsdName xs_name = new XsdName(local_name, uri);
        XsdAttribute attribute_decl = (XsdAttribute)this.context.globalAttributeMap.get(local_name);
        if (attribute_decl == null) {
            DrbNode attrib_node = (DrbNode)this.context.unresolvedAttributeMap.get(local_name);
            if (attrib_node == null) {
                logger.error("XsdFactory.resolveAttribute : Attribute '" + local_name + " unknown !");
                return null;
            }
            if (!"attribute".equals(attrib_node.getName())) {
                logger.error("XsdFactory.resolveAttribute : Attribute '" + local_name + " unresolved !");
                return null;
            }
            attribute_decl = this.loadAttribute(attrib_node);
            this.context.unresolvedAttributeMap.remove(local_name);
            if (attribute_decl == null) {
                logger.error("XsdFactory.resolveAttribute ->  '" + qname + "' null attribute");
            } else {
                this.context.globalAttributeMap.put(attribute_decl.getName(), attribute_decl);
                attribute_decl.setTargetNamespace(this.context.targetNamespace);
            }
        }
        return attribute_decl;
    }

    private XsdElement resolveElement(String qname) {
        String prefix_name;
        String uri;
        String local_name = Namespace.toLocal(qname);
        XsdName xs_name = new XsdName(local_name, uri = this.context.namespaces.resolveNamespace(prefix_name = Namespace.toPrefix(qname)));
        XsdElement element_decl = (XsdElement)this.context.globalElementMap.get(xs_name);
        if (element_decl == null) {
            DrbNode element_node = (DrbNode)this.context.unresolvedElementMap.get(xs_name);
            if (element_node == null) {
                if (!"http://www.w3.org/2001/XMLSchema".equals(uri)) {
                    logger.error("XsdFactory.resolveElement : Element '" + qname + " unknown !");
                }
                return null;
            }
            if (!"element".equals(element_node.getName())) {
                logger.error("XsdFactory.resolveElement : Element '" + local_name + " unresolved !");
                return null;
            }
            element_decl = this.loadElement(element_node);
            this.context.unresolvedElementMap.remove(local_name);
            if (element_decl == null) {
                logger.error("XsdFactory.resolveElement ->  '" + qname + "' null element");
            } else {
                this.context.globalElementMap.put(element_decl.getName(), element_decl);
                element_decl.setTargetNamespace(this.context.targetNamespace);
            }
        }
        return element_decl;
    }

    private void preloadSchema(Context context, DrbNode base, DrbNode schema_file) {
        DrbNode include_node;
        String attributeName;
        DrbAttribute attribute;
        int i;
        DrbAttributeList attribs;
        String type_name;
        DrbNode type_node;
        if (schema_file == null) {
            logger.error("Cannot preload XML Schema from a null node.", new NullPointerException());
            return;
        }
        DrbNode schema = schema_file.getFirstChild();
        if (!"schema".equals(schema.getName()) && !"schema".equals((schema = schema_file).getName())) {
            logger.error("XsdFactory.preloadSchema : '" + schema.getName() + "' is not a valid schema.");
            return;
        }
        int ioccurs = 1;
        while (true) {
            type_node = schema.getNamedChild("complexType", ioccurs);
            type_name = null;
            if (type_node == null) break;
            attribs = type_node.getAttributes();
            for (i = 0; i < attribs.getLength(); ++i) {
                attribute = attribs.item(i);
                attributeName = attribute.getName();
                if (!"name".equals(attributeName)) continue;
                type_name = attribute.getValue().toString();
                break;
            }
            if (type_name != null) {
                context.unresolvedTypeMap.put(Namespace.toLocal(type_name), type_node);
            }
            ++ioccurs;
        }
        ioccurs = 1;
        while (true) {
            type_node = schema.getNamedChild("simpleType", ioccurs);
            type_name = null;
            if (type_node == null) break;
            attribs = type_node.getAttributes();
            for (i = 0; i < attribs.getLength(); ++i) {
                attribute = attribs.item(i);
                attributeName = attribute.getName();
                if (!"name".equals(attributeName)) continue;
                type_name = attribute.getValue().toString();
                break;
            }
            if (type_name != null) {
                context.unresolvedTypeMap.put(Namespace.toLocal(type_name), type_node);
            }
            ++ioccurs;
        }
        ioccurs = 1;
        while (true) {
            DrbNode attrib_node = schema.getNamedChild("attribute", ioccurs);
            String attrib_ref = null;
            if (attrib_node == null) break;
            attribs = attrib_node.getAttributes();
            for (int i2 = 0; i2 < attribs.getLength(); ++i2) {
                attribute = attribs.item(i2);
                attributeName = attribute.getName();
                if (!"name".equals(attributeName)) continue;
                attrib_ref = attribute.getValue().toString();
                break;
            }
            if (attrib_ref != null) {
                String ref_prefix = Namespace.toPrefix(attrib_ref);
                String ref_uri = context.namespaces.resolveNamespace(ref_prefix);
                context.unresolvedAttributeMap.put(new XsdName(ref_prefix, ref_uri), attrib_node);
            }
            ++ioccurs;
        }
        ioccurs = 1;
        while (true) {
            DrbNode element_node = schema.getNamedChild("element", ioccurs);
            String element_name = null;
            if (element_node == null) break;
            attribs = element_node.getAttributes();
            for (int i3 = 0; i3 < attribs.getLength(); ++i3) {
                attribute = attribs.item(i3);
                attributeName = attribute.getName();
                if (!"name".equals(attributeName)) continue;
                element_name = attribute.getValue().toString();
                break;
            }
            if (element_name != null) {
                context.unresolvedElementMap.put(new XsdName(element_name, context.targetNamespace), element_node);
            }
            ++ioccurs;
        }
        ioccurs = 1;
        while ((include_node = schema.getNamedChild("include", ioccurs)) != null) {
            this.preloadInclude(context, base, include_node);
            ++ioccurs;
        }
        ioccurs = 1;
        while ((include_node = schema.getNamedChild("import", ioccurs)) != null) {
            this.preloadInclude(context, base, include_node);
            ++ioccurs;
        }
    }

    private void preloadInclude(Context context, DrbNode base, DrbNode include_node) {
        String schema_location = null;
        DrbAttributeList attribs = include_node.getAttributes();
        for (int i = 0; i < attribs.getLength(); ++i) {
            DrbAttribute attribute = attribs.item(i);
            String attributeName = attribute.getName();
            if (!"schemaLocation".equals(attributeName)) continue;
            schema_location = attribute.getValue().toString();
        }
        if (schema_location != null) {
            DrbSimpleNode include_schema_base = null;
            Query schema_query = new Query(schema_location);
            DrbSequence schema_result = schema_query.evaluate(base);
            if (schema_result != null && schema_result.getLength() > 0) {
                include_schema_base = (DrbNode)schema_result.getItem(0);
            }
            if (include_schema_base != null) {
                String include_path = include_schema_base.getPath();
                if (!context.includeSet.contains(include_path)) {
                    DrbNode include_schema = include_schema_base.getFirstChild();
                    if (logger.isDebugEnabled()) {
                        logger.debug("Preloading XML Schema from \"" + include_path + "\", included from \"" + base.getPath() + "\"...");
                    }
                    this.preloadSchema(context, include_schema_base.getParent(), include_schema);
                    context.includeSet.add(include_path);
                }
            } else {
                logger.error("XsdFactory.preloadInclude:  cannot include '" + schema_location + "'.");
            }
        }
    }

    private XmlSchema loadSchema(DrbNode schema_file) {
        String targetNamespace = null;
        XmlSchema xmlschema = null;
        XsdElement[] root_elt = null;
        XsdType[] global_type = null;
        XsdAnnotation annotation = null;
        DrbDefaultNodeList extNodes = new DrbDefaultNodeList();
        DrbDefaultAttributeList extAttributes = new DrbDefaultAttributeList();
        ArrayList<XsdType> type_list = new ArrayList<XsdType>();
        ArrayList<XsdElement> elt_list = new ArrayList<XsdElement>();
        HashMap<String, String> namespaceMap = new HashMap<String, String>();
        try {
            XsdType type;
            DrbAttributeList schema_attributes;
            DrbNode schema = schema_file.getFirstChild();
            if (!"schema".equals(schema.getName())) {
                logger.error("'" + schema.getName() + "' is not a valid schema.");
                return null;
            }
            if (schema instanceof DrbAbstractNode) {
                this.context.namespaces.addNamespaces(((DrbAbstractNode)schema).getNamespaceBindings());
            }
            if ((schema_attributes = schema.getAttributes()) != null) {
                for (int i = 0; i < schema_attributes.getLength(); ++i) {
                    Value value;
                    DrbAttribute attrib = schema_attributes.item(i);
                    if (attrib == null) continue;
                    String name = attrib.getName();
                    String namespace = attrib.getName();
                    if (name == null) continue;
                    if ("targetNamespace".equals(name)) {
                        value = attrib.getValue();
                        if (value == null) continue;
                        this.context.targetNamespace = value.toString();
                        continue;
                    }
                    value = attrib.getValue();
                    if (value == null) continue;
                    namespaceMap.put(name, value.toString());
                }
            }
            targetNamespace = this.context.targetNamespace;
            DrbNodeList children = schema.getChildren();
            if (children != null) {
                for (int i = 0; i < children.getLength(); ++i) {
                    DrbNode node = children.item(i);
                    String nodeName = Namespace.toLocal(node.getName());
                    if ("annotation".equals(nodeName)) {
                        annotation = this.loadAnnotation(node, extNodes);
                        continue;
                    }
                    if ("element".equals(nodeName)) {
                        XsdElement elt = this.loadElement(node);
                        if (elt == null) continue;
                        elt_list.add(elt);
                        elt.setTargetNamespace(targetNamespace);
                        continue;
                    }
                    if ("complexType".equals(nodeName) && this.context.unresolvedTypeMap.containsValue(node)) {
                        type = this.loadComplexType(null, node);
                        if (type == null) continue;
                        type_list.add(type);
                        this.context.globalTypeMap.put(type.getName(), type);
                        type.setTargetNamespace(targetNamespace);
                        continue;
                    }
                    if ("simpleType".equals(nodeName)) {
                        type = this.loadSimpleType(node);
                        if (type == null) continue;
                        type_list.add(type);
                        this.context.globalTypeMap.put(type.getName(), type);
                        type.setTargetNamespace(targetNamespace);
                        continue;
                    }
                    extNodes.add(node);
                }
            }
            Object[] unresolved_types = this.context.unresolvedTypeMap.keySet().toArray();
            for (int i = 0; i < unresolved_types.length; ++i) {
                String type_name = unresolved_types[i].toString();
                if (this.context.unresolvedTypeMap.get(type_name) == null || (type = this.resolveType(type_name)) == null) continue;
                type_list.add(type);
            }
            root_elt = new XsdElement[elt_list.size()];
            elt_list.toArray(root_elt);
            global_type = new XsdType[this.context.globalTypeMap.values().size()];
            this.context.globalTypeMap.values().toArray(global_type);
            xmlschema = new XmlSchema(root_elt, global_type, this.context.namespaces);
            xmlschema.setAnnotation(annotation);
            xmlschema.setExternalNodes(extNodes);
            xmlschema.setTargetNamespace(targetNamespace);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            return null;
        }
        return xmlschema;
    }

    private XsdAnnotation loadAnnotation(DrbNode base_node) {
        ArrayList<XsdAppinfo> appinfo_list = new ArrayList<XsdAppinfo>();
        ArrayList<XsdDocumentation> doc_list = new ArrayList<XsdDocumentation>();
        DrbNodeList children = base_node.getChildren();
        if (children != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                DrbAbstractNode node = (DrbAbstractNode)children.item(i);
                if (node == null) continue;
                String node_name = node.getName();
                if ("documentation".equals(node_name)) {
                    doc_list.add(new XsdDocumentation(node.getContent()));
                    continue;
                }
                if (!"appinfo".equals(node_name)) continue;
                appinfo_list.add(new XsdAppinfo(node.getContent()));
            }
        }
        XsdAppinfo[] appinfo = new XsdAppinfo[appinfo_list.size()];
        appinfo_list.toArray(appinfo);
        XsdDocumentation[] doc = new XsdDocumentation[doc_list.size()];
        doc_list.toArray(doc);
        return new XsdAnnotation(appinfo, doc);
    }

    private XsdAnnotation loadAnnotation(DrbNode base_node, ArrayList external_children) {
        XsdAnnotation annotation = this.loadAnnotation(base_node);
        if (!"http://www.w3.org/2001/XMLSchema".equals(this.context.targetNamespace)) {
            external_children.add(base_node);
        }
        XsdAppinfo[] appinfos = annotation.getAppinfos();
        for (int iapp = 0; iapp < appinfos.length; ++iapp) {
            if (appinfos[iapp].getContent() == null) continue;
            DrbSequence appinfo_content = appinfos[iapp].getContent();
            for (int i = 0; i < appinfo_content.getLength(); ++i) {
                if (!(appinfo_content.getItem(i) instanceof DrbNode)) continue;
                external_children.add(appinfo_content.getItem(i));
            }
        }
        return annotation;
    }

    private XsdElement loadElement(DrbNode element_node) {
        DrbNodeList children;
        XsdElement ref = null;
        XsdElement element = null;
        XsdType type = null;
        XsdAnnotation annotation = null;
        int min_occurs = 1;
        int max_occurs = 1;
        String name = null;
        String namespaceURI = this.context.targetNamespace;
        Value value = null;
        int constraint = 0;
        DrbDefaultNodeList externalChildren = new DrbDefaultNodeList();
        DrbDefaultAttributeList externalAttributes = new DrbDefaultAttributeList();
        DrbAttributeList attributes = element_node.getAttributes();
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                DrbAttribute attribute = attributes.item(i);
                String attributeName = Namespace.toLocal(attribute.getName());
                if (attributeName.equals("name")) {
                    name = attribute.getValue().toString();
                    continue;
                }
                if (attributeName.equals("type")) {
                    String typename = attribute.getValue().toString();
                    type = this.resolveType(typename);
                    continue;
                }
                if (attributeName.equals("minOccurs")) {
                    min_occurs = Integer.parseInt(attribute.getValue().toString());
                    continue;
                }
                if (attributeName.equals("maxOccurs")) {
                    String attributeValue = attribute.getValue().toString();
                    if (attributeValue.equals("unbounded")) {
                        max_occurs = XsdElement.UNBOUNDED_OCCURS;
                        continue;
                    }
                    max_occurs = Integer.parseInt(attributeValue);
                    continue;
                }
                if (attributeName.equals("default")) {
                    value = attribute.getValue();
                    constraint = 0;
                    continue;
                }
                if (attributeName.equals("fixed")) {
                    value = attribute.getValue();
                    constraint = 1;
                    continue;
                }
                if (attributeName.equals("ref")) {
                    String ref_qname = attribute.getValue().toString();
                    ref = this.resolveElement(ref_qname);
                    continue;
                }
                externalAttributes.add(attribute);
            }
        }
        if ((children = element_node.getChildren()) != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                DrbNode node = children.item(i);
                String nodeName = Namespace.toLocal(node.getName());
                if (nodeName.equals("annotation")) {
                    annotation = this.loadAnnotation(node, externalChildren);
                    continue;
                }
                if (nodeName.equals("complexType")) {
                    type = this.loadComplexType(null, node);
                    continue;
                }
                if (nodeName.equals("simpleType")) {
                    type = this.loadSimpleType(node);
                    continue;
                }
                externalChildren.add(node);
            }
        }
        if (max_occurs < min_occurs) {
            max_occurs = min_occurs;
        }
        if (ref != null) {
            name = ref.getName();
            namespaceURI = ref.getTargetNamespace();
            type = ref.getType();
            if (value == null) {
                value = ref.getValue();
                constraint = ref.getConstraint();
            }
            if (annotation == null) {
                annotation = ref.getAnnotation();
            }
            for (int i = 0; i < ref.getExternalNodes().getLength(); ++i) {
                externalChildren.add(ref.getExternalNodes().item(i));
            }
        }
        element = new XsdElement(min_occurs, max_occurs, name, type);
        element.setValueConstraint(value, constraint);
        element.setAnnotation(annotation);
        element.setExternalNodes(externalChildren);
        element.setExternalAttributes(externalAttributes);
        element.setTargetNamespace(namespaceURI);
        return element;
    }

    private XsdAttribute loadAttribute(DrbNode attribute_node) {
        DrbNodeList children;
        XsdSimpleType type = null;
        XsdAnnotation annotation = null;
        Value value = null;
        String name = null;
        int use = -1;
        XsdAttribute ref = null;
        DrbDefaultNodeList externalChildren = new DrbDefaultNodeList();
        DrbAttributeList attributes = attribute_node.getAttributes();
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                DrbAttribute attribute = attributes.item(i);
                String attributeName = Namespace.toLocal(attribute.getName());
                if (attributeName.equals("name")) {
                    name = attribute.getValue().toString();
                    continue;
                }
                if (attributeName.equals("ref")) {
                    String refname = attribute.getValue().toString();
                    ref = this.resolveAttribute(refname);
                    continue;
                }
                if (attributeName.equals("type")) {
                    String typename = attribute.getValue().toString();
                    type = (XsdSimpleType)this.resolveType(typename);
                    continue;
                }
                if (attributeName.equals("use")) {
                    String useName = attribute.getValue().toString();
                    if (useName.equals("optional")) {
                        use = 1;
                        continue;
                    }
                    if (useName.equals("prohibited")) {
                        use = 3;
                        continue;
                    }
                    if (useName.equals("required")) {
                        use = 2;
                        continue;
                    }
                    logger.warn("XsdFactory:loadAttribute : unknown use :" + useName);
                    continue;
                }
                if (attributeName.equals("fixed")) {
                    value = attribute.getValue();
                    continue;
                }
                if (attributeName.equals("default")) {
                    value = attribute.getValue();
                    use = 1;
                    continue;
                }
                logger.warn("XsdFactory:loadAttribute : unknown attribute : " + attributeName);
            }
        }
        if ((children = attribute_node.getChildren()) != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                DrbNode node = children.item(i);
                String nodeName = Namespace.toLocal(node.getName());
                if (nodeName.equals("annotation")) {
                    annotation = this.loadAnnotation(node, externalChildren);
                    continue;
                }
                if (nodeName.equals("simpleType")) {
                    type = this.loadSimpleType(node);
                    continue;
                }
                externalChildren.add(node);
            }
        }
        if (value != null && type != null) {
            value = value.convertTo(type.getTypeId());
        }
        if (ref != null) {
            name = ref.getName();
            type = ref.getType();
            if (value == null) {
                value = ref.getValueConstraint();
            }
            if (use == -1) {
                use = ref.getUse();
            }
            if (annotation == null) {
                annotation = ref.getAnnotation();
            }
            for (int i = 0; i < ref.getExternalNodes().getLength(); ++i) {
                externalChildren.add(ref.getExternalNodes().item(i));
            }
        }
        if (use == -1) {
            use = 1;
        }
        XsdAttribute attribute_decl = null;
        attribute_decl = new XsdAttribute(name, type, value, use);
        attribute_decl.setAnnotation(annotation);
        attribute_decl.setExternalNodes(externalChildren);
        attribute_decl.setTargetNamespace(this.context.targetNamespace);
        return attribute_decl;
    }

    private XsdComplexType loadComplexType(XsdComplexType ref_type, DrbNode base_node) {
        DrbNodeList children;
        XsdComponent complex_type = null;
        String name = null;
        XsdType base = null;
        XsdModelGroup complex_content = null;
        ArrayList<XsdAttribute> attrib_list = new ArrayList<XsdAttribute>();
        XsdAnnotation annotation = null;
        DrbDefaultNodeList externalNodes = new DrbDefaultNodeList();
        DrbDefaultAttributeList externalAttributes = new DrbDefaultAttributeList();
        DrbAttributeList attributes = base_node.getAttributes();
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                DrbAttribute attribute = attributes.item(i);
                String attributeName = attribute.getName();
                if (attributeName.equals("name")) {
                    name = attribute.getValue().toString();
                    continue;
                }
                externalAttributes.add(attribute);
            }
        }
        if ((children = base_node.getChildren()) != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                DrbNode node = children.item(i);
                String nodeName = node.getName();
                if ("annotation".equals(nodeName)) {
                    annotation = this.loadAnnotation(node, externalNodes);
                    continue;
                }
                if ("sequence".equals(nodeName) || "choice".equals(nodeName) || "all".equals(nodeName)) {
                    complex_content = this.loadModelGroup(node);
                    continue;
                }
                if ("complexContent".equals(nodeName) || "simpleContent".equals(nodeName)) {
                    complex_type = this.loadComplexTypeContent(name, node);
                    continue;
                }
                if ("attribute".equals(nodeName)) {
                    XsdAttribute attrib = this.loadAttribute(node);
                    if (attrib == null) continue;
                    attrib_list.add(attrib);
                    continue;
                }
                externalNodes.add(node);
            }
        }
        XsdAttributeGroup attrib_group = null;
        if (attrib_list.size() > 0) {
            XsdAttribute[] attribs = null;
            attribs = new XsdAttribute[attrib_list.size()];
            attrib_list.toArray(attribs);
            attrib_group = new XsdAttributeGroup(null, attribs);
        }
        if (complex_type == null) {
            complex_type = new XsdComplexType(name, attrib_group, complex_content, base, 1);
        }
        if (complex_type.getExternalNodes() != null) {
            DrbNodeList ref_ext_nodes = complex_type.getExternalNodes();
            externalNodes.addAll(0, (Collection)((Object)ref_ext_nodes));
        }
        complex_type.setAnnotation(annotation);
        complex_type.setExternalNodes(externalNodes);
        complex_type.setExternalAttributes(externalAttributes);
        complex_type.setTargetNamespace(this.context.targetNamespace);
        if (ref_type == null) {
            ref_type = (XsdComplexType)this.resolveType(((XsdType)complex_type).getName());
        }
        if (ref_type != null) {
            ref_type.setName(((XsdType)complex_type).getName());
            ref_type.setBase(((XsdType)complex_type).getBase());
            ref_type.setSimpleContent(((XsdComplexType)complex_type).getDatatype());
            ref_type.setComplexContent(((XsdComplexType)complex_type).getComplexContent());
            ref_type.setAttributeGroup(((XsdComplexType)complex_type).getAttributeGroup());
            ref_type.setAnnotation(annotation);
            ref_type.setExternalNodes(externalNodes);
            ref_type.setExternalAttributes(externalAttributes);
            ref_type.setTargetNamespace(complex_type.getTargetNamespace());
            ((XsdType)complex_type).setBase(null);
            return ref_type;
        }
        return complex_type;
    }

    private XsdModelGroup loadModelGroup(DrbNode base_node) {
        XsdAnnotation annotation = null;
        XsdModelGroup model_group = null;
        XsdParticle[] content = null;
        ArrayList<XsdParticle> particle_list = new ArrayList<XsdParticle>();
        int min_occurs = 1;
        int max_occurs = 1;
        int compositor = -1;
        if ("sequence".equals(base_node.getName())) {
            compositor = 1;
        } else if ("choice".equals(base_node.getName())) {
            compositor = 2;
        } else if ("all".equals(base_node.getName())) {
            compositor = 3;
        }
        DrbAttributeList attributes = base_node.getAttributes();
        DrbDefaultAttributeList externalAttributes = new DrbDefaultAttributeList();
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                DrbAttribute attribute = attributes.item(i);
                String attributeName = Namespace.toLocal(attribute.getName());
                if (attributeName.equals("minOccurs")) {
                    min_occurs = Integer.parseInt(attribute.getValue().toString());
                    continue;
                }
                if (!attributeName.equals("maxOccurs")) continue;
                String attributeValue = attribute.getValue().toString();
                max_occurs = attributeValue.equals("unbounded") ? XsdElement.UNBOUNDED_OCCURS : Integer.parseInt(attributeValue);
            }
        }
        DrbNodeList children = base_node.getChildren();
        DrbDefaultNodeList externalNodes = new DrbDefaultNodeList();
        if (children != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                DrbNode node = children.item(i);
                String nodeName = Namespace.toLocal(node.getName());
                if (nodeName.equals("annotation")) {
                    annotation = this.loadAnnotation(node, externalNodes);
                    continue;
                }
                if (nodeName.equals("element")) {
                    particle_list.add(this.loadElement(node));
                    continue;
                }
                if ("sequence".equals(nodeName) || "choice".equals(nodeName) || "all".equals(nodeName)) {
                    particle_list.add(this.loadModelGroup(node));
                    continue;
                }
                externalNodes.add(node);
            }
        }
        content = new XsdParticle[particle_list.size()];
        particle_list.toArray(content);
        model_group = new XsdModelGroup(min_occurs, max_occurs, content, compositor);
        model_group.setAnnotation(annotation);
        model_group.setExternalNodes(externalNodes);
        return model_group;
    }

    private XsdComplexType loadComplexTypeContent(String name, DrbNode base_node) {
        boolean simpleContent = true;
        int complexContent = 2;
        int content_type = -1;
        int derivation_method = -1;
        DrbSimpleNode content_node = null;
        XsdType base_type = null;
        if ("complexContent".equals(base_node.getName())) {
            content_type = 2;
        } else if ("simpleContent".equals(base_node.getName())) {
            content_type = 1;
        }
        DrbNodeList children = base_node.getChildren();
        if (children != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                DrbNode node = children.item(i);
                String nodeName = Namespace.toLocal(node.getName());
                if ("extension".equals(nodeName)) {
                    content_node = node;
                    derivation_method = 1;
                    continue;
                }
                if (!"restriction".equals(nodeName)) continue;
                content_node = node;
                derivation_method = 2;
            }
        }
        if (content_node == null) {
            return null;
        }
        DrbAttributeList attributes = content_node.getAttributes();
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                DrbAttribute attribute = attributes.item(i);
                String attributeName = Namespace.toLocal(attribute.getName());
                if (!"base".equals(attributeName)) continue;
                String base_typename = attribute.getValue().toString();
                base_type = this.resolveType(base_typename);
            }
        }
        if (base_type == null) {
            return null;
        }
        ArrayList<XsdAttribute> attrib_list = new ArrayList<XsdAttribute>();
        XsdModelGroup complex_content = null;
        children = content_node.getChildren();
        if (children != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                XsdAttribute attrib;
                DrbNode node = children.item(i);
                String nodeName = Namespace.toLocal(node.getName());
                if ("sequence".equals(nodeName) || "choice".equals(nodeName) || "all".equals(nodeName)) {
                    complex_content = this.loadModelGroup(node);
                    continue;
                }
                if (!"attribute".equals(nodeName) || (attrib = this.loadAttribute(node)) == null) continue;
                attrib_list.add(attrib);
            }
        }
        XsdAttributeGroup attrib_group = null;
        if (attrib_list.size() > 0) {
            XsdAttribute[] attribs = null;
            attribs = new XsdAttribute[attrib_list.size()];
            attrib_list.toArray(attribs);
            attrib_group = new XsdAttributeGroup(null, attribs);
        }
        XsdSimpleType simple_content = base_type.getDatatype();
        XsdComplexType complex_type = null;
        if (derivation_method == 2 && content_type == 1) {
            XsdFacet[] facets = this.loadFacets(simple_content.getTypeId(), (DrbNode)content_node);
            complex_type = new XsdComplexType(name, attrib_group, facets, base_type, derivation_method);
        } else {
            complex_type = new XsdComplexType(name, attrib_group, complex_content, base_type, derivation_method);
        }
        return complex_type;
    }

    private XsdSimpleType loadSimpleType(DrbNode base_node) {
        XsdAnnotation annotation = null;
        String name = null;
        XsdComponent type = null;
        DrbAttributeList attributes = base_node.getAttributes();
        DrbDefaultAttributeList externalAttributes = new DrbDefaultAttributeList();
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                DrbAttribute attribute = attributes.item(i);
                String attributeName = Namespace.toLocal(attribute.getName());
                if ("name".equals(attributeName)) {
                    name = attribute.getValue().toString();
                    continue;
                }
                externalAttributes.add(attribute);
            }
        }
        DrbNodeList children = base_node.getChildren();
        DrbDefaultNodeList externalNodes = new DrbDefaultNodeList();
        if (children != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                DrbNode node = children.item(i);
                String nodeName = Namespace.toLocal(node.getName());
                if (nodeName.equals("annotation")) {
                    annotation = this.loadAnnotation(node, externalNodes);
                    continue;
                }
                if ("restriction".equals(nodeName) || "list".equals(nodeName)) {
                    type = this.loadSimpleTypeContent(name, node);
                    continue;
                }
                externalNodes.add(node);
            }
        }
        if (type != null) {
            if (type.getExternalNodes() != null) {
                DrbNodeList ref_ext_nodes = type.getExternalNodes();
                externalNodes.addAll(0, (Collection)((Object)ref_ext_nodes));
            }
            if (annotation == null) {
                annotation = type.getAnnotation();
            }
            type.setAnnotation(annotation);
            type.setExternalNodes(externalNodes);
            type.setTargetNamespace(this.context.targetNamespace);
        }
        return type;
    }

    private XsdSimpleType loadSimpleTypeContent(String name, DrbNode base_node) {
        DrbAttributeList attributes;
        boolean restrictionMethod = true;
        int listMethod = 2;
        int derivation_method = -1;
        int type_id = -2;
        XsdSimpleType type = null;
        XsdSimpleType base_type = null;
        XsdSimpleType item_type = null;
        XsdFacet[] facets = null;
        if ("restriction".equals(base_node.getName())) {
            derivation_method = 1;
        } else if ("list".equals(base_node.getName())) {
            derivation_method = 2;
        } else {
            return null;
        }
        DrbNodeList children = base_node.getChildren();
        if (children != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                DrbNode node = children.item(i);
                String nodeName = Namespace.toLocal(node.getName());
                if (!"simpleType".equals(nodeName)) continue;
                if (derivation_method == 1) {
                    base_type = this.loadSimpleType(node);
                    type_id = base_type.getTypeId();
                }
                if (derivation_method != 2) continue;
                item_type = this.loadSimpleType(node);
                type_id = 10;
            }
        }
        if ((attributes = base_node.getAttributes()) != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String base_typename;
                DrbAttribute attribute = attributes.item(i);
                String attributeName = Namespace.toLocal(attribute.getName());
                if (derivation_method == 1 && "base".equals(attributeName) && (base_type = (XsdSimpleType)this.resolveType(base_typename = attribute.getValue().toString())) != null) {
                    type_id = base_type.getTypeId();
                }
                if (derivation_method != 2 || !"itemType".equals(attributeName)) continue;
                String item_typename = attribute.getValue().toString();
                item_type = (XsdSimpleType)this.resolveType(item_typename);
            }
        }
        boolean primitive_flag = false;
        if (type_id == -2) {
            type_id = 7;
        }
        if ("http://www.w3.org/2001/XMLSchema".equals(this.context.targetNamespace)) {
            primitive_flag = true;
            if ("boolean".equals(name)) {
                type_id = 0;
            } else if ("float".equals(name)) {
                type_id = 5;
            } else if ("double".equals(name)) {
                type_id = 6;
            } else if ("decimal".equals(name)) {
                type_id = 26;
            } else if ("integer".equals(name)) {
                type_id = 27;
            } else if ("long".equals(name)) {
                type_id = 4;
            } else if ("unsignedLong".equals(name)) {
                type_id = 15;
            } else if ("int".equals(name)) {
                type_id = 3;
            } else if ("unsignedInt".equals(name)) {
                type_id = 14;
            } else if ("short".equals(name)) {
                type_id = 2;
            } else if ("unsignedShort".equals(name)) {
                type_id = 13;
            } else if ("byte".equals(name)) {
                type_id = 1;
            } else if ("unsignedByte".equals(name)) {
                type_id = 12;
            } else if ("string".equals(name)) {
                type_id = 7;
            } else if ("anyURI".equals(name)) {
                type_id = 7;
            } else if ("NOTATION".equals(name)) {
                type_id = 7;
            } else if ("QName".equals(name)) {
                type_id = 7;
            } else if ("dateTime".equals(name)) {
                type_id = 8;
            } else if ("duration".equals(name)) {
                type_id = 16;
            } else {
                primitive_flag = false;
            }
        }
        facets = this.loadFacets(type_id, base_node);
        if (base_type != null) {
            switch (base_type.getVariety()) {
                case 2: {
                    type = new XsdAtomicType(name, (XsdAtomicType)base_type, facets);
                    break;
                }
                case 3: {
                    item_type = ((XsdListType)base_type).getItemType();
                }
            }
        }
        if (primitive_flag) {
            ((XsdAtomicType)type).init(type_id);
            type.name = name;
        }
        if (item_type != null) {
            type = new XsdListType(name, item_type, facets);
        }
        if (type != null && base_type != null) {
            type.setExternalNodes(base_type.getExternalNodes());
            type.setAnnotation(base_type.getAnnotation());
            type.setTargetNamespace(this.context.targetNamespace);
        }
        return type;
    }

    XsdFacet[] loadFacets(int type_id, DrbNode base_node) {
        ArrayList<XsdFacet> facet_list = new ArrayList<XsdFacet>();
        ArrayList<Value> enum_list = new ArrayList<Value>();
        XsdFacet[] facets = null;
        int primitive_id = type_id;
        switch (type_id) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 26: 
            case 27: {
                primitive_id = 26;
            }
        }
        DrbNodeList children = base_node.getChildren();
        DrbDefaultNodeList externalNodes = new DrbDefaultNodeList();
        if (children != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                DrbNode node = children.item(i);
                String nodeName = Namespace.toLocal(node.getName());
                Value facet_value = null;
                DrbAttributeList attributes = node.getAttributes();
                if (attributes != null) {
                    for (int j = 0; j < attributes.getLength(); ++j) {
                        DrbAttribute attribute = attributes.item(j);
                        String attributeName = Namespace.toLocal(attribute.getName());
                        if (!"value".equals(attributeName)) continue;
                        facet_value = attribute.getValue();
                    }
                }
                if (facet_value == null) continue;
                if ("minInclusive".equals(nodeName)) {
                    facet_list.add(new XsdMinInclusiveFacet(facet_value.convertTo(primitive_id)));
                    continue;
                }
                if ("maxInclusive".equals(nodeName)) {
                    facet_list.add(new XsdMaxInclusiveFacet(facet_value.convertTo(primitive_id)));
                    continue;
                }
                if ("minExclusive".equals(nodeName)) {
                    facet_list.add(new XsdMinExclusiveFacet(facet_value.convertTo(primitive_id)));
                    continue;
                }
                if ("maxExclusive".equals(nodeName)) {
                    facet_list.add(new XsdMaxExclusiveFacet(facet_value.convertTo(primitive_id)));
                    continue;
                }
                if ("length".equals(nodeName)) {
                    facet_list.add(new XsdLengthFacet(facet_value.convertTo(27)));
                    continue;
                }
                if ("minLength".equals(nodeName)) {
                    facet_list.add(new XsdMinLengthFacet(facet_value.convertTo(27)));
                    continue;
                }
                if ("maxLength".equals(nodeName)) {
                    facet_list.add(new XsdMaxLengthFacet(facet_value.convertTo(27)));
                    continue;
                }
                if ("pattern".equals(nodeName)) {
                    facet_list.add(new XsdPatternFacet(facet_value.toString()));
                    continue;
                }
                if ("enumeration".equals(nodeName)) {
                    enum_list.add(facet_value.convertTo(primitive_id));
                    continue;
                }
                if ("fractionDigits".equals(nodeName)) {
                    facet_list.add(new XsdFractionDigitsFacet(facet_value.convertTo(27)));
                    continue;
                }
                if ("totalDigits".equals(nodeName)) {
                    facet_list.add(new XsdTotalDigitsFacet(facet_value.convertTo(27)));
                    continue;
                }
                externalNodes.add(node);
            }
        }
        if (enum_list.size() > 0) {
            Value[] enum_values = new Value[enum_list.size()];
            enum_list.toArray(enum_values);
            facet_list.add(new XsdEnumerationFacet(enum_values));
        }
        if (facet_list.size() > 0) {
            facets = new XsdFacet[facet_list.size()];
            facet_list.toArray(facets);
        }
        return facets;
    }

    public XmlSchema open(DrbNode schema) {
        DrbNode base = null;
        if (schema != null) {
            base = schema.getParent();
        }
        return this.open(base, schema);
    }

    public XmlSchema open(DrbNode base, DrbNode schema) {
        this.init(XmlSchema.getDefaultSchema());
        if (schema != null) {
            this.preloadSchema(this.context, base, schema);
            return this.loadSchema(schema);
        }
        return null;
    }

    protected XmlSchema open(DrbNode base, DrbNode schema_node, XmlSchema schema_def) {
        this.init(schema_def);
        if (schema_node != null) {
            this.preloadSchema(this.context, base, schema_node);
            return this.loadSchema(schema_node);
        }
        return null;
    }

    public static void main(String[] args) {
        DrbNode file_node = DrbFactory.open(args[0]);
        logger.error("Opened file '" + file_node.getPath() + ".");
        DrbNode schema_node = file_node.getFirstChild();
        logger.error("Opened schema '" + schema_node.getPath() + ".");
        XsdFactory xsdfactory = new XsdFactory();
        XmlSchema xmlschema = xsdfactory.open(file_node.getParent(), schema_node);
        if (xmlschema == null) {
            logger.error("Problem while loading schema !");
            return;
        }
        for (int i = 0; i < schema_node.getAttributes().getLength(); ++i) {
            System.err.println("local name=" + schema_node.getAttributes().item(i).getName());
            System.err.println("namespace URI=" + schema_node.getAttributes().item(i).getNamespaceURI());
        }
        XmlFactory.writeXML(xmlschema.toNode(), System.err);
        XsdElement root_elt = xmlschema.getDefaultRootElement();
        if (root_elt == null) {
            logger.error("No elements !");
            return;
        }
    }

    private static class Context {
        HashMap globalTypeMap = new HashMap();
        HashMap globalAttributeMap = new HashMap();
        HashMap globalElementMap = new HashMap();
        Namespace namespaces = new Namespace();
        HashMap unresolvedTypeMap = new HashMap();
        HashMap unresolvedAttributeMap = new HashMap();
        HashMap unresolvedElementMap = new HashMap();
        HashSet includeSet = new HashSet();
        String targetNamespace = null;

        Context(XmlSchema xsd_schema) {
            if (xsd_schema != null) {
                XsdType[] xsd_type = xsd_schema.getGlobalTypes();
                for (int i = 0; i < xsd_type.length; ++i) {
                    XsdType type = xsd_type[i];
                    this.globalTypeMap.put(type.getName(), type);
                }
            }
        }
    }
}

