/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.xsd;

import fr.gael.drb.DrbAttributeList;
import fr.gael.drb.DrbDefaultAttribute;
import fr.gael.drb.DrbDefaultAttributeList;
import fr.gael.drb.DrbFactory;
import fr.gael.drb.DrbItem;
import fr.gael.drb.DrbNode;
import fr.gael.drb.DrbSimpleNode;
import fr.gael.drb.impl.xml.XmlWriter;
import fr.gael.drb.query.Query;
import fr.gael.drb.value.String;
import fr.gael.drb.value.Value;
import fr.gael.drb.xsd.DrbNodeFilter;
import fr.gael.drb.xsd.XmlSchema;
import fr.gael.drb.xsd.XsdComplexType;
import fr.gael.drb.xsd.XsdElement;
import fr.gael.drb.xsd.XsdFactory;
import fr.gael.drb.xsd.XsdInvalid;
import fr.gael.drb.xsd.XsdInvalidElement;
import fr.gael.drb.xsd.XsdNode;
import fr.gael.drb.xsd.XsdType;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import org.apache.log4j.Logger;

public class XsdNodeImpl
extends DrbNodeFilter
implements XsdNode {
    private XsdType type;
    private XsdNodeImpl parent = null;
    private static Logger logger = Logger.getLogger(XsdNodeImpl.class);

    protected XsdNodeImpl(XsdNodeImpl parent, DrbNode base, XsdType type) {
        super(base);
        this.type = type;
        this.parent = parent;
    }

    public static XsdNode getInstance(DrbNode base, XsdType type) {
        if (base == null) {
            return null;
        }
        return new XsdNodeImpl(null, base, type);
    }

    public XsdType getType() {
        return this.type;
    }

    @Override
    public XsdInvalid isValid() {
        if (this.type == null) {
            return new XsdInvalidElement(this.baseNode, null);
        }
        return this.type.isValid(this.baseNode);
    }

    public XsdInvalid isDeepValid() {
        XsdInvalid invalid = this.isValid();
        if (invalid == null) {
            int count = this.getChildrenCount();
            for (int i = 0; i < count; ++i) {
                XsdNodeImpl child = (XsdNodeImpl)this.getChildAt(i);
                if (child != null) {
                    invalid = child.isDeepValid();
                }
                if (invalid != null) break;
            }
        }
        return invalid;
    }

    @Override
    public DrbAttributeList getAttributes() {
        XsdType base_type;
        DrbAttributeList attribs = this.baseNode.getAttributes();
        DrbDefaultAttributeList xsdattribs = new DrbDefaultAttributeList();
        if (attribs != null) {
            for (int i = 0; i < attribs.getLength(); ++i) {
                xsdattribs.add(attribs.item(i));
            }
        }
        java.lang.String typename = "anyType";
        for (base_type = this.type; base_type != null && base_type.getName() == null; base_type = base_type.getBase()) {
        }
        if (base_type != null && base_type.getName() != null) {
            typename = base_type.getName();
        }
        DrbDefaultAttribute xsitype = new DrbDefaultAttribute("type", new String(typename));
        xsitype.setNamespaceURI("http://www.w3.org/2001/XMLSchema-instance");
        xsdattribs.add(xsitype);
        XsdInvalid invalid = this.isValid();
        if (invalid != null) {
            DrbDefaultAttribute xsivalid = new DrbDefaultAttribute("error", new String(invalid.getMessage()));
            xsdattribs.add(xsivalid);
        }
        return xsdattribs;
    }

    @Override
    public DrbNode getParent() {
        if (this.parent == null) {
            return this.baseNode.getParent();
        }
        return this.parent;
    }

    @Override
    protected DrbNodeFilter getInstance(DrbNode node) {
        if (node != null) {
            XsdType childtype = null;
            if (this.type != null && this.type.isComplex()) {
                XsdComplexType cpxtype = (XsdComplexType)this.type;
                childtype = cpxtype.getElementType(node.getName());
            }
            return new XsdNodeImpl(this, node, childtype);
        }
        return null;
    }

    @Override
    public final DrbNode getPreviousSibling() {
        if (this.parent == null) {
            return this.baseNode.getPreviousSibling();
        }
        return this.parent.getInstance(this.baseNode.getPreviousSibling());
    }

    @Override
    public final DrbNode getNextSibling() {
        if (this.parent == null) {
            return this.baseNode.getNextSibling();
        }
        return this.parent.getInstance(this.baseNode.getNextSibling());
    }

    @Override
    public java.lang.String toString() {
        return this.baseNode.toString() + " xsi:type='" + (this.type == null ? "null" : this.type.getName()) + "'";
    }

    @Override
    public Value setValue(Value value) throws NullPointerException, ClassCastException, UnsupportedOperationException {
        XsdInvalid invalid = null;
        if (this.type != null && this.type.getDatatype() != null) {
            invalid = this.type.getDatatype().validate(value);
            if (invalid == null) {
                return this.baseNode.setValue(value);
            }
        } else {
            invalid = new XsdInvalidElement(this.baseNode, null);
        }
        throw new UnsupportedOperationException(invalid.getMessage());
    }

    public static void main(java.lang.String[] args) throws Exception {
        DrbNode base;
        if (args.length == 0 || args[0].equals("--help") || args[0].equals("-help")) {
            System.out.println("Usage: fr.gael.drb.xsd.XsdNodeImpl [options] file");
            System.out.println("Options are:");
            System.out.println("-xquery <xquery_file> Path to a file containing an XQuery script.");
            System.out.println("-schema <schema> Use schema <schema> to validate documents.");
            System.out.println("-append <xpath> <node> Append a node the specified path.");
            System.out.println("-replace <xpath> <node> Replace the node at the specified path.");
            System.out.println("-insert <xpath> <node> Insert a node at the specified path.");
            System.out.println("-remove <xpath> <node> Remove the node at the specified path.");
            System.out.println("-value <xpath> <value> Set the value at the specified path.");
            System.out.println("-out <output_file> Set the output file.");
        }
        DrbSimpleNode node = null;
        XsdNodeImpl product_1 = null;
        FileOutputStream xml_output = null;
        java.lang.String xpath = null;
        DrbNode append_node = null;
        DrbNode replace_node = null;
        DrbNode insert_node = null;
        DrbItem value_item = null;
        DrbSimpleNode schema_node = null;
        DrbNode context_node = DrbFactory.open(".");
        for (int i = 0; i < args.length; ++i) {
            if (args[i].length() == 0) continue;
            if (args[i].equals("-schema")) {
                schema_node = (DrbNode)new Query(args[++i]).evaluate(context_node).getItem(0);
                continue;
            }
            if (args[i].equals("-value")) {
                xpath = args[++i];
                value_item = new Query(args[++i]).evaluate(context_node).getItem(0).getValue();
                continue;
            }
            if (args[i].equals("-append")) {
                xpath = args[++i];
                append_node = (DrbNode)new Query(args[++i]).evaluate(context_node).getItem(0);
                continue;
            }
            if (args[i].equals("-replace")) {
                xpath = args[++i];
                replace_node = (DrbNode)new Query(args[++i]).evaluate(context_node).getItem(0);
                continue;
            }
            if (args[i].equals("-insert")) {
                xpath = args[++i];
                insert_node = (DrbNode)new Query(args[++i]).evaluate(context_node).getItem(0);
                continue;
            }
            if (args[i].equals("-remove")) {
                xpath = args[++i];
                continue;
            }
            if (args[i].equals("-out")) {
                xml_output = new FileOutputStream(args[++i]);
                continue;
            }
            if (args[i].equals("-xquery")) {
                FileInputStream xquery_file = new FileInputStream(args[++i]);
                node = (DrbNode)new Query(xquery_file).evaluate(context_node).getItem(0);
                continue;
            }
            node = DrbFactory.open(args[i]);
        }
        if (node == null) {
            System.err.println("ERROR: No document specified!");
            return;
        }
        XsdType type = null;
        if (schema_node == null) {
            System.err.println("WARNING: No schema specified!");
        } else {
            XmlSchema schema = null;
            schema = schema_node.getName().equals("schema") ? new XsdFactory().open((DrbNode)schema_node) : new XsdFactory().open(schema_node.getParent(), schema_node.getNamedChild("schema", 1));
            XsdElement element = schema.getRootElement(node.getName());
            if (element != null) {
                type = element.getType();
            }
        }
        product_1 = (XsdNodeImpl)XsdNodeImpl.getInstance(node, type);
        if (value_item != null) {
            System.err.println("##########Setting value...");
            base = (DrbNode)new Query(xpath).evaluate(product_1).getItem(0);
            base.setValue(value_item.getValue());
        } else if (append_node != null) {
            System.err.println("##########Appending data...");
            base = (DrbNode)new Query(xpath).evaluate(product_1).getItem(0);
            base.appendChild(append_node);
        } else if (replace_node != null) {
            System.err.println("##########Replacing data...");
            base = (DrbNode)new Query(xpath).evaluate(product_1).getItem(0);
            int index = base.getIndex();
            base.getParent().replaceChild(index, replace_node);
        } else if (insert_node != null) {
            System.err.println("##########Inserting data...");
            base = (DrbNode)new Query(xpath).evaluate(product_1).getItem(0);
            int index = base.getIndex();
            base.getParent().insertChild(insert_node, index);
        } else if (xpath != null) {
            System.err.println("##########Removing data...");
            base = (DrbNode)new Query(xpath).evaluate(product_1).getItem(0);
            int index = base.getIndex();
            base.getParent().removeChild(index);
        }
        if (xml_output != null) {
            System.err.println("##########Writing XML product...");
            XmlWriter.Context writer_context = new XmlWriter.Context();
            writer_context.setFilter(0xFFFFFE);
            writer_context.setPreserveSpace(true);
            XmlWriter.writeXML(product_1, xml_output, writer_context, false);
        } else {
            XsdInvalid invalid = product_1.isDeepValid();
            if (invalid != null) {
                System.out.println(invalid.getMessage());
            }
        }
    }
}

