/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.application;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.restlet.data.Range;

public class RangeInputStream
extends FilterInputStream {
    private volatile long position;
    private volatile Range range;
    private volatile long totalSize;
    private final long startIndex;
    private final long endIndex;
    private volatile int availableSize;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected RangeInputStream(InputStream in, long totalSize, Range range) {
        super(in);
        this.range = range;
        this.position = 0L;
        this.totalSize = totalSize;
        this.availableSize = (int)range.getSize();
        if (totalSize == -1L) {
            if (range.getIndex() == -1L) {
                if (range.getSize() != -1L) throw new IllegalArgumentException("Can't determine the start and end index.");
                this.startIndex = -1L;
                this.endIndex = -1L;
                return;
            } else if (range.getSize() == -1L) {
                this.startIndex = range.getIndex();
                this.endIndex = -1L;
                return;
            } else {
                this.startIndex = range.getIndex();
                this.endIndex = range.getIndex() + range.getSize() - 1L;
            }
            return;
        } else if (range.getIndex() == -1L) {
            if (range.getSize() == -1L) {
                this.startIndex = -1L;
                this.endIndex = -1L;
                return;
            } else {
                this.startIndex = totalSize - range.getSize();
                this.endIndex = -1L;
            }
            return;
        } else if (range.getSize() == -1L) {
            this.startIndex = range.getIndex();
            this.endIndex = -1L;
            return;
        } else {
            this.startIndex = range.getIndex();
            this.endIndex = range.getIndex() + range.getSize() - 1L;
        }
    }

    public int available() throws IOException {
        return this.availableSize;
    }

    public synchronized void mark(int readlimit) {
        if (this.range.getIndex() == -1L) {
            super.mark(readlimit + (int)(this.totalSize - this.range.getSize()));
        } else {
            super.mark(readlimit + (int)this.range.getIndex());
        }
    }

    public int read() throws IOException {
        int result = super.read();
        while (result != -1 && !this.range.isIncluded(this.position++, this.totalSize)) {
            result = super.read();
        }
        if (result != -1 && this.availableSize > 0) {
            --this.availableSize;
        }
        return result;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        while (this.position < this.startIndex) {
            long skipped = this.skip(this.startIndex - this.position);
            if (skipped <= 0L) {
                throw new IOException("Cannot skip ahead in FilterInputStream");
            }
            this.position += skipped;
        }
        int result = -1;
        result = this.endIndex != -1L ? (this.position > this.endIndex ? -1 : super.read(b, off, this.position + (long)len > this.endIndex ? (int)(this.endIndex - this.position + 1L) : len)) : super.read(b, off, len);
        if (result > 0) {
            this.position += (long)result;
        }
        if (result != -1 && this.availableSize > 0) {
            this.availableSize -= result;
        }
        return result;
    }
}

