/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.pool.sizeof;

import net.sf.ehcache.pool.Size;
import net.sf.ehcache.pool.sizeof.FlyweightType;
import net.sf.ehcache.pool.sizeof.MaxDepthExceededException;
import net.sf.ehcache.pool.sizeof.ObjectGraphWalker;
import net.sf.ehcache.pool.sizeof.filter.SizeOfFilter;
import net.sf.ehcache.util.WeakIdentityConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SizeOf {
    private static final Logger LOG = LoggerFactory.getLogger((String)SizeOf.class.getName());
    private final ObjectGraphWalker walker;

    public SizeOf(SizeOfFilter fieldFilter, boolean caching) {
        ObjectGraphWalker.Visitor visitor = caching ? new CachingSizeOfVisitor() : new SizeOfVisitor();
        this.walker = new ObjectGraphWalker(visitor, fieldFilter);
    }

    public long sizeOf(Object obj) {
        if (SizeOf.isSharedFlyweight(obj)) {
            return 0L;
        }
        return this.measureSizeOf(obj);
    }

    protected abstract long measureSizeOf(Object var1);

    public Size deepSizeOf(int maxDepth, boolean abortWhenMaxDepthExceeded, Object ... obj) {
        try {
            return new Size(this.walker.walk(maxDepth, abortWhenMaxDepthExceeded, obj), true);
        }
        catch (MaxDepthExceededException e) {
            LOG.warn(e.getMessage());
            return new Size(e.getMeasuredSize(), false);
        }
    }

    private static boolean isSharedFlyweight(Object obj) {
        FlyweightType type = FlyweightType.getFlyweightType(obj.getClass());
        return type != null && type.isShared(obj);
    }

    private class CachingSizeOfVisitor
    implements ObjectGraphWalker.Visitor {
        private final WeakIdentityConcurrentMap<Class<?>, Long> cache = new WeakIdentityConcurrentMap();

        private CachingSizeOfVisitor() {
        }

        public long visit(Object object) {
            Class<?> klazz = object.getClass();
            Long cachedSize = this.cache.get(klazz);
            if (cachedSize == null) {
                if (klazz.isArray()) {
                    return SizeOf.this.measureSizeOf(object);
                }
                if (SizeOf.isSharedFlyweight(object)) {
                    return 0L;
                }
                long size = SizeOf.this.measureSizeOf(object);
                this.cache.put(klazz, size);
                return size;
            }
            return cachedSize;
        }
    }

    private class SizeOfVisitor
    implements ObjectGraphWalker.Visitor {
        private SizeOfVisitor() {
        }

        public long visit(Object object) {
            return SizeOf.this.sizeOf(object);
        }
    }
}

