import * as lambda from '@aws-cdk/aws-lambda';
import * as s3 from '@aws-cdk/aws-s3';
import * as sqs from '@aws-cdk/aws-sqs';
import { Construct } from '@aws-cdk/core';
import { Monitoring } from '../../monitoring';
/**
 * Props from `Prune`.
 */
export interface PruneProps {
    /**
     * The S3 bucket that includes the package data.
     */
    readonly packageDataBucket: s3.IBucket;
    /**
      * The S3 key prefix for all package data.
      */
    readonly packageDataKeyPrefix: string;
    /**
     * The monitoring system.
     */
    readonly monitoring: Monitoring;
}
/**
 * Reads the deny list and prunes all objects from the package data bucket
 * related to packages that match one of the deny list rules.
 */
export declare class Prune extends Construct {
    /**
     * The function that needs to read the deny list.
     */
    readonly pruneHandler: lambda.Function;
    /**
     * The function that deletes files of denied packages.
     */
    readonly deleteHandler: lambda.Function;
    /**
     * An SQS queue which includes objects to be deleted.
     */
    readonly queue: sqs.Queue;
    constructor(scope: Construct, id: string, props: PruneProps);
    /**
     * Should be called to rebuild the catalog when the deny list changes.
     */
    onChangeInvoke(callback: lambda.IFunction): void;
}
