# Generated by Django 4.0.1 on 2022-01-14 13:44

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Geography',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('level', models.PositiveSmallIntegerField()),
                ('original_name', models.CharField(help_text='Original name in the native language.', max_length=256, null=True)),
                ('en_name', models.CharField(help_text='English name.', max_length=256, null=True)),
                ('code', models.CharField(help_text='Code as defined by a standard.', max_length=16)),
                ('standard', models.IntegerField(choices=[(0, 'Unspecified'), (1, 'NUTS'), (2, 'ISO 3166')], default=0, help_text='The standard this code is defined by.')),
                ('alpha_2', models.CharField(max_length=16, null=True, unique=True)),
                ('alpha_3', models.CharField(max_length=16, null=True, unique=True)),
                ('parent', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='children', to='geographical_module.geography')),
                ('top_parent', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='bottom_children', to='geographical_module.geography')),
            ],
            options={
                'unique_together': {('standard', 'code')},
            },
        ),
        migrations.CreateModel(
            name='GeographyPostcode',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('postcode', models.CharField(max_length=16)),
                ('geography', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='postcodes', to='geographical_module.geography')),
            ],
            options={
                'unique_together': {('geography', 'postcode')},
            },
        ),
    ]
