"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TagConditionField = exports.TagConditionLogicType = exports.TagCondition = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * (experimental) Condition for applying a custom tag to a package.
 *
 * @experimental
 */
class TagCondition {
    /**
     * (experimental) Create an && condition which applies only when all condition arguments are true.
     *
     * @experimental
     */
    static and(...conds) {
        return new TagConditionLogic(TagConditionLogicType.AND, conds);
    }
    /**
     * (experimental) Create an || condition which applies if any of the condition arguments are true.
     *
     * @experimental
     */
    static or(...conds) {
        return new TagConditionLogic(TagConditionLogicType.OR, conds);
    }
    /**
     * (experimental) Create a !
     *
     * condition which applies if the condition argument is false
     *
     * @experimental
     */
    static not(...conds) {
        return new TagConditionLogic(TagConditionLogicType.NOT, conds);
    }
    /**
     * (experimental) Target a field within the `package.json` to assert against. Nested fields can be accessed by passing multiple keys. `TagCondition.field('key1', 'key2')` will access `packageJson?.key1?.key2`.
     *
     * @experimental
     */
    static field(...keys) {
        return new TagConditionField(keys);
    }
}
exports.TagCondition = TagCondition;
_a = JSII_RTTI_SYMBOL_1;
TagCondition[_a] = { fqn: "construct-hub.TagCondition", version: "0.3.193" };
/**
 * (experimental) Logic operators for performing specific conditional logic.
 *
 * @experimental
 */
var TagConditionLogicType;
(function (TagConditionLogicType) {
    TagConditionLogicType["AND"] = "AND";
    TagConditionLogicType["OR"] = "OR";
    TagConditionLogicType["NOT"] = "NOT";
    TagConditionLogicType["EQUALS"] = "EQUALS";
    TagConditionLogicType["INCLUDES"] = "INCLUDES";
    TagConditionLogicType["STARTS_WITH"] = "STARTS_WITH";
})(TagConditionLogicType = exports.TagConditionLogicType || (exports.TagConditionLogicType = {}));
class TagConditionLogic extends TagCondition {
    constructor(type, children) {
        super();
        this.type = type;
        this.children = children;
        this.isLogic = true;
    }
    bind() {
        return {
            type: this.type,
            children: this.children.map((cond) => cond.bind()),
        };
    }
}
class TagConditionPredicate extends TagCondition {
    constructor(type, key, value) {
        super();
        this.type = type;
        this.key = key;
        this.value = value;
        this.isPredicate = true;
    }
    bind() {
        return {
            type: this.type,
            key: this.key,
            value: this.value,
        };
    }
}
/**
 * (experimental) Target a field to use in logic to dictate whether a tag is relevant.
 *
 * @experimental
 */
class TagConditionField {
    /**
     * @experimental
     */
    constructor(field) {
        this.field = field;
    }
    /**
     * (experimental) Create a === condition which applies if the specified field within the package's package.json is equal to the passed value.
     *
     * @experimental
     */
    eq(value) {
        return new TagConditionPredicate(TagConditionLogicType.EQUALS, this.field, value);
    }
    /**
     * (experimental) Create a `field.includes(value)` condition which applies if the specified field within the package's package.json includes the value. This works for arrays or strings.
     *
     * @experimental
     */
    includes(value) {
        return new TagConditionPredicate(TagConditionLogicType.INCLUDES, this.field, value);
    }
    /**
     * (experimental) Create a `field.startsWith(value)` condition which applies if the specified field within the package's package.json begins with the value. This works only for string values.
     *
     * @experimental
     */
    startsWith(value) {
        return new TagConditionPredicate(TagConditionLogicType.STARTS_WITH, this.field, value);
    }
}
exports.TagConditionField = TagConditionField;
_b = JSII_RTTI_SYMBOL_1;
TagConditionField[_b] = { fqn: "construct-hub.TagConditionField", version: "0.3.193" };
//# sourceMappingURL=data:application/json;base64,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