"use strict";
/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
Object.defineProperty(exports, "__esModule", { value: true });
const path = require("path");
const pdk_nag_1 = require("../../pdk-nag");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const assertions_1 = require("aws-cdk-lib/assertions");
const aws_s3_1 = require("aws-cdk-lib/aws-s3");
const aws_s3_assets_1 = require("aws-cdk-lib/aws-s3-assets");
const src_1 = require("../src");
describe("PDK Pipeline Unit Tests", () => {
    it("Defaults", () => {
        const app = pdk_nag_1.PDKNag.app();
        const stack = new aws_cdk_lib_1.Stack(app);
        const pipeline = new src_1.PDKPipeline(stack, "Defaults", {
            primarySynthDirectory: "cdk.out",
            repositoryName: "Defaults",
            synth: {},
            sonarCodeScannerConfig: {
                sonarqubeAuthorizedGroup: "dev",
                sonarqubeDefaultProfileOrGateName: "dev",
                sonarqubeEndpoint: "https://sonar.dev",
                sonarqubeProjectName: "Default",
            },
        });
        const stage = new aws_cdk_lib_1.Stage(app, "Stage");
        const appStack = new aws_cdk_lib_1.Stack(stage, "AppStack");
        new aws_s3_assets_1.Asset(appStack, "Asset", {
            path: path.join(__dirname, "pdk-pipeline.test.ts"),
        });
        pipeline.addStage(stage);
        pipeline.buildPipeline();
        expect(assertions_1.Template.fromStack(stack)).toMatchSnapshot();
    });
    it("StageNagRuns", () => {
        const app = pdk_nag_1.PDKNag.app({ failOnError: false });
        const stack = new aws_cdk_lib_1.Stack(app);
        const pipeline = new src_1.PDKPipeline(stack, "StageNagRuns", {
            primarySynthDirectory: "cdk.out",
            repositoryName: "StageNagRuns",
            synth: {},
            sonarCodeScannerConfig: {
                sonarqubeAuthorizedGroup: "dev",
                sonarqubeDefaultProfileOrGateName: "dev",
                sonarqubeEndpoint: "https://sonar.dev",
                sonarqubeProjectName: "Default",
            },
        });
        const stage = new aws_cdk_lib_1.Stage(app, "Stage");
        const appStack = new aws_cdk_lib_1.Stack(stage, "AppStack");
        new aws_s3_1.Bucket(appStack, "Non-Compliant");
        pipeline.addStage(stage);
        pipeline.buildPipeline();
        app.synth();
        expect(app.nagResults()[0].resource).toEqual("Stage/AppStack/Non-Compliant/Resource");
    });
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicGRrLXBpcGVsaW5lLnRlc3QuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJwZGstcGlwZWxpbmUudGVzdC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiO0FBQUE7Ozs7Ozs7Ozs7Ozs7O3dIQWN3SDs7QUFFeEgsNkJBQTZCO0FBQzdCLDJDQUF1QztBQUN2Qyw2Q0FBMkM7QUFDM0MsdURBQWtEO0FBQ2xELCtDQUE0QztBQUM1Qyw2REFBa0Q7QUFDbEQsZ0NBQXFDO0FBRXJDLFFBQVEsQ0FBQyx5QkFBeUIsRUFBRSxHQUFHLEVBQUU7SUFDdkMsRUFBRSxDQUFDLFVBQVUsRUFBRSxHQUFHLEVBQUU7UUFDbEIsTUFBTSxHQUFHLEdBQUcsZ0JBQU0sQ0FBQyxHQUFHLEVBQUUsQ0FBQztRQUN6QixNQUFNLEtBQUssR0FBRyxJQUFJLG1CQUFLLENBQUMsR0FBRyxDQUFDLENBQUM7UUFFN0IsTUFBTSxRQUFRLEdBQUcsSUFBSSxpQkFBVyxDQUFDLEtBQUssRUFBRSxVQUFVLEVBQUU7WUFDbEQscUJBQXFCLEVBQUUsU0FBUztZQUNoQyxjQUFjLEVBQUUsVUFBVTtZQUMxQixLQUFLLEVBQUUsRUFBRTtZQUNULHNCQUFzQixFQUFFO2dCQUN0Qix3QkFBd0IsRUFBRSxLQUFLO2dCQUMvQixpQ0FBaUMsRUFBRSxLQUFLO2dCQUN4QyxpQkFBaUIsRUFBRSxtQkFBbUI7Z0JBQ3RDLG9CQUFvQixFQUFFLFNBQVM7YUFDaEM7U0FDRixDQUFDLENBQUM7UUFFSCxNQUFNLEtBQUssR0FBRyxJQUFJLG1CQUFLLENBQUMsR0FBRyxFQUFFLE9BQU8sQ0FBQyxDQUFDO1FBQ3RDLE1BQU0sUUFBUSxHQUFHLElBQUksbUJBQUssQ0FBQyxLQUFLLEVBQUUsVUFBVSxDQUFDLENBQUM7UUFDOUMsSUFBSSxxQkFBSyxDQUFDLFFBQVEsRUFBRSxPQUFPLEVBQUU7WUFDM0IsSUFBSSxFQUFFLElBQUksQ0FBQyxJQUFJLENBQUMsU0FBUyxFQUFFLHNCQUFzQixDQUFDO1NBQ25ELENBQUMsQ0FBQztRQUVILFFBQVEsQ0FBQyxRQUFRLENBQUMsS0FBSyxDQUFDLENBQUM7UUFDekIsUUFBUSxDQUFDLGFBQWEsRUFBRSxDQUFDO1FBRXpCLE1BQU0sQ0FBQyxxQkFBUSxDQUFDLFNBQVMsQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDLGVBQWUsRUFBRSxDQUFDO0lBQ3RELENBQUMsQ0FBQyxDQUFDO0lBRUgsRUFBRSxDQUFDLGNBQWMsRUFBRSxHQUFHLEVBQUU7UUFDdEIsTUFBTSxHQUFHLEdBQUcsZ0JBQU0sQ0FBQyxHQUFHLENBQUMsRUFBRSxXQUFXLEVBQUUsS0FBSyxFQUFFLENBQUMsQ0FBQztRQUMvQyxNQUFNLEtBQUssR0FBRyxJQUFJLG1CQUFLLENBQUMsR0FBRyxDQUFDLENBQUM7UUFFN0IsTUFBTSxRQUFRLEdBQUcsSUFBSSxpQkFBVyxDQUFDLEtBQUssRUFBRSxjQUFjLEVBQUU7WUFDdEQscUJBQXFCLEVBQUUsU0FBUztZQUNoQyxjQUFjLEVBQUUsY0FBYztZQUM5QixLQUFLLEVBQUUsRUFBRTtZQUNULHNCQUFzQixFQUFFO2dCQUN0Qix3QkFBd0IsRUFBRSxLQUFLO2dCQUMvQixpQ0FBaUMsRUFBRSxLQUFLO2dCQUN4QyxpQkFBaUIsRUFBRSxtQkFBbUI7Z0JBQ3RDLG9CQUFvQixFQUFFLFNBQVM7YUFDaEM7U0FDRixDQUFDLENBQUM7UUFFSCxNQUFNLEtBQUssR0FBRyxJQUFJLG1CQUFLLENBQUMsR0FBRyxFQUFFLE9BQU8sQ0FBQyxDQUFDO1FBQ3RDLE1BQU0sUUFBUSxHQUFHLElBQUksbUJBQUssQ0FBQyxLQUFLLEVBQUUsVUFBVSxDQUFDLENBQUM7UUFDOUMsSUFBSSxlQUFNLENBQUMsUUFBUSxFQUFFLGVBQWUsQ0FBQyxDQUFDO1FBRXRDLFFBQVEsQ0FBQyxRQUFRLENBQUMsS0FBSyxDQUFDLENBQUM7UUFDekIsUUFBUSxDQUFDLGFBQWEsRUFBRSxDQUFDO1FBRXpCLEdBQUcsQ0FBQyxLQUFLLEVBQUUsQ0FBQztRQUVaLE1BQU0sQ0FBQyxHQUFHLENBQUMsVUFBVSxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsUUFBUSxDQUFDLENBQUMsT0FBTyxDQUMxQyx1Q0FBdUMsQ0FDeEMsQ0FBQztJQUNKLENBQUMsQ0FBQyxDQUFDO0FBQ0wsQ0FBQyxDQUFDLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyIvKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqXG4gQ29weXJpZ2h0IEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG5cbiBMaWNlbnNlZCB1bmRlciB0aGUgQXBhY2hlIExpY2Vuc2UsIFZlcnNpb24gMi4wICh0aGUgXCJMaWNlbnNlXCIpLlxuIFlvdSBtYXkgbm90IHVzZSB0aGlzIGZpbGUgZXhjZXB0IGluIGNvbXBsaWFuY2Ugd2l0aCB0aGUgTGljZW5zZS5cbiBZb3UgbWF5IG9idGFpbiBhIGNvcHkgb2YgdGhlIExpY2Vuc2UgYXRcblxuIGh0dHA6Ly93d3cuYXBhY2hlLm9yZy9saWNlbnNlcy9MSUNFTlNFLTIuMFxuXG4gVW5sZXNzIHJlcXVpcmVkIGJ5IGFwcGxpY2FibGUgbGF3IG9yIGFncmVlZCB0byBpbiB3cml0aW5nLCBzb2Z0d2FyZVxuIGRpc3RyaWJ1dGVkIHVuZGVyIHRoZSBMaWNlbnNlIGlzIGRpc3RyaWJ1dGVkIG9uIGFuIFwiQVMgSVNcIiBCQVNJUyxcbiBXSVRIT1VUIFdBUlJBTlRJRVMgT1IgQ09ORElUSU9OUyBPRiBBTlkgS0lORCwgZWl0aGVyIGV4cHJlc3Mgb3IgaW1wbGllZC5cbiBTZWUgdGhlIExpY2Vuc2UgZm9yIHRoZSBzcGVjaWZpYyBsYW5ndWFnZSBnb3Zlcm5pbmcgcGVybWlzc2lvbnMgYW5kXG4gbGltaXRhdGlvbnMgdW5kZXIgdGhlIExpY2Vuc2UuXG4gKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKiogKi9cblxuaW1wb3J0ICogYXMgcGF0aCBmcm9tIFwicGF0aFwiO1xuaW1wb3J0IHsgUERLTmFnIH0gZnJvbSBcIi4uLy4uL3Bkay1uYWdcIjtcbmltcG9ydCB7IFN0YWNrLCBTdGFnZSB9IGZyb20gXCJhd3MtY2RrLWxpYlwiO1xuaW1wb3J0IHsgVGVtcGxhdGUgfSBmcm9tIFwiYXdzLWNkay1saWIvYXNzZXJ0aW9uc1wiO1xuaW1wb3J0IHsgQnVja2V0IH0gZnJvbSBcImF3cy1jZGstbGliL2F3cy1zM1wiO1xuaW1wb3J0IHsgQXNzZXQgfSBmcm9tIFwiYXdzLWNkay1saWIvYXdzLXMzLWFzc2V0c1wiO1xuaW1wb3J0IHsgUERLUGlwZWxpbmUgfSBmcm9tIFwiLi4vc3JjXCI7XG5cbmRlc2NyaWJlKFwiUERLIFBpcGVsaW5lIFVuaXQgVGVzdHNcIiwgKCkgPT4ge1xuICBpdChcIkRlZmF1bHRzXCIsICgpID0+IHtcbiAgICBjb25zdCBhcHAgPSBQREtOYWcuYXBwKCk7XG4gICAgY29uc3Qgc3RhY2sgPSBuZXcgU3RhY2soYXBwKTtcblxuICAgIGNvbnN0IHBpcGVsaW5lID0gbmV3IFBES1BpcGVsaW5lKHN0YWNrLCBcIkRlZmF1bHRzXCIsIHtcbiAgICAgIHByaW1hcnlTeW50aERpcmVjdG9yeTogXCJjZGsub3V0XCIsXG4gICAgICByZXBvc2l0b3J5TmFtZTogXCJEZWZhdWx0c1wiLFxuICAgICAgc3ludGg6IHt9LFxuICAgICAgc29uYXJDb2RlU2Nhbm5lckNvbmZpZzoge1xuICAgICAgICBzb25hcnF1YmVBdXRob3JpemVkR3JvdXA6IFwiZGV2XCIsXG4gICAgICAgIHNvbmFycXViZURlZmF1bHRQcm9maWxlT3JHYXRlTmFtZTogXCJkZXZcIixcbiAgICAgICAgc29uYXJxdWJlRW5kcG9pbnQ6IFwiaHR0cHM6Ly9zb25hci5kZXZcIixcbiAgICAgICAgc29uYXJxdWJlUHJvamVjdE5hbWU6IFwiRGVmYXVsdFwiLFxuICAgICAgfSxcbiAgICB9KTtcblxuICAgIGNvbnN0IHN0YWdlID0gbmV3IFN0YWdlKGFwcCwgXCJTdGFnZVwiKTtcbiAgICBjb25zdCBhcHBTdGFjayA9IG5ldyBTdGFjayhzdGFnZSwgXCJBcHBTdGFja1wiKTtcbiAgICBuZXcgQXNzZXQoYXBwU3RhY2ssIFwiQXNzZXRcIiwge1xuICAgICAgcGF0aDogcGF0aC5qb2luKF9fZGlybmFtZSwgXCJwZGstcGlwZWxpbmUudGVzdC50c1wiKSxcbiAgICB9KTtcblxuICAgIHBpcGVsaW5lLmFkZFN0YWdlKHN0YWdlKTtcbiAgICBwaXBlbGluZS5idWlsZFBpcGVsaW5lKCk7XG5cbiAgICBleHBlY3QoVGVtcGxhdGUuZnJvbVN0YWNrKHN0YWNrKSkudG9NYXRjaFNuYXBzaG90KCk7XG4gIH0pO1xuXG4gIGl0KFwiU3RhZ2VOYWdSdW5zXCIsICgpID0+IHtcbiAgICBjb25zdCBhcHAgPSBQREtOYWcuYXBwKHsgZmFpbE9uRXJyb3I6IGZhbHNlIH0pO1xuICAgIGNvbnN0IHN0YWNrID0gbmV3IFN0YWNrKGFwcCk7XG5cbiAgICBjb25zdCBwaXBlbGluZSA9IG5ldyBQREtQaXBlbGluZShzdGFjaywgXCJTdGFnZU5hZ1J1bnNcIiwge1xuICAgICAgcHJpbWFyeVN5bnRoRGlyZWN0b3J5OiBcImNkay5vdXRcIixcbiAgICAgIHJlcG9zaXRvcnlOYW1lOiBcIlN0YWdlTmFnUnVuc1wiLFxuICAgICAgc3ludGg6IHt9LFxuICAgICAgc29uYXJDb2RlU2Nhbm5lckNvbmZpZzoge1xuICAgICAgICBzb25hcnF1YmVBdXRob3JpemVkR3JvdXA6IFwiZGV2XCIsXG4gICAgICAgIHNvbmFycXViZURlZmF1bHRQcm9maWxlT3JHYXRlTmFtZTogXCJkZXZcIixcbiAgICAgICAgc29uYXJxdWJlRW5kcG9pbnQ6IFwiaHR0cHM6Ly9zb25hci5kZXZcIixcbiAgICAgICAgc29uYXJxdWJlUHJvamVjdE5hbWU6IFwiRGVmYXVsdFwiLFxuICAgICAgfSxcbiAgICB9KTtcblxuICAgIGNvbnN0IHN0YWdlID0gbmV3IFN0YWdlKGFwcCwgXCJTdGFnZVwiKTtcbiAgICBjb25zdCBhcHBTdGFjayA9IG5ldyBTdGFjayhzdGFnZSwgXCJBcHBTdGFja1wiKTtcbiAgICBuZXcgQnVja2V0KGFwcFN0YWNrLCBcIk5vbi1Db21wbGlhbnRcIik7XG5cbiAgICBwaXBlbGluZS5hZGRTdGFnZShzdGFnZSk7XG4gICAgcGlwZWxpbmUuYnVpbGRQaXBlbGluZSgpO1xuXG4gICAgYXBwLnN5bnRoKCk7XG5cbiAgICBleHBlY3QoYXBwLm5hZ1Jlc3VsdHMoKVswXS5yZXNvdXJjZSkudG9FcXVhbChcbiAgICAgIFwiU3RhZ2UvQXBwU3RhY2svTm9uLUNvbXBsaWFudC9SZXNvdXJjZVwiXG4gICAgKTtcbiAgfSk7XG59KTtcbiJdfQ==