import numpy as np
from numpy.lib.mixins import NDArrayOperatorsMixin
from pandas import compat as compat
from pandas.core import nanops as nanops
from pandas.core.algorithms import searchsorted as searchsorted, take as take, unique as unique
from pandas.core.arrays.base import ExtensionArray as ExtensionArray, ExtensionOpsMixin as ExtensionOpsMixin
from pandas.core.construction import extract_array as extract_array
from pandas.core.dtypes.dtypes import ExtensionDtype as ExtensionDtype
from pandas.core.dtypes.generic import ABCIndexClass as ABCIndexClass, ABCSeries as ABCSeries
from pandas.core.dtypes.inference import is_array_like as is_array_like
from pandas.core.dtypes.missing import isna as isna

from pandas.core.missing import backfill_1d as backfill_1d, pad_1d as pad_1d
from pandas.util._decorators import Appender as Appender
from pandas.util._validators import validate_fillna_kwargs as validate_fillna_kwargs
from typing import Any, Optional, Union

class PandasDtype(ExtensionDtype):
    def __init__(self, dtype: Any) -> None: ...
    @property
    def numpy_dtype(self) -> Any: ...
    @property
    def name(self) -> Any: ...
    @property
    def type(self) -> Any: ...
    @classmethod
    def construct_from_string(cls, string: Any) -> Any: ...
    @classmethod
    def construct_array_type(cls) -> Any: ...
    @property
    def kind(self) -> Any: ...
    @property
    def itemsize(self) -> Any: ...

class PandasArray(ExtensionArray, ExtensionOpsMixin, NDArrayOperatorsMixin):    # type: ignore
    __array_priority__: int = ...
    def __init__(self, values: Union[np.ndarray, PandasArray], copy: bool=...) -> None: ...
    @property
    def dtype(self) -> Any: ...
    def __array__(self, dtype: Any = ...) -> np.ndarray: ...
    def __array_ufunc__(self, ufunc: Any, method: Any, *inputs: Any, **kwargs: Any) -> Any: ...
    def __getitem__(self, item: Any) -> Any: ...
    def __setitem__(self, key: Any, value: Any) -> None: ...
    def __len__(self) -> int: ...
    @property
    def nbytes(self) -> int: ...
    def isna(self) -> Any: ...
    def fillna(self, value: Optional[Any] = ..., method: Optional[Any] = ..., limit: Optional[Any] = ...) -> Any: ...
    def take(self, indices: Any, allow_fill: bool = ..., fill_value: Optional[Any] = ...) -> Any: ...
    def copy(self) -> Any: ...
    def unique(self) -> Any: ...
    def any(self, axis: Optional[Any] = ..., out: Optional[Any] = ..., keepdims: bool = ..., skipna: bool = ...) -> Any: ...
    def all(self, axis: Optional[Any] = ..., out: Optional[Any] = ..., keepdims: bool = ..., skipna: bool = ...) -> Any: ...
    def min(self, axis: Optional[Any] = ..., out: Optional[Any] = ..., keepdims: bool = ..., skipna: bool = ...) -> Any: ...
    def max(self, axis: Optional[Any] = ..., out: Optional[Any] = ..., keepdims: bool = ..., skipna: bool = ...) -> Any: ...
    def sum(self, axis: Optional[Any] = ..., dtype: Optional[Any] = ..., out: Optional[Any] = ..., keepdims: bool = ..., initial: Optional[Any] = ..., skipna: bool = ..., min_count: int = ...) -> Any: ...
    def prod(self, axis: Optional[Any] = ..., dtype: Optional[Any] = ..., out: Optional[Any] = ..., keepdims: bool = ..., initial: Optional[Any] = ..., skipna: bool = ..., min_count: int = ...) -> Any: ...
    def mean(self, axis: Optional[Any] = ..., dtype: Optional[Any] = ..., out: Optional[Any] = ..., keepdims: bool = ..., skipna: bool = ...) -> Any: ...
    def median(self, axis: Optional[Any] = ..., out: Optional[Any] = ..., overwrite_input: bool = ..., keepdims: bool = ..., skipna: bool = ...) -> Any: ...
    def std(self, axis: Optional[Any] = ..., dtype: Optional[Any] = ..., out: Optional[Any] = ..., ddof: int = ..., keepdims: bool = ..., skipna: bool = ...) -> Any: ...
    def var(self, axis: Optional[Any] = ..., dtype: Optional[Any] = ..., out: Optional[Any] = ..., ddof: int = ..., keepdims: bool = ..., skipna: bool = ...) -> Any: ...
    def sem(self, axis: Optional[Any] = ..., dtype: Optional[Any] = ..., out: Optional[Any] = ..., ddof: int = ..., keepdims: bool = ..., skipna: bool = ...) -> Any: ...
    def kurt(self, axis: Optional[Any] = ..., dtype: Optional[Any] = ..., out: Optional[Any] = ..., keepdims: bool = ..., skipna: bool = ...) -> Any: ...
    def skew(self, axis: Optional[Any] = ..., dtype: Optional[Any] = ..., out: Optional[Any] = ..., keepdims: bool = ..., skipna: bool = ...) -> Any: ...
    def to_numpy(self, dtype: Optional[Any] = ..., copy: bool = ..., na_value: Any = ...) -> Any: ...
    def searchsorted(self, value: Any, side: str = ..., sorter: Optional[Any] = ...) -> Any: ...
    def __invert__(self) -> Any: ...
