import numpy as np
from pandas._typing import Dtype as Dtype
from pandas.core import algorithms as algorithms
from pandas.core.dtypes.cast import astype_nansafe as astype_nansafe

from pandas.core.dtypes.generic import ABCFloat64Index as ABCFloat64Index, ABCInt64Index as ABCInt64Index, ABCRangeIndex as ABCRangeIndex, ABCSeries as ABCSeries, ABCUInt64Index as ABCUInt64Index
from pandas.core.dtypes.missing import isna as isna
from pandas.core.indexes.base import Index as Index, InvalidIndexError as InvalidIndexError, maybe_extract_name as maybe_extract_name
from pandas.core.ops import get_op_result_name as get_op_result_name
from pandas.util._decorators import Appender as Appender, cache_readonly as cache_readonly
from typing import Any, Optional

class NumericIndex(Index):
    def __new__(cls, data: Optional[Any] = ..., dtype: Optional[Any] = ..., copy: bool = ..., name: Optional[Any] = ...) -> Any: ...
    @property
    def is_all_dates(self) -> bool: ...
    def insert(self, loc: Any, item: Any) -> Any: ...

class IntegerIndex(NumericIndex):
    def __contains__(self, key: Any) -> bool: ...

class Int64Index(IntegerIndex):
    __doc__: Any = ...
    @property
    def inferred_type(self) -> str: ...
    @property
    def asi8(self) -> np.ndarray: ...

class UInt64Index(IntegerIndex):
    __doc__: Any = ...
    @property
    def inferred_type(self) -> str: ...
    @property
    def asi8(self) -> np.ndarray: ...

class Float64Index(NumericIndex):
    __doc__: Any = ...
    @property
    def inferred_type(self) -> str: ...
    def astype(self, dtype: Any, copy: bool = ...) -> Any: ...
    def get_value(self, series: Any, key: Any) -> Any: ...
    def equals(self, other: Any) -> bool: ...
    def __contains__(self, other: Any) -> bool: ...
    def get_loc(self, key: Any, method: Optional[Any] = ..., tolerance: Optional[Any] = ...) -> Any: ...
    def is_unique(self) -> bool: ...
    def isin(self, values: Any, level: Optional[Any] = ...) -> Any: ...
